/*
 * Copyright 2000-2014 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.javaee.model.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.javaee.web.CommonParamValue;
import com.intellij.javaee.web.WebCommonClassNames;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementRef;

/**
 * @author peter
 */
public abstract class JamInitParam implements CommonParamValue, JamElement{

  public static final JamStringAttributeMeta.Single<String> NAME_META = JamAttributeMeta.singleString("name");
  public static final JamStringAttributeMeta.Single<String> VALUE_META = JamAttributeMeta.singleString("value");

  static final JamAnnotationMeta JAVAX_INIT_PARAM_ANNO_META = new JamAnnotationMeta(WebCommonClassNames.ANNOTATION_INIT_PARAM.javax());
  static final JamAnnotationMeta JAKARTA_INIT_PARAM_ANNO_META = new JamAnnotationMeta(WebCommonClassNames.ANNOTATION_INIT_PARAM.jakarta());

  @JamPsiConnector
  public abstract PsiElementRef<PsiAnnotation> getAnno();

  @JamPsiValidity
  public abstract boolean isPsiValid();

  @Override
  public JamStringAttributeElement<String> getParamName() {
    return NAME_META.getJam(getAnno());
  }

  @Override
  public JamStringAttributeElement<String> getParamValue() {
    return VALUE_META.getJam(getAnno());
  }
}
