/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.constants;

import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.psi.CommonClassNames;
import org.jetbrains.annotations.NonNls;

public interface JavaeeCommonConstants {

  @NonNls String EJB_NAMESPACE_KEY = "EJB namespace";
  @NonNls String WEB_NAMESPACE_KEY = "Web namespace";
  @NonNls String APP_NAMESPACE_KEY = "Javaee application namespace";

  @NonNls String APPLICATION_XML_ROOT_TAG = "application";
  @NonNls String WEB_XML_ROOT_TAG = "web-app";
  @NonNls String WEB_FRAGMENT_ROOT_TAG = "web-fragment";
  @NonNls String EJB_JAR_XML_ROOT_TAG = "ejb-jar";

  @NonNls JavaeeClass JAVAX_EJB_PACKAGE_PREFIX = JavaeeClass.create("javax.ejb.");

  String SERIALIZABLE_CLASS = "java.io.Serializable";
  String EXTERNALIZABLE_CLASS = "java.io.Externalizable";
  String OBJECT_CLASS = CommonClassNames.JAVA_LANG_OBJECT;
  String BIG_INTEGER_CLASS = "java.math.BigInteger";
  String BIG_DECIMAL_CLASS = "java.math.BigDecimal";
  String SQL_DATE_CLASS = "java.sql.Date";
  String SQL_TIME_CLASS = "java.sql.Time";
  String SQL_TIMESTAMP_CLASS = "java.sql.Timestamp";
  String UTIL_CALENDAR_CLASS = "java.util.Calendar";

  JavaeeClass INTERCEPTOR_INVOCATION_CONTEXT_CLASS = JavaeeClass.create("javax.interceptor.InvocationContext");
  String JAVA_LANG_OBJECT_CLASS = CommonClassNames.JAVA_LANG_OBJECT;
  JavaeeClass MESSAGE_DRIVEN_BEAN_CLASS = JavaeeClass.create("javax.ejb.MessageDrivenBean");
  JavaeeClass SESSION_BEAN_CLASS = JavaeeClass.create("javax.ejb.SessionBean");
  JavaeeClass TIMED_OBJECT_CLASS = JavaeeClass.create("javax.ejb.TimedObject");
  JavaeeClass SESSION_SYNCHRONIZATION_CLASS = JavaeeClass.create("javax.ejb.SessionSynchronization");
  JavaeeClass ENTITY_BEAN_CLASS = JavaeeClass.create("javax.ejb.EntityBean");

  String REMOTE_EXCEPTION_CLASS = "java.rmi.RemoteException";
  String REMOTE_INTERFACE_CLASS = "java.rmi.Remote";
  JavaeeClass JAVAX_EJB_FINDER_EXCEPTION_CLASS = JavaeeClass.create("javax.ejb.FinderException");
  JavaeeClass JAVAX_EJB_CREATE_EXCEPTION_CLASS = JavaeeClass.create("javax.ejb.CreateException");

  JavaeeClass SESSION_CONTEXT_CLASS = JavaeeClass.create("javax.ejb.SessionContext");
  JavaeeClass MESSAGE_DRIVEN_CONTEXT_CLASS = JavaeeClass.create("javax.ejb.MessageDrivenContext");
  JavaeeClass ENTITY_CONTEXT_CLASS = JavaeeClass.create("javax.ejb.EntityContext");
  @NonNls String JMS_ACKNOWLEDGE_MODE_PROPERTY_NAME = "acknowledgeMode";
  @NonNls String JMS_MESSAGE_SELECTOR_PROPERTY_NAME = "messageSelector";
  @NonNls String JMS_DESTINATION_TYPE_PROPERTY_NAME = "destinationType";
  @NonNls String JMS_SUBSCRIPTION_DURABILITY_TYPE_PROPERTY_NAME = "subscriptionDurability";
  JavaeeClass QUEUE_DEST_TYPE = JavaeeClass.create("javax.jms.Queue");
  JavaeeClass TOPIC_DEST_TYPE = JavaeeClass.create("javax.jms.Topic");
  JavaeeClass JMS_MESSAGE_LISTENER_CLASS = JavaeeClass.create("javax.jms.MessageListener");
  @NonNls String CLASS_POSTFIX = CommonClassNames.CLASS_FILE_EXTENSION;
  @NonNls String ABSTRACT_SCHEMA_NAME = "abstract-schema-name";
  @NonNls String COLLECTION_CLASS = "java.util.Collection";
  @NonNls String MAP_CLASS = CommonClassNames.JAVA_UTIL_MAP;
  @NonNls String SET_CLASS = CommonClassNames.JAVA_UTIL_SET;
  @NonNls String LIST_CLASS = CommonClassNames.JAVA_UTIL_LIST;
  @NonNls String META_INF = "META-INF";

  @NonNls String J2EE_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
  @NonNls String JAVAEE_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
  @NonNls String JAVAEE7_NAMESPACE = "http://xmlns.jcp.org/xml/ns/javaee";
  @NonNls String JAVAEE8_NAMESPACE = "http://xmlns.jcp.org/xml/ns/javaee";
  @NonNls String JAKARTA9_NAMESPACE = "https://jakarta.ee/xml/ns/jakartaee";

  @NonNls String EJB_JAR_1_0_DTD = "http://java.sun.com/j2ee/dtds/ejb-jar_1_0.dtd";
  @NonNls String EJB_JAR_1_1_DTD = "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd";
  @NonNls String EJB_JAR_2_0_DTD = "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
  @NonNls String EJB_1_0_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.0//EN";
  @NonNls String EJB_1_1_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
  @NonNls String EJB_2_0_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
  @NonNls String VERSION_ATTR = "version";

  @NonNls JavaeeClass SERVLET_CLASS = JavaeeClass.create("javax.servlet.Servlet");
  @NonNls JavaeeClass JSP_PAGE_CLASS = JavaeeClass.create("javax.servlet.jsp.JspPage");

  String JAVAEE_TYPE_TEMPLATE_VAR = "JAVAEE_TYPE";
}
