/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.javaee.constants;

import com.intellij.javaee.utils.JavaeeClass;
import org.jetbrains.annotations.NonNls;

public interface JavaeeAnnotationConstants  {

  @NonNls String VALUE_PARAM = "value";
  @NonNls String NAME_PARAM = "name";

  // *** javax.annotation.security ***
  @NonNls JavaeeClass DECLARE_ROLES_ANNO =JavaeeClass.create("javax.annotation.security.DeclareRoles");
  @NonNls JavaeeClass DENY_ALL_ANNO =JavaeeClass.create("javax.annotation.security.DenyAll");
  @NonNls JavaeeClass PERMIT_ALL_ANNO =JavaeeClass.create("javax.annotation.security.PermitAll");
  @NonNls JavaeeClass ROLES_ALLOWED_ANNO =JavaeeClass.create("javax.annotation.security.RolesAllowed");
  @NonNls JavaeeClass RUN_AS_ANNO =JavaeeClass.create("javax.annotation.security.RunAs");

  // *** javax.interceptor ***
  @NonNls JavaeeClass AROUND_INVOKE_ANNO =JavaeeClass.create("javax.interceptor.AroundInvoke");
  @NonNls JavaeeClass EXCLUDE_CLASS_INTERCEPTORS_ANNO =JavaeeClass.create("javax.interceptor.ExcludeClassInterceptors");
  @NonNls JavaeeClass EXCLUDE_DEFAULT_INTERCEPTORS_ANNO =JavaeeClass.create("javax.interceptor.ExcludeDefaultInterceptors");

  @NonNls String JAVAX_INTERCEPTORS_ANNO= "javax.interceptor.Interceptors";
  @NonNls JavaeeClass INTERCEPTORS_ANNO =JavaeeClass.create(JAVAX_INTERCEPTORS_ANNO);

  @NonNls JavaeeClass POST_CONSTRUCT_ANNO =JavaeeClass.create("javax.annotation.PostConstruct");
  @NonNls JavaeeClass PRE_DESTROY_ANNO =JavaeeClass.create("javax.annotation.PreDestroy");
  @NonNls JavaeeClass RESOURCE_ANNO = JavaeeClass.create("javax.annotation.Resource");
  
  @NonNls String RESOURCE_AUTHENTICATION_TYPE_PARAM = "authenticationType";
  @NonNls String RESOURCE_DESCRIPTION_PARAM = "description";
  @NonNls String RESOURCE_MAPPED_NAME_PARAM = "mappedName";
  @NonNls String RESOURCE_SHAREABLE_PARAM = "shareable";
  @NonNls String RESOURCE_TYPE_PARAM = "type";
  @NonNls String RESOURCE_LOOKUP_PARAM = "lookup";
  @NonNls JavaeeClass RESOURCES_ANNO =JavaeeClass.create("javax.annotation.Resources");
  @NonNls String REFERENCE_MAPPED_NAME_PARAM = RESOURCE_MAPPED_NAME_PARAM;
  @NonNls String REFERENCE_NAME_PARAM = "name";
  @NonNls String REFERENCE_TYPE_PARAM = RESOURCE_TYPE_PARAM;

  // *** javax.xml.ws ***
  @NonNls JavaeeClass WEB_SERVICE_REF_ANNO = JavaeeClass.create("javax.xml.ws.WebServiceRef");
  @NonNls JavaeeClass WEB_SERVICE_REFS_ANNO = JavaeeClass.create("javax.xml.ws.WebServiceRefs");
  @NonNls String WSDL_LOCATION_PARAM = "wsdlLocation";

    // *** javax.jws ***
  @NonNls JavaeeClass WEB_METHOD_ANNO =JavaeeClass.create("javax.jws.WebMethod");
  @NonNls String JAVAX_WEB_SERVICE_ANNO ="javax.jws.WebService";
  @NonNls JavaeeClass WEB_SERVICE_ANNO =JavaeeClass.create("javax.jws.WebService");
  @NonNls String WEB_SERVICE_ENDPOINT_INTERFACE_PARAM = "endpointInterface";
}
