// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run.lifecycle.tabs;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.ConfigurableBase;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.NlsContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Provides configuration for tabs in "Endpoints" run toolwindow.
 *
 * @param <UI> Must return {@link javax.swing.JPanel} from {@link ConfigurableUi#getComponent()}. Header with {@link #getDisplayName()} will
 *             be added automatically.
 * @param <S>  Settings.
 */
public abstract class EndpointTabConfigurable<UI extends ConfigurableUi<S>, S> extends ConfigurableBase<UI, S> {

  public static final ExtensionPointName<EndpointTabConfigurable> EP_NAME =
    ExtensionPointName.create("com.intellij.spring.boot.run.endpointTabConfigurable");

  protected EndpointTabConfigurable(@NotNull String id,
                                    @NotNull @NlsContexts.ConfigurableName String displayName,
                                    @Nullable String helpTopic) {
    super(id, displayName, helpTopic);
  }
}
