// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SpringBootApplicationUrlUtil {
  static SpringBootApplicationUrlUtil getInstance() {
    return ApplicationManager.getApplication().getService(SpringBootApplicationUrlUtil.class);
  }

  @Nullable
  String getServletPath(@NotNull SpringBootApplicationInfo info, @Nullable String path);

  @NotNull
  String getMappingUrl(@NotNull String applicationUrl, @Nullable String servletPath, @Nullable String path);

  void updatePath(@NotNull Project project, @NotNull SpringBootApplicationRunConfigurationBase runConfiguration, String path);
}
