// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.project.Project;

public final class CodeAnalyzerLivePropertyListener implements LiveProperty.LivePropertyListener {
  private final Project myProject;

  public CodeAnalyzerLivePropertyListener(Project project) {
    myProject = project;
  }

  @Override
  public void propertyChanged() {
    DaemonCodeAnalyzer.getInstance(myProject).restart();
  }
}
