// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SpringBootApplicationConfigurationTypeBase implements ConfigurationType {
  @NotNull
  public static SpringBootApplicationConfigurationTypeBase getInstance() {
    return ConfigurationTypeUtil.findConfigurationType(SpringBootApplicationConfigurationTypeBase.class);
  }

  public abstract ConfigurationFactory getDefaultConfigurationFactory();
}
