// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

/**
 * Spring Boot IDE settings (Languages & Frameworks | Spring | Spring Boot) for current project.
 */
public abstract class SpringBootSettings implements Disposable {

  public abstract boolean isShowAdditionalConfigNotification();

  public abstract void setShowAdditionalConfigNotification(boolean showAdditionalConfigNotification);

  public abstract boolean isAutoCreateRunConfiguration();

  public abstract void setAutoCreateRunConfiguration(boolean autoCreateRunConfiguration);

  public abstract boolean isReformatAfterCreation();

  public abstract void setReformatAfterCreation(boolean reformatAfterCreation);

  public static SpringBootSettings getInstance(@NotNull Project project) {
    return ServiceManager.getService(project, SpringBootSettings.class);
  }
}
