// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;

import java.util.List;

public abstract class SpringBootAutoConfigClassFilterService {

  public static SpringBootAutoConfigClassFilterService getInstance() {
    return ApplicationManager.getApplication().getService(SpringBootAutoConfigClassFilterService.class);
  }

  public abstract List<PsiClass> filterByConditionalOnClass(Module module, List<PsiClass> configs);
}
