// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.model;

import com.intellij.spring.facet.SpringAutodetectedFileSet;
import com.intellij.spring.facet.SpringFileSet;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * Provides additional auto-detected Spring Boot file sets (e.g. bootstrap files set containing bootstrap configurations).
 * @author Konstantin Aleev
 */
public interface SpringBootModelExtender {
  @NotNull
  List<? extends SpringAutodetectedFileSet> getAdditionalFileSets(SpringFileSet springBootFileSet);
}
