// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot;

import com.intellij.DynamicBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

import java.util.function.Supplier;

public final class SpringBootApiBundle extends DynamicBundle {

  public static @Nls String message(@NotNull @PropertyKey(resourceBundle = PATH_TO_BUNDLE) String key, Object @NotNull ... params) {
    return ourInstance.getMessage(key, params);
  }

  @NotNull
  public static Supplier<@Nls String> messagePointer(@NotNull @PropertyKey(resourceBundle = PATH_TO_BUNDLE) String key,
                                             Object @NotNull ... params) {
    return ourInstance.getLazyMessage(key, params);
  }

  @NonNls
  private static final String PATH_TO_BUNDLE = "messages.SpringBootApiBundle";
  private static final SpringBootApiBundle ourInstance = new SpringBootApiBundle();

  private SpringBootApiBundle() {
    super(PATH_TO_BUNDLE);
  }
}
