/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.ejbc;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.util.Version;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.ejbc.AbstractOutputParser;
import com.intellij.javaee.weblogic.ejbc.EjbcError;
import com.intellij.javaee.weblogic.ejbc.EjbcOutputParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.TimeoutUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EjbcRunner {
    private final String myCompilerName;
    private final String myCompilerClassName;
    private final Version myVersion;
    @NonNls
    private static final String FORCE_GENERATION_PARAM_NAME = "-forceGeneration";
    private final String myPresentableName;
    private final Module myModule;
    private final Project myProject;

    public EjbcRunner(JavaeeFacet facet, Version version) {
        this(facet, WeblogicBundle.message("ejbc.compiler.name", new Object[0]), "weblogic.ejbc", version);
    }

    public EjbcRunner(Artifact artifact, Project project, Version version) {
        this(artifact, project, WeblogicBundle.message("ejbc.compiler.name", new Object[0]), "weblogic.ejbc", version);
    }

    protected EjbcRunner(JavaeeFacet facet, String compilerName, @NonNls String compilerClassName, Version version) {
        this.myCompilerName = compilerName;
        this.myCompilerClassName = compilerClassName;
        this.myVersion = version;
        this.myModule = facet.getModule();
        this.myPresentableName = facet.getName();
        this.myProject = this.myModule.getProject();
    }

    protected EjbcRunner(Artifact artifact, Project project, String compilerName, @NonNls String compilerClassName, Version version) {
        this.myCompilerName = compilerName;
        this.myCompilerClassName = compilerClassName;
        this.myVersion = version;
        this.myModule = null;
        this.myPresentableName = artifact.getName();
        this.myProject = project;
    }

    public void run(File path, CompileContext context, ApplicationServer server) throws ExecutionException {
        GeneralCommandLine[] commandLine = new GeneralCommandLine[1];
        CantRunException[] cantRunException = new CantRunException[]{null};
        ApplicationManager.getApplication().runReadAction(() -> {
            Sdk jdk;
            context.getProgressIndicator().setText(WeblogicBundle.message("progress.text.running.compilername.for.module", this.myCompilerName, this.myPresentableName));
            Sdk sdk = jdk = this.myModule != null ? ModuleRootManager.getInstance((Module)this.myModule).getSdk() : null;
            if (jdk == null) {
                jdk = ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk();
            }
            try {
                String toolsJarPath;
                VirtualFile[] files;
                if (jdk == null) {
                    throw new CantRunException(WeblogicBundle.message("exception.text.jdk.not.specified", new Object[0]));
                }
                if (this.myVersion.getMajor() < 9 && JavaSdk.getInstance().getVersion(jdk) != JavaSdkVersion.JDK_1_4) {
                    String versionString = jdk.getVersionString();
                    String message = this.myModule != null ? WeblogicBundle.message("ejbc.runner.invalid.jdk.error.text", this.myCompilerName, versionString, this.myModule.getName()) : WeblogicBundle.message("ejbc.runner.invalid.project.jdk.error.text", this.myCompilerName, versionString);
                    context.addMessage(CompilerMessageCategory.WARNING, message, null, -1, -1);
                    return;
                }
                JavaParameters javaParameters = new JavaParameters();
                javaParameters.setJdk(jdk);
                for (VirtualFile file : files = server.getLibrary().getFiles(OrderRootType.CLASSES)) {
                    javaParameters.getClassPath().add(file);
                }
                if (jdk.getSdkType() instanceof JavaSdkType && (toolsJarPath = ((JavaSdkType)jdk.getSdkType()).getToolsPath(jdk)) != null) {
                    javaParameters.getClassPath().add(toolsJarPath);
                }
                javaParameters.setMainClass(this.myCompilerClassName);
                javaParameters.getProgramParametersList().add(FORCE_GENERATION_PARAM_NAME, path.getPath());
                javaParameters.setWorkingDirectory(path.isDirectory() ? path : path.getParentFile());
                commandLine[0] = javaParameters.toCommandLine();
            }
            catch (CantRunException e) {
                cantRunException[0] = e;
            }
        });
        if (cantRunException[0] != null) {
            throw cantRunException[0];
        }
        if (commandLine[0] == null) {
            return;
        }
        final AbstractOutputParser ejbcOutput = this.createCompilerOutputParser();
        KillableColoredProcessHandler handler = new KillableColoredProcessHandler(commandLine[0]);
        final CheckCancelRunnable checkCancelRunnable = new CheckCancelRunnable(context, (OSProcessHandler)handler);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDERR) {
                    ejbcOutput.outputAvailable(event.getText());
                    ejbcOutput.parseAvailableOutput();
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                ejbcOutput.parseAvailableOutput();
                String output = ejbcOutput.getOutput();
                if (output.length() != 0) {
                    EjbcError error = new EjbcError(output, CompilerMessageCategory.ERROR);
                    ejbcOutput.addMessage(error);
                }
                checkCancelRunnable.cancel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javaee/weblogic/ejbc/EjbcRunner$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        handler.startNotify();
        checkCancelRunnable.run();
        if (context.getProgressIndicator().isCanceled()) {
            return;
        }
        List<EjbcError> messages = ejbcOutput.getMessages();
        for (EjbcError error : messages) {
            @NlsSafe String message = error.getMessage();
            context.addMessage(error.getMessageCategory(), message, null, -1, -1);
        }
        if (messages.size() == 0) {
            context.addMessage(CompilerMessageCategory.INFORMATION, WeblogicBundle.message("message.text.compiler.for.module.finished.successfully", this.myCompilerName, this.myPresentableName), null, -1, -1);
        }
    }

    protected AbstractOutputParser createCompilerOutputParser() {
        return new EjbcOutputParser();
    }

    private static final class CheckCancelRunnable
    implements Runnable {
        private final OSProcessHandler myProcessHandler;
        private boolean myCanceled;
        private final CompileContext myContext;

        private CheckCancelRunnable(CompileContext context, OSProcessHandler process) {
            this.myContext = context;
            this.myProcessHandler = process;
        }

        public void cancel() {
            this.myCanceled = true;
        }

        @Override
        public void run() {
            while (!this.myCanceled) {
                if (this.myContext.getProgressIndicator().isCanceled()) {
                    this.myProcessHandler.destroyProcess();
                    return;
                }
                TimeoutUtil.sleep((long)100L);
            }
        }
    }
}

