/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.actions.version9;

import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.actions.WeblogicCreateDatasourceDialog;
import com.intellij.javaee.weblogic.actions.version9.ConnectionSettingsPanel;
import com.intellij.javaee.weblogic.agent.WebLogicAgent9Extension;
import com.intellij.javaee.weblogic.agent.WebLogicAgentExtension;
import com.intellij.javaee.weblogic.dataSource.WeblogicConnectionPoolInfoImpl;
import com.intellij.javaee.weblogic.dataSource.WeblogicDataSourceErrorHandlerImpl;
import com.intellij.javaee.weblogic.dataSource.WeblogicDataSourceInfoImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class Weblogic9CreateDatasourceDialog
extends WeblogicCreateDatasourceDialog {
    private JRadioButton myNoneTransactionProtocol;
    private JRadioButton myOnePhaseProtocol;
    private JRadioButton myTwoPhaseCommit;
    private ConnectionSettingsPanel myConnectionSettings;

    public Weblogic9CreateDatasourceDialog(Project project, WebLogicAgentExtension agentExtension, String dsName) {
        super(project, agentExtension, dsName);
        this.init();
        this.setTitle(WeblogicBundle.message("dialog.title.create.new.datasource", new Object[0]));
    }

    @Override
    protected JPanel createConnectionSettingsPanel() {
        this.myConnectionSettings = new ConnectionSettingsPanel();
        return this.myConnectionSettings.getSettingsPanel();
    }

    @Override
    protected JPanel createDataSourceTypeHolder() {
        JPanel panel = new JPanel();
        panel.setBorder(IdeBorderFactory.createTitledBorder((String)WeblogicBundle.message("option.group.create.datasource.global.transaction.protocol", new Object[0])));
        this.myNoneTransactionProtocol = new JRadioButton(WeblogicBundle.message("radio.create.datasource.protocol.none", new Object[0]), false);
        panel.add(this.myNoneTransactionProtocol);
        this.myOnePhaseProtocol = new JRadioButton(WeblogicBundle.message("radio.create.datasource.protocol.one.phase.commit", new Object[0]), false);
        panel.add(this.myOnePhaseProtocol);
        this.myTwoPhaseCommit = new JRadioButton(WeblogicBundle.message("radio.create.datasource.protocol.two.phase.commit", new Object[0]), true);
        panel.add(this.myTwoPhaseCommit);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myNoneTransactionProtocol);
        buttonGroup.add(this.myOnePhaseProtocol);
        buttonGroup.add(this.myTwoPhaseCommit);
        return panel;
    }

    @Override
    protected WeblogicDataSourceInfoImpl getDataSourceInfo() throws Exception {
        WeblogicDataSourceInfoImpl info = super.getDataSourceInfo();
        info.setTxDataSource(!this.myNoneTransactionProtocol.isSelected());
        info.setEnableTwoPhaseCommit(this.myTwoPhaseCommit.isSelected());
        return info;
    }

    protected void doOKAction() {
        try {
            WeblogicDataSourceInfoImpl dataSourceInfo = this.getDataSourceInfo();
            WeblogicConnectionPoolInfoImpl connectionPoolInfo = this.myConnectionSettings.getConnectionPoolInfo();
            WeblogicDataSourceErrorHandlerImpl errorHandler = new WeblogicDataSourceErrorHandlerImpl();
            ((WebLogicAgent9Extension)this.getAgentExtension()).createDatasource(dataSourceInfo, connectionPoolInfo, errorHandler);
            String error = errorHandler.getError();
            if (!StringUtil.isEmpty((String)error)) {
                Weblogic9CreateDatasourceDialog.handleError(error);
                return;
            }
            super.doOKAction();
        }
        catch (Exception e) {
            Weblogic9CreateDatasourceDialog.handleError(e.getMessage());
        }
    }

    private static void handleError(String errorMessage) {
        Messages.showMessageDialog((String)WeblogicBundle.message("message.text.error.creating.new.data.source", errorMessage), (String)WeblogicBundle.message("message.title.error", new Object[0]), (Icon)Messages.getErrorIcon());
    }
}

