/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.recommenders.python.decorating;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.recommenders.decorating.StarDecoratedIcon;
import com.intellij.recommenders.python.engines.PyFrequenciesFeaturesProviderKt;
import com.intellij.recommenders.python.util.MapProbabilitiesFromModelsForProposal;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0014\u0010\r\u001a\u00020\t2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/recommenders/python/decorating/MyLookupElementCustomizer;", "Lcom/intellij/codeInsight/lookup/impl/LookupCellRenderer$ItemPresentationCustomizer;", "()V", "customizePresentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "presentation", "formatDoubleValue", "", "value", "", "formatModelName", "formatProbability", "recommendation", "Lcom/intellij/recommenders/python/util/MapProbabilitiesFromModelsForProposal;", "Companion", "intellij.recommenders.python"})
final class MyLookupElementCustomizer
implements LookupCellRenderer.ItemPresentationCustomizer {
    private static final DecimalFormat SMALL_NUMBERS;
    private static final DecimalFormat LARGE_NUMBERS;
    public static final Companion Companion;

    @NotNull
    public LookupElementPresentation customizePresentation(@NotNull LookupElement item, @NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        MapProbabilitiesFromModelsForProposal mapProbabilitiesFromModelsForProposal = (MapProbabilitiesFromModelsForProposal)item.getUserData(PyFrequenciesFeaturesProviderKt.getPYTHON_FREQUENCIES_PROBABILITY());
        if (mapProbabilitiesFromModelsForProposal == null) {
            return presentation;
        }
        Intrinsics.checkNotNullExpressionValue((Object)mapProbabilitiesFromModelsForProposal, (String)"item.getUserData(PYTHON_\u2026Y) ?: return presentation");
        MapProbabilitiesFromModelsForProposal recommendation = mapProbabilitiesFromModelsForProposal;
        LookupElementPresentation newPresentation = new LookupElementPresentation();
        newPresentation.copyFrom(presentation);
        newPresentation.setIcon((Icon)StarDecoratedIcon.Companion.create(presentation.getIcon()));
        newPresentation.appendTailText(" - " + this.formatProbability(recommendation) + " %", true);
        return newPresentation;
    }

    private final String formatProbability(MapProbabilitiesFromModelsForProposal<?> recommendation) {
        return CollectionsKt.joinToString$default((Iterable)recommendation.getProbabilities().entrySet(), (CharSequence)"|", null, null, (int)0, null, (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends Double>, CharSequence>(this){
            final /* synthetic */ MyLookupElementCustomizer this$0;

            @NotNull
            public final CharSequence invoke(@NotNull Map.Entry<String, Double> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return MyLookupElementCustomizer.access$formatModelName(this.this$0, it.getKey()) + ':' + MyLookupElementCustomizer.access$formatDoubleValue(this.this$0, ((Number)it.getValue()).doubleValue());
            }
            {
                this.this$0 = myLookupElementCustomizer;
                super(1);
            }
        }), (int)30, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String formatModelName(String value) {
        String string = value;
        switch (string.hashCode()) {
            case -1009088440: {
                if (!string.equals("python-types")) break;
                return "tpf";
            }
            case -1015347433: {
                if (!string.equals("python-names")) break;
                return "nmf";
            }
        }
        String string2 = value;
        return string2;
    }

    private final String formatDoubleValue(double value) {
        double proc = value * (double)100;
        String string = (proc < 5.0 ? SMALL_NUMBERS : LARGE_NUMBERS).format(proc);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(if (proc < 5.0) SMALL_N\u2026RGE_NUMBERS).format(proc)");
        return string;
    }

    static {
        Companion = new Companion(null);
        SMALL_NUMBERS = new DecimalFormat("#.#####");
        LARGE_NUMBERS = new DecimalFormat("#");
    }

    public static final /* synthetic */ String access$formatModelName(MyLookupElementCustomizer $this, String value) {
        return $this.formatModelName(value);
    }

    public static final /* synthetic */ String access$formatDoubleValue(MyLookupElementCustomizer $this, double value) {
        return $this.formatDoubleValue(value);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/recommenders/python/decorating/MyLookupElementCustomizer$Companion;", "", "()V", "LARGE_NUMBERS", "Ljava/text/DecimalFormat;", "SMALL_NUMBERS", "intellij.recommenders.python"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

