/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.CallableClsStubBuilderKt$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ConstructorClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.FunctionClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.PropertyClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.TypeAliasClsStubBuildingKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DataClassDescriptorResolver;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001aP\u0010\u000b\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r\u001a.\u0010\u000b\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"createConstructorStub", "", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "constructorProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor;", "outerContext", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderContext;", "protoContainer", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "createDeclarationsStubs", "functionProtos", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "propertyProtos", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "typeAliasesProtos", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeAlias;", "packageProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package;", "shouldSkip", "", "flags", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "kotlin.core"})
public final class CallableClsStubBuilderKt {
    public static final void createDeclarationsStubs(@NotNull StubElement<? extends PsiElement> parentStub, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer, @NotNull ProtoBuf.Package packageProto) {
        Intrinsics.checkNotNullParameter(parentStub, (String)"parentStub");
        Intrinsics.checkNotNullParameter((Object)outerContext, (String)"outerContext");
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"protoContainer");
        Intrinsics.checkNotNullParameter((Object)packageProto, (String)"packageProto");
        List list = packageProto.getFunctionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageProto.functionList");
        List list2 = packageProto.getPropertyList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"packageProto.propertyList");
        List list3 = packageProto.getTypeAliasList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"packageProto.typeAliasList");
        CallableClsStubBuilderKt.createDeclarationsStubs(parentStub, outerContext, protoContainer, list, list2, list3);
    }

    public static final void createDeclarationsStubs(@NotNull StubElement<? extends PsiElement> parentStub, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer, @NotNull List<ProtoBuf.Function> functionProtos, @NotNull List<ProtoBuf.Property> propertyProtos, @NotNull List<ProtoBuf.TypeAlias> typeAliasesProtos) {
        Intrinsics.checkNotNullParameter(parentStub, (String)"parentStub");
        Intrinsics.checkNotNullParameter((Object)outerContext, (String)"outerContext");
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"protoContainer");
        Intrinsics.checkNotNullParameter(functionProtos, (String)"functionProtos");
        Intrinsics.checkNotNullParameter(propertyProtos, (String)"propertyProtos");
        Intrinsics.checkNotNullParameter(typeAliasesProtos, (String)"typeAliasesProtos");
        for (ProtoBuf.Property propertyProto : propertyProtos) {
            if (CallableClsStubBuilderKt.shouldSkip(propertyProto.getFlags(), NameResolverUtilKt.getName((NameResolver)outerContext.getNameResolver(), (int)propertyProto.getName()))) continue;
            new PropertyClsStubBuilder(parentStub, outerContext, protoContainer, propertyProto).build();
        }
        for (ProtoBuf.Function functionProto : functionProtos) {
            if (CallableClsStubBuilderKt.shouldSkip(functionProto.getFlags(), NameResolverUtilKt.getName((NameResolver)outerContext.getNameResolver(), (int)functionProto.getName()))) continue;
            new FunctionClsStubBuilder(parentStub, outerContext, protoContainer, functionProto).build();
        }
        for (ProtoBuf.TypeAlias typeAliasProto : typeAliasesProtos) {
            TypeAliasClsStubBuildingKt.createTypeAliasStub(parentStub, typeAliasProto, protoContainer, outerContext);
        }
    }

    public static final void createConstructorStub(@NotNull StubElement<? extends PsiElement> parentStub, @NotNull ProtoBuf.Constructor constructorProto, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer) {
        Intrinsics.checkNotNullParameter(parentStub, (String)"parentStub");
        Intrinsics.checkNotNullParameter((Object)constructorProto, (String)"constructorProto");
        Intrinsics.checkNotNullParameter((Object)outerContext, (String)"outerContext");
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"protoContainer");
        new ConstructorClsStubBuilder(parentStub, outerContext, protoContainer, constructorProto).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldSkip(int flags, Name name) {
        ProtoBuf.MemberKind memberKind = (ProtoBuf.MemberKind)Flags.MEMBER_KIND.get(flags);
        if (memberKind == null) return false;
        switch (CallableClsStubBuilderKt$WhenMappings.$EnumSwitchMapping$0[memberKind.ordinal()]) {
            case 1: 
            case 2: {
                return true;
            }
            case 3: {
                if (DataClassDescriptorResolver.INSTANCE.isComponentLike(name)) return false;
                return true;
            }
            default: {
                return false;
            }
        }
    }
}

