/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.project.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.decompiler.navigation.MemberMatching;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelper$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelperKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000256B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J7\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\b\b\u0000\u0010\u0011*\u00020\t2\u0006\u0010\u0012\u001a\u0002H\u00112\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J.\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00182\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0 H\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020$J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020$2\u0006\u0010\n\u001a\u00020$J\u0016\u0010)\u001a\u00020\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\"H\u0002J\u0018\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u00100\u001a\b\u0012\u0004\u0012\u0002010\u001c2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u00102\u001a\b\u0012\u0004\u0012\u0002030\u001c*\u000203H\u0002J\u0018\u00104\u001a\b\u0012\u0004\u0012\u0002010\u001c*\b\u0012\u0004\u0012\u0002010\"H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "forceResolve", "", "convertPropertyOrFunction", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declaration", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "findClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "decompiledClassOrObject", "findFirstMatchingInIndex", "T", "entity", "index", "Lcom/intellij/psi/stubs/StringStubIndexExtension;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;Lcom/intellij/psi/stubs/StringStubIndexExtension;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "findSpecialProperty", "memberName", "Lorg/jetbrains/kotlin/name/Name;", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "getInitialMemberCandidates", "", "sourceClassOrObject", "name", "declarationClass", "Ljava/lang/Class;", "getInitialTopLevelCandidates", "", "getNavigationElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getOriginalClass", "Lcom/intellij/psi/PsiClass;", "classOrObject", "getOriginalElement", "haveRenamesInImports", "files", "Lorg/jetbrains/kotlin/psi/KtFile;", "navigateToDeclaration", "from", "setForceResolve", "", "targetScopes", "Lcom/intellij/psi/search/GlobalSearchScope;", "associatedCommonLibraries", "Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;", "union", "NavigationKind", "SourceAndDecompiledConversionVisitor", "kotlin.core"})
public final class SourceNavigationHelper {
    private static final Logger LOG;
    private static boolean forceResolve;
    public static final SourceNavigationHelper INSTANCE;

    public final void setForceResolve(boolean forceResolve) {
        SourceNavigationHelper.forceResolve = forceResolve;
    }

    /*
     * Unable to fully structure code
     */
    private final List<GlobalSearchScope> targetScopes(KtNamedDeclaration declaration, NavigationKind navigationKind) {
        v0 = declaration.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"declaration.containingKtFile");
        containingFile = v0;
        v1 = containingFile.getVirtualFile();
        if (v1 == null) {
            return CollectionsKt.emptyList();
        }
        vFile = v1;
        switch (SourceNavigationHelper$WhenMappings.$EnumSwitchMapping$0[navigationKind.ordinal()]) {
            case 1: {
                v2 = declaration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"declaration.project");
                binaryModuleInfos = GetModuleInfoKt.getBinaryLibrariesModuleInfos(v2, vFile);
                var7_7 = binaryModuleInfos;
                var26_9 = this;
                $i$f$mapNotNull = false;
                var9_14 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var14_30 = $this$forEach$iv$iv$iv.iterator();
                while (var14_30.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var14_30.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (BinaryModuleInfo)element$iv$iv;
                    $i$a$-mapNotNull-SourceNavigationHelper$targetScopes$primaryScope$1 = false;
                    v3 = it.getSourcesModuleInfo();
                    if ((v3 != null ? v3.sourceScope() : null) == null) continue;
                    var20_42 = var20_42;
                    var21_44 = false;
                    var22_46 = false;
                    it$iv$iv = var20_42;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                var27_51 = (List)destination$iv$iv;
                primaryScope = var26_9.union(var27_51);
                $i$f$mapNotNull = binaryModuleInfos;
                var26_9 = this;
                $i$f$flatMap = false;
                destination$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (BinaryModuleInfo)element$iv$iv;
                    $i$a$-flatMap-SourceNavigationHelper$targetScopes$additionalScope$1 = false;
                    list$iv$iv = SourceNavigationHelper.INSTANCE.associatedCommonLibraries(it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                var27_51 = (List)destination$iv$iv;
                $this$flatMap$iv = var27_51;
                $i$f$mapNotNull = false;
                $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                var15_32 = $this$forEach$iv$iv$iv.iterator();
                while (var15_32.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var15_32.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (BinaryModuleInfo)element$iv$iv;
                    $i$a$-mapNotNull-SourceNavigationHelper$targetScopes$additionalScope$2 = false;
                    v4 = it.getSourcesModuleInfo();
                    if ((v4 != null ? v4.sourceScope() : null) == null) continue;
                    var21_45 = var21_45;
                    var22_46 = false;
                    var23_48 = false;
                    it$iv$iv = var21_45;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                var27_51 = (List)destination$iv$iv;
                additionalScope = var26_9.union(var27_51);
                $this$any$iv = binaryModuleInfos;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl83
                v5 = false;
                ** GOTO lbl90
lbl83:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (BinaryModuleInfo)element$iv;
                    $i$a$-any-SourceNavigationHelper$targetScopes$1 = false;
                    if (!(it instanceof ScriptDependenciesInfo)) continue;
                    v5 = true;
                    ** GOTO lbl90
                }
                v5 = false;
lbl90:
                // 3 sources

                if (v5) {
                    v6 = CollectionsKt.plus((Collection)primaryScope, (Iterable)additionalScope);
                    v7 = ProjectScope.getContentScope((Project)containingFile.getProject());
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"ProjectScope.getContentS\u2026e(containingFile.project)");
                    v8 = CollectionsKt.plus((Collection)v6, (Object)v7);
                    break;
                }
                v8 = CollectionsKt.plus((Collection)primaryScope, (Iterable)additionalScope);
                break;
            }
            case 2: {
                v9 = declaration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"declaration.project");
                binaryModuleInfos = GetModuleInfoKt.getLibrarySourcesModuleInfos(v9, vFile);
                var26_10 = this;
                $i$f$map = false;
                additionalScope = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (LibrarySourceInfo)item$iv$iv;
                    var27_52 = destination$iv$iv;
                    $i$a$-map-SourceNavigationHelper$targetScopes$2 = false;
                    var28_56 = it.getBinariesModuleInfo().binariesScope();
                    var27_52.add(var28_56);
                }
                var27_52 = (List)destination$iv$iv;
                v8 = var26_10.union((Collection<? extends GlobalSearchScope>)var27_52);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v8;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BinaryModuleInfo> associatedCommonLibraries(BinaryModuleInfo $this$associatedCommonLibraries) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        TargetPlatform platform = $this$associatedCommonLibraries.getPlatform();
        if (platform == null || TargetPlatformKt.isCommon((TargetPlatform)platform)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filterIsInstance$iv = $this$associatedCommonLibraries.dependencies();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BinaryModuleInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv;
            boolean bl = false;
            if (!TargetPlatformKt.isCommon((TargetPlatform)it.getPlatform())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<GlobalSearchScope> union(Collection<? extends GlobalSearchScope> $this$union) {
        List list;
        Collection<? extends GlobalSearchScope> collection = $this$union;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Collection<? extends GlobalSearchScope> $this$toTypedArray$iv = $this$union;
            boolean $i$f$toTypedArray = false;
            Collection<? extends GlobalSearchScope> thisCollection$iv = $this$toTypedArray$iv;
            GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[0]);
            if (globalSearchScopeArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            list = CollectionsKt.listOf((Object)GlobalSearchScope.union((GlobalSearchScope[])globalSearchScopeArray));
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final boolean haveRenamesInImports(Collection<? extends KtFile> files) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = files;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        KtFile file = (KtFile)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = file.getImportDirectives();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                KtImportDirective it = (KtImportDirective)element$iv2;
                                boolean bl4 = false;
                                if (!(it.getAliasName() != null)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final KtNamedDeclaration findSpecialProperty(Name memberName, KtClass containingClass) {
        List constructorParameters = containingClass.getPrimaryConstructorParameters();
        for (KtParameter constructorParameter : constructorParameters) {
            if (!Intrinsics.areEqual((Object)memberName, (Object)constructorParameter.getNameAsName()) || !constructorParameter.hasValOrVar()) continue;
            return (KtNamedDeclaration)constructorParameter;
        }
        if (containingClass.hasModifier(KtTokens.ENUM_KEYWORD)) {
            Iterator iterator = ContainerUtil.findAll((Collection)containingClass.getDeclarations(), KtEnumEntry.class).iterator();
            while (iterator.hasNext()) {
                KtEnumEntry enumEntry;
                KtEnumEntry ktEnumEntry = enumEntry = (KtEnumEntry)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)ktEnumEntry, (String)"enumEntry");
                if (!Intrinsics.areEqual((Object)memberName, (Object)ktEnumEntry.getNameAsName())) continue;
                return (KtNamedDeclaration)enumEntry;
            }
        }
        return null;
    }

    private final KtNamedDeclaration convertPropertyOrFunction(KtNamedDeclaration declaration, NavigationKind navigationKind) {
        Object sourceClassOrObject;
        if (declaration instanceof KtPrimaryConstructor) {
            KtClassOrObject sourceClassOrObject2 = this.findClassOrObject(((KtPrimaryConstructor)declaration).getContainingClassOrObject(), navigationKind);
            KtClassOrObject ktClassOrObject = sourceClassOrObject2;
            return ktClassOrObject != null && (ktClassOrObject = ktClassOrObject.getPrimaryConstructor()) != null ? (KtNamedDeclaration)ktClassOrObject : (KtNamedDeclaration)sourceClassOrObject2;
        }
        String memberNameAsString = declaration.getName();
        if (memberNameAsString == null) {
            LOG.debug("Declaration with null name:" + DebugTextUtilKt.getDebugText((KtElement)((KtElement)declaration)));
            return null;
        }
        Name name = Name.identifier((String)memberNameAsString);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(memberNameAsString)");
        Name memberName = name;
        PsiElement decompiledContainer = declaration.getParent();
        Collection candidates = null;
        PsiElement psiElement = decompiledContainer;
        if (psiElement instanceof KtFile) {
            candidates = this.getInitialTopLevelCandidates(declaration, navigationKind);
        } else if (psiElement instanceof KtClassBody) {
            List<KtNamedDeclaration> list;
            boolean bl;
            KtClassOrObject ktClassOrObject;
            PsiElement psiElement2 = decompiledContainer.getParent();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            KtClassOrObject decompiledClassOrObject = (KtClassOrObject)psiElement2;
            KtClassOrObject ktClassOrObject2 = sourceClassOrObject = this.findClassOrObject(decompiledClassOrObject, navigationKind);
            if (ktClassOrObject2 != null) {
                ktClassOrObject = ktClassOrObject2;
                bl = false;
                boolean bl2 = false;
                KtClassOrObject it = ktClassOrObject;
                boolean bl3 = false;
                list = INSTANCE.getInitialMemberCandidates((KtClassOrObject)sourceClassOrObject, memberName, (Class<? extends KtNamedDeclaration>)declaration.getClass());
            } else {
                list = null;
            }
            ktClassOrObject = list;
            bl = false;
            Object object = ktClassOrObject;
            if (object == null) {
                object = CollectionsKt.emptyList();
            }
            candidates = (Collection)object;
            if (candidates.isEmpty() && declaration instanceof KtProperty && sourceClassOrObject instanceof KtClass) {
                return this.findSpecialProperty(memberName, (KtClass)sourceClassOrObject);
            }
        } else {
            throw (Throwable)new IllegalStateException("Unexpected container of " + (navigationKind == NavigationKind.CLASS_FILES_TO_SOURCES ? "decompiled" : "source") + " declaration: " + decompiledContainer.getClass().getSimpleName());
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (!forceResolve) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = candidates;
            boolean $i$f$filter = false;
            sourceClassOrObject = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
                boolean bl = false;
                if (!MemberMatching.sameReceiverPresenceAndParametersCount(it, declaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidates = (List)destination$iv$iv;
            if (candidates.size() <= 1) {
                return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates));
            }
            if (!this.haveRenamesInImports(SourceNavigationHelperKt.access$getContainingFiles(candidates))) {
                $this$filter$iv = candidates;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
                    boolean bl = false;
                    if (!MemberMatching.receiverAndParametersShortTypesMatch(it, declaration)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                candidates = (List)destination$iv$iv;
                if (candidates.size() <= 1) {
                    return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates));
                }
            }
        }
        for (KtNamedDeclaration candidate : candidates) {
            CallableDescriptor candidateDescriptor;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)((KtDeclaration)candidate), null, (int)1, null);
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            if ((CallableDescriptor)declarationDescriptor == null) {
                continue;
            }
            if (!MemberMatching.receiversMatch(declaration, candidateDescriptor) || !MemberMatching.valueParametersTypesMatch(declaration, candidateDescriptor)) continue;
            KtNamedDeclaration ktNamedDeclaration = declaration;
            if (ktNamedDeclaration == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeParameterListOwner");
            }
            if (!MemberMatching.typeParametersMatch((KtTypeParameterListOwner)ktNamedDeclaration, candidateDescriptor.getTypeParameters())) continue;
            return candidate;
        }
        return null;
    }

    private final <T extends KtNamedDeclaration> T findFirstMatchingInIndex(T entity, NavigationKind navigationKind, StringStubIndexExtension<T> index2) {
        KtNamedDeclaration ktNamedDeclaration;
        block7: {
            FqName fqName = entity.getFqName();
            if (fqName == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"entity.fqName ?: return null");
            FqName classFqName = fqName;
            Iterable $this$firstNotNullResult$iv = this.targetScopes(entity, navigationKind);
            boolean $i$f$firstNotNullResult = false;
            for (Object element$iv : $this$firstNotNullResult$iv) {
                KtNamedDeclaration result$iv;
                Object v2;
                GlobalSearchScope scope2 = (GlobalSearchScope)element$iv;
                boolean bl = false;
                Collection collection = index2.get((Object)classFqName.asString(), entity.getProject(), scope2);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"index.get(classFqName.as\u2026), entity.project, scope)");
                Iterable $this$minByOrNull$iv = collection;
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v2 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v2 = minElem$iv;
                    } else {
                        KtNamedDeclaration it = (KtNamedDeclaration)minElem$iv;
                        boolean bl2 = false;
                        KtNamedDeclaration ktNamedDeclaration2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)ktNamedDeclaration2, (String)"it");
                        boolean minValue$iv = ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)ktNamedDeclaration2);
                        do {
                            Object e$iv = iterator$iv.next();
                            KtNamedDeclaration it2 = (KtNamedDeclaration)e$iv;
                            $i$a$-minByOrNull-SourceNavigationHelper$findFirstMatchingInIndex$1$1 = false;
                            KtNamedDeclaration ktNamedDeclaration3 = it2;
                            Intrinsics.checkNotNullExpressionValue((Object)ktNamedDeclaration3, (String)"it");
                            boolean v$iv = ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)ktNamedDeclaration3);
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v2 = minElem$iv;
                    }
                }
                if ((result$iv = (KtNamedDeclaration)v2) == null) continue;
                ktNamedDeclaration = result$iv;
                break block7;
            }
            ktNamedDeclaration = null;
        }
        return (T)ktNamedDeclaration;
    }

    private final KtClassOrObject findClassOrObject(KtClassOrObject decompiledClassOrObject, NavigationKind navigationKind) {
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)decompiledClassOrObject;
        KotlinFullClassNameIndex kotlinFullClassNameIndex = KotlinFullClassNameIndex.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)kotlinFullClassNameIndex), (String)"KotlinFullClassNameIndex.getInstance()");
        return (KtClassOrObject)this.findFirstMatchingInIndex(ktNamedDeclaration, navigationKind, kotlinFullClassNameIndex);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtNamedDeclaration> getInitialTopLevelCandidates(KtNamedDeclaration declaration, NavigationKind navigationKind) {
        void $this$flatMapTo$iv$iv;
        StringStubIndexExtension stringStubIndexExtension;
        List<GlobalSearchScope> scopes = this.targetScopes(declaration, navigationKind);
        KtNamedDeclaration ktNamedDeclaration = declaration;
        if (ktNamedDeclaration instanceof KtNamedFunction) {
            KotlinTopLevelFunctionFqnNameIndex kotlinTopLevelFunctionFqnNameIndex = KotlinTopLevelFunctionFqnNameIndex.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)kotlinTopLevelFunctionFqnNameIndex), (String)"KotlinTopLevelFunctionFqnNameIndex.getInstance()");
            stringStubIndexExtension = kotlinTopLevelFunctionFqnNameIndex;
        } else if (ktNamedDeclaration instanceof KtProperty) {
            KotlinTopLevelPropertyFqnNameIndex kotlinTopLevelPropertyFqnNameIndex = KotlinTopLevelPropertyFqnNameIndex.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)kotlinTopLevelPropertyFqnNameIndex), (String)"KotlinTopLevelPropertyFqnNameIndex.getInstance()");
            stringStubIndexExtension = kotlinTopLevelPropertyFqnNameIndex;
        } else {
            throw (Throwable)new IllegalArgumentException("Neither function nor declaration: " + declaration.getClass().getName());
        }
        StringStubIndexExtension index2 = stringStubIndexExtension;
        Iterable $this$flatMap$iv = scopes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GlobalSearchScope scope2 = (GlobalSearchScope)element$iv$iv;
            boolean bl = false;
            FqName fqName = declaration.getFqName();
            Intrinsics.checkNotNull((Object)fqName);
            Collection collection = index2.get((Object)fqName.asString(), declaration.getProject(), scope2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"index.get(declaration.fq\u2026claration.project, scope)");
            Iterable $this$sortedBy$iv = collection;
            boolean $i$f$sortedBy = false;
            boolean bl2 = false;
            Iterable list$iv$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    KtNamedDeclaration it = (KtNamedDeclaration)a;
                    boolean bl2 = false;
                    KtNamedDeclaration ktNamedDeclaration = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktNamedDeclaration, (String)"it");
                    it = (KtNamedDeclaration)b;
                    Comparable comparable = Boolean.valueOf(ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)ktNamedDeclaration));
                    bl2 = false;
                    KtNamedDeclaration ktNamedDeclaration2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ktNamedDeclaration2, (String)"it");
                    Boolean bl3 = ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)ktNamedDeclaration2);
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)bl3);
                }
            });
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtNamedDeclaration> getInitialMemberCandidates(KtClassOrObject sourceClassOrObject, Name name, Class<? extends KtNamedDeclaration> declarationClass) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.filterIsInstance((Iterable)sourceClassOrObject.getDeclarations(), declarationClass);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtNamedDeclaration declaration = (KtNamedDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)name, (Object)declaration.getNameAsSafeName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final PsiClass getOriginalClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        FqName fqName = classOrObject.getFqName();
        if (fqName == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"classOrObject.fqName ?: return null");
        FqName fqName2 = fqName;
        KtFile ktFile = classOrObject.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"classOrObject.containingKtFile");
        KtFile file = ktFile;
        VirtualFile vFile = file.getVirtualFile();
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        Project project2 = project;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
        ProjectFileIndex idx = projectFileIndex;
        if (vFile == null || !idx.isInLibrarySource(vFile)) {
            return null;
        }
        THashSet orderEntries = new THashSet((Collection)idx.getOrderEntriesForFile(vFile));
        return JavaPsiFacade.getInstance((Project)project2).findClass(fqName2.asString(), new GlobalSearchScope(vFile, idx, orderEntries, project2, project2){
            final /* synthetic */ VirtualFile $vFile;
            final /* synthetic */ ProjectFileIndex $idx;
            final /* synthetic */ THashSet $orderEntries;
            final /* synthetic */ Project $project;

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file1, (String)"file1");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file2");
                return 0;
            }

            public boolean contains(@NotNull VirtualFile file) {
                boolean bl;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (Intrinsics.areEqual((Object)file, (Object)this.$vFile)) {
                        return false;
                    }
                    List list = this.$idx.getOrderEntriesForFile(file);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"idx.getOrderEntriesForFile(file)");
                    List entries = list;
                    Iterable $this$any$iv = entries;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            OrderEntry it = (OrderEntry)element$iv;
                            boolean bl2 = false;
                            if (!this.$orderEntries.contains((Object)it)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                Intrinsics.checkNotNullParameter((Object)aModule, (String)"aModule");
                return false;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
            {
                this.$vFile = $captured_local_variable$0;
                this.$idx = $captured_local_variable$1;
                this.$orderEntries = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                super($super_call_param$4);
            }
        });
    }

    @NotNull
    public final KtDeclaration getNavigationElement(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.navigateToDeclaration(declaration, NavigationKind.CLASS_FILES_TO_SOURCES);
    }

    @NotNull
    public final KtDeclaration getOriginalElement(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.navigateToDeclaration(declaration, NavigationKind.SOURCES_TO_CLASS_FILES);
    }

    private final KtDeclaration navigateToDeclaration(KtDeclaration from, NavigationKind navigationKind) {
        KtDeclaration ktDeclaration;
        if (DumbService.isDumb((Project)from.getProject())) {
            return from;
        }
        switch (SourceNavigationHelper$WhenMappings.$EnumSwitchMapping$1[navigationKind.ordinal()]) {
            case 1: {
                if (from.getContainingKtFile().isCompiled()) break;
                return from;
            }
            case 2: {
                PsiFile file = from.getContainingFile();
                if (file instanceof KtFile && ((KtFile)file).isCompiled()) {
                    return from;
                }
                if (!ProjectRootsUtil.isInContent((PsiElement)from, false, true, false, true, false)) {
                    return from;
                }
                if (!KtPsiUtil.isLocal((KtDeclaration)from)) break;
                return from;
            }
        }
        if ((ktDeclaration = (KtDeclaration)from.accept((KtVisitor)new SourceAndDecompiledConversionVisitor(navigationKind), (Object)Unit.INSTANCE)) == null) {
            ktDeclaration = from;
        }
        return ktDeclaration;
    }

    private SourceNavigationHelper() {
    }

    static {
        SourceNavigationHelper sourceNavigationHelper;
        INSTANCE = sourceNavigationHelper = new SourceNavigationHelper();
        Logger logger = Logger.getInstance(SourceNavigationHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Sourc\u2026gationHelper::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "", "(Ljava/lang/String;I)V", "CLASS_FILES_TO_SOURCES", "SOURCES_TO_CLASS_FILES", "kotlin.core"})
    public static final class NavigationKind
    extends Enum<NavigationKind> {
        public static final /* enum */ NavigationKind CLASS_FILES_TO_SOURCES;
        public static final /* enum */ NavigationKind SOURCES_TO_CLASS_FILES;
        private static final /* synthetic */ NavigationKind[] $VALUES;

        static {
            NavigationKind[] navigationKindArray = new NavigationKind[2];
            NavigationKind[] navigationKindArray2 = navigationKindArray;
            navigationKindArray[0] = CLASS_FILES_TO_SOURCES = new NavigationKind();
            navigationKindArray[1] = SOURCES_TO_CLASS_FILES = new NavigationKind();
            $VALUES = navigationKindArray;
        }

        public static NavigationKind[] values() {
            return (NavigationKind[])$VALUES.clone();
        }

        public static NavigationKind valueOf(String string) {
            return Enum.valueOf(NavigationKind.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010$J\u001f\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "(Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;)V", "visitClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "data", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitTypeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAlias", "(Lorg/jetbrains/kotlin/psi/KtTypeAlias;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "kotlin.core"})
    private static final class SourceAndDecompiledConversionVisitor
    extends KtVisitor<KtDeclaration, Unit> {
        private final NavigationKind navigationKind;

        @Nullable
        public KtNamedDeclaration visitNamedFunction(@NotNull KtNamedFunction function, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)function, this.navigationKind);
        }

        @Nullable
        public KtNamedDeclaration visitProperty(@NotNull KtProperty property, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)property, this.navigationKind);
        }

        @Nullable
        public KtClassOrObject visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.findClassOrObject((KtClassOrObject)declaration, this.navigationKind);
        }

        @Nullable
        public KtClassOrObject visitClass(@NotNull KtClass klass, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.findClassOrObject((KtClassOrObject)klass, this.navigationKind);
        }

        @Nullable
        public KtTypeAlias visitTypeAlias(@NotNull KtTypeAlias typeAlias, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return (KtTypeAlias)INSTANCE.findFirstMatchingInIndex((KtNamedDeclaration)typeAlias, this.navigationKind, KotlinTopLevelTypeAliasFqNameIndex.Companion.getInstance());
        }

        @Nullable
        public KtDeclaration visitParameter(@NotNull KtParameter parameter, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            PsiElement psiElement = parameter.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameter.parent");
            PsiElement psiElement2 = psiElement.getParent();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
            }
            KtCallableDeclaration callableDeclaration = (KtCallableDeclaration)psiElement2;
            List list = callableDeclaration.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"callableDeclaration.valueParameters");
            List parameters = list;
            int index2 = parameters.indexOf(parameter);
            Object object = callableDeclaration.accept((KtVisitor)this, (Object)Unit.INSTANCE);
            if (!(object instanceof KtCallableDeclaration)) {
                object = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)object;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration sourceCallable = ktCallableDeclaration;
            List list2 = sourceCallable.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"sourceCallable.valueParameters");
            List sourceParameters = list2;
            if (sourceParameters.size() != parameters.size()) {
                return null;
            }
            return (KtDeclaration)sourceParameters.get(index2);
        }

        @Nullable
        public KtNamedDeclaration visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)constructor, this.navigationKind);
        }

        @Nullable
        public KtNamedDeclaration visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)constructor, this.navigationKind);
        }

        public SourceAndDecompiledConversionVisitor(@NotNull NavigationKind navigationKind) {
            Intrinsics.checkNotNullParameter((Object)((Object)navigationKind), (String)"navigationKind");
            this.navigationKind = navigationKind;
        }
    }
}

