/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.core.TypesWithOperatorDetector;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.idea.util.FuzzyTypeUtils;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/core/TypesWithSetValueDetector;", "Lorg/jetbrains/kotlin/idea/core/TypesWithOperatorDetector;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "indicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "propertyOwnerType", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;Lorg/jetbrains/kotlin/idea/util/FuzzyType;)V", "checkIsSuitableByType", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "operator", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "freeTypeParams", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.core"})
public final class TypesWithSetValueDetector
extends TypesWithOperatorDetector {
    private final FuzzyType propertyOwnerType;

    @Override
    @Nullable
    protected TypeSubstitutor checkIsSuitableByType(@NotNull FunctionDescriptor operator, @NotNull Collection<? extends TypeParameterDescriptor> freeTypeParams) {
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter(freeTypeParams, (String)"freeTypeParams");
        List list = operator.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"operator.valueParameters");
        Object object = CollectionsKt.first((List)list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"operator.valueParameters.first()");
        KotlinType kotlinType = ((ValueParameterDescriptor)object).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"operator.valueParameters.first().type");
        FuzzyType paramType = FuzzyTypeUtils.toFuzzyType((KotlinType)kotlinType, freeTypeParams);
        return paramType.checkIsSuperTypeOf(this.propertyOwnerType);
    }

    public TypesWithSetValueDetector(@NotNull LexicalScope scope2, @Nullable KotlinIndicesHelper indicesHelper, @NotNull FuzzyType propertyOwnerType) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)propertyOwnerType, (String)"propertyOwnerType");
        super(OperatorNameConventions.SET_VALUE, scope2, indicesHelper);
        this.propertyOwnerType = propertyOwnerType;
    }
}

