/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.compiler;

import com.google.common.io.CharStreams;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.coffeescript.CsBundle;
import org.coffeescript.lang.psi.CoffeeScriptFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class CoffeeScriptCompiler {
    private static final Logger LOG = Logger.getInstance((String)CoffeeScriptCompiler.class.getName());

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String readFileFromJar(@NotNull String resourceName) {
        if (resourceName == null) {
            CoffeeScriptCompiler.$$$reportNull$$$0(0);
        }
        ClassLoader classLoader = CoffeeScriptCompiler.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(resourceName);){
            String string;
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                string = CharStreams.toString((Readable)reader);
            }
            return string;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compile(@NotNull String textToCompile) {
        if (textToCompile == null) {
            CoffeeScriptCompiler.$$$reportNull$$$0(1);
        }
        String coffeeScriptJS = CoffeeScriptCompiler.readFileFromJar("coffee-script.js");
        Context context = Context.enter();
        try {
            context.setOptimizationLevel(-1);
            ScriptableObject scope = context.initStandardObjects();
            context.evaluateString((Scriptable)scope, coffeeScriptJS, "original CoffeeScript compiler", 0, null);
            scope.put("coffeeScriptSource", (Scriptable)scope, (Object)textToCompile);
            String string = (String)context.evaluateString((Scriptable)scope, "CoffeeScript.compile(coffeeScriptSource);", "CoffeeScript compiler for JetBrains", 0, null);
            return string;
        }
        catch (JavaScriptException ex) {
            ScriptableObject nativeError;
            Object locationObject;
            Object exceptionLocation = "";
            Object value = ex.getValue();
            if (value instanceof ScriptableObject && (locationObject = (nativeError = (ScriptableObject)value).get((Object)"location")) instanceof ScriptableObject) {
                Object first_column;
                ScriptableObject location = (ScriptableObject)locationObject;
                Object first_line = location.get((Object)"first_line");
                if (first_line instanceof Number) {
                    exceptionLocation = (String)exceptionLocation + "\nLine: " + (((Number)first_line).intValue() + 1);
                }
                if ((first_column = location.get((Object)"first_column")) instanceof Number) {
                    exceptionLocation = (String)exceptionLocation + "\nColumn: " + (((Number)first_column).intValue() + 1);
                }
            }
            String string = "Exception raised during CoffeeScript compilation:\n" + ex.details() + (String)exceptionLocation;
            return string;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sourceMap(@NotNull PsiFile file) {
        if (file == null) {
            CoffeeScriptCompiler.$$$reportNull$$$0(2);
        }
        PsiDirectory parentDirectory = file.getParent();
        assert (parentDirectory != null);
        String coffeeScriptReduxJS = CoffeeScriptCompiler.readFileFromJar("coffee-script-redux.js");
        Context context = Context.enter();
        String sourceMap = null;
        try {
            context.setOptimizationLevel(-1);
            ScriptableObject scope = context.initStandardObjects();
            context.evaluateString((Scriptable)scope, "var root = new Object();", "root", 0, null);
            context.evaluateString((Scriptable)scope, coffeeScriptReduxJS, "coffee-script-redux.js", 0, null);
            scope.put("coffeeScriptSource", (Scriptable)scope, (Object)file.getText());
            sourceMap = (String)context.evaluateString((Scriptable)scope, "root.CoffeeScript.sourceMap(root.CoffeeScript.compile(root.CoffeeScript.parse.apply(root, [coffeeScriptSource])))", "test", 0, null);
        }
        catch (JavaScriptException jse) {
            LOG.info(String.format("Can't generate source maps for: %s", file.getName()));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            Context.exit();
        }
        if (sourceMap != null) {
            String suffixToReplace = file.getName().endsWith(".js.coffee") ? ".js.coffee" : (file.getName().endsWith(".coffee") ? ".coffee" : "");
            String sourceMapFileName = file.getName().substring(0, file.getName().length() - suffixToReplace.length()) + ".js.map";
            String finalSourceMap = sourceMap.replaceAll("unknown", file.getName());
            ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                OutputStreamWriter fw = null;
                try {
                    fw = new FileWriter(parentDirectory.getVirtualFile().getPath() + "/" + sourceMapFileName);
                    fw.write(finalSourceMap);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    if (fw != null) {
                        try {
                            fw.flush();
                            fw.close();
                        }
                        catch (IOException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }));
        }
    }

    public static void compileDirectory(@NotNull PsiDirectory directory, @Nullable ProgressIndicator indicator) {
        if (directory == null) {
            CoffeeScriptCompiler.$$$reportNull$$$0(3);
        }
        Ref filesRef = new Ref();
        ApplicationManager.getApplication().runReadAction(() -> filesRef.set((Object)directory.getFiles()));
        for (PsiFile file : (PsiFile[])filesRef.get()) {
            if (indicator != null && indicator.isCanceled()) break;
            if (file instanceof PsiDirectory) {
                CoffeeScriptCompiler.compileDirectory((PsiDirectory)file, indicator);
                continue;
            }
            if (!(file instanceof CoffeeScriptFile)) continue;
            if (indicator != null) {
                indicator.setText(CsBundle.message("progress.indicator.text.source.maps.for.0", file.getName()));
            }
            CoffeeScriptCompiler.sourceMap(file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToCompile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        objectArray2[1] = "org/coffeescript/compiler/CoffeeScriptCompiler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readFileFromJar";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sourceMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compileDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

