/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.highlighting.IntentionAndInspectionFilter;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Pattern;
import org.coffeescript.CoffeeScriptLanguage;
import org.coffeescript.CoffeeScriptLiterateLanguage;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.parser.CoffeeScriptElementTypes;
import org.coffeescript.lang.psi.impl.CoffeeScriptPropertyImpl;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptUtil {
    @NonNls
    public static final Pattern SUPPRESS_IN_LINE_COMMENT_PATTERN = Pattern.compile("#\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");

    private static boolean isSuppressedByComment(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            CoffeeScriptUtil.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            CoffeeScriptUtil.$$$reportNull$$$0(1);
        }
        return ReadAction.compute(() -> SuppressionUtil.getStatementToolSuppressedIn((PsiElement)element, (String)toolId, JSSuppressionHolder.class, (Pattern)SUPPRESS_IN_LINE_COMMENT_PATTERN)) != null;
    }

    public static boolean isInspectionSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            CoffeeScriptUtil.$$$reportNull$$$0(2);
        }
        if (toolId == null) {
            CoffeeScriptUtil.$$$reportNull$$$0(3);
        }
        boolean isSuppressed = false;
        PsiElement container = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiFile.class, JSEmbeddedContent.class});
        if (container == null || container.getLanguage() != CoffeeScriptLanguage.INSTANCE) {
            isSuppressed = true;
        }
        if (!isSuppressed) {
            boolean bl = isSuppressed = !IntentionAndInspectionFilter.isInspectionSupportedForElement((String)toolId, (PsiElement)element);
        }
        if (!isSuppressed) {
            isSuppressed = CoffeeScriptUtil.isSuppressedByComment(element, toolId);
        }
        return isSuppressed;
    }

    @Nullable
    public static PsiElement getContainer(@Nullable PsiElement element) {
        if (element != null) {
            return PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiFile.class, JSEmbeddedContent.class});
        }
        return null;
    }

    public static boolean isCoffeeScriptContent(@NotNull PsiElement element) {
        Language language;
        if (element == null) {
            CoffeeScriptUtil.$$$reportNull$$$0(4);
        }
        return (language = JSInheritedLanguagesHelper.getLanguage((PsiElement)element)) == CoffeeScriptLanguage.INSTANCE || language == CoffeeScriptLiterateLanguage.INSTANCE;
    }

    public static boolean isShortThisProperty(@NotNull PsiElement element) {
        if (element == null) {
            CoffeeScriptUtil.$$$reportNull$$$0(5);
        }
        if (CoffeeScriptUtil.isCoffeeScriptContent(element) && element.getParent() instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)element.getParent()).getQualifier();
            return qualifier != null && qualifier.getText().equals("@");
        }
        return false;
    }

    public static PsiElement getHeredoc(@NotNull PsiElement element) {
        if (element == null) {
            CoffeeScriptUtil.$$$reportNull$$$0(6);
        }
        if (CoffeeScriptUtil.isCoffeeScriptContent(element)) {
            if (element.getNode().getElementType() == CoffeeScriptTokenTypes.HEREDOC) {
                return element.getParent();
            }
            if (element instanceof JSLiteralExpression) {
                return element.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{CoffeeScriptTokenTypes.HEREDOC})).length > 0 ? element : null;
            }
        }
        return null;
    }

    public static boolean isObjectWithBrace(@NotNull ASTNode node) {
        ASTNode firstChild;
        if (node == null) {
            CoffeeScriptUtil.$$$reportNull$$$0(7);
        }
        return node.getElementType() == CoffeeScriptElementTypes.OBJECT && (firstChild = node.getFirstChildNode()) != null && firstChild.getElementType() == CoffeeScriptTokenTypes.BRACE_START;
    }

    public static boolean canHoldImplicitProperties(@NotNull JSFunction function) {
        if (function == null) {
            CoffeeScriptUtil.$$$reportNull$$$0(8);
        }
        return function.getParent() instanceof CoffeeScriptPropertyImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        objectArray2[1] = "org/coffeescript/CoffeeScriptUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuppressedByComment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInspectionSuppressedFor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isCoffeeScriptContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isShortThisProperty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getHeredoc";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isObjectWithBrace";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "canHoldImplicitProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

