/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.AdapterUtils;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalGradleScript;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalGradleTask;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.InternalProjectIdentifier;
import org.jetbrains.plugins.gradle.tooling.util.GradleContainerUtil;

public final class InternalGradleProject
implements GradleProject {
    private final InternalGradleScript buildScript = new InternalGradleScript();
    private File buildDirectory;
    private File projectDirectory;
    private Set<InternalGradleTask> tasks = GradleContainerUtil.emptyDomainObjectSet();
    private String name;
    private String description;
    private InternalProjectIdentifier projectIdentifier;
    private InternalGradleProject parent;
    private Set<InternalGradleProject> children = GradleContainerUtil.emptyDomainObjectSet();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InternalGradleProject getParent() {
        return this.parent;
    }

    public void setParent(InternalGradleProject parent) {
        this.parent = parent;
    }

    public ImmutableDomainObjectSet<InternalGradleProject> getChildren() {
        return AdapterUtils.wrap(this.children);
    }

    public void setChildren(List<InternalGradleProject> children) {
        this.children = ImmutableDomainObjectSet.of(children);
    }

    public String getPath() {
        return this.projectIdentifier == null ? null : this.projectIdentifier.getProjectPath();
    }

    public InternalProjectIdentifier getProjectIdentifier() {
        return this.projectIdentifier;
    }

    public String getProjectPath() {
        return this.projectIdentifier == null ? null : this.projectIdentifier.getProjectPath();
    }

    public File getRootDir() {
        return this.projectIdentifier == null ? null : this.projectIdentifier.getBuildIdentifier().getRootDir();
    }

    public void setProjectIdentifier(InternalProjectIdentifier projectIdentifier) {
        this.projectIdentifier = projectIdentifier;
    }

    public InternalGradleProject findByPath(String path) {
        if (path.equals(this.getPath())) {
            return this;
        }
        Iterator<InternalGradleProject> iterator = this.children.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        InternalGradleProject child = iterator.next();
        InternalGradleProject found = child.findByPath(path);
        while (found == null) {
            if (!iterator.hasNext()) {
                return null;
            }
            child = iterator.next();
            found = child.findByPath(path);
        }
        return found;
    }

    public String toString() {
        return "GradleProject{path='" + this.getPath() + '\'' + '}';
    }

    public ImmutableDomainObjectSet<? extends InternalGradleTask> getTasks() {
        return AdapterUtils.wrap(this.tasks);
    }

    public void setTasks(List<InternalGradleTask> tasks) {
        this.tasks = ImmutableDomainObjectSet.of(tasks);
    }

    public File getBuildDirectory() {
        return this.buildDirectory;
    }

    public void setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public void setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public InternalGradleScript getBuildScript() {
        return this.buildScript;
    }
}

