/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.web.optionsDownloader;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.WebStarterProjectDownloader;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public abstract class WebStarterOptionsLoaderIteration<T extends WebStarterOptions> {
    public void doIteration(final T options, String serviceUrl, final Consumer<WebStarterOptionsLoaderIteration<T>> addIterationToProcess) throws IOException {
        RequestBuilder requestBuilder = this.getPreparedRequestBuilder(serviceUrl);
        requestBuilder.userAgent(WebStarterProjectDownloader.userAgent()).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Void>(){

            public Void process(@NotNull HttpRequests.Request request) throws IOException {
                BufferedReader reader;
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    reader = request.getReader();
                }
                catch (IOException e) {
                    Logger.getInstance(WebStarterOptionsLoader.class).info("IOException loading JSON response from " + request.getURL(), (Throwable)e);
                    throw new IOException(HttpRequests.createErrorMessage((IOException)e, (HttpRequests.Request)request, (boolean)false), e);
                }
                try {
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(true);
                    JsonElement jsonRootElement = JsonParser.parseReader((JsonReader)jsonReader);
                    WebStarterOptionsLoaderIteration.this.parseJsonResponse(jsonRootElement, options);
                    WebStarterOptionsLoaderIteration.this.addMoreIterationsToQueue(options, addIterationToProcess);
                }
                catch (Throwable e) {
                    Logger.getInstance(WebStarterOptionsLoader.class).info("Error processing JSON response from " + request.getURL(), e);
                    throw new IOException("Error parsing JSON response", e);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/frameworks/starters/web/optionsDownloader/WebStarterOptionsLoaderIteration$1", "process"));
            }
        });
    }

    protected abstract RequestBuilder getPreparedRequestBuilder(String var1);

    public abstract void parseJsonResponse(JsonElement var1, @NotNull T var2);

    public void addMoreIterationsToQueue(T options, Consumer<WebStarterOptionsLoaderIteration<T>> addIterationToProcess) {
    }
}

