/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.web.optionsDownloader;

import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoaderIteration;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebStarterOptionsLoader<T extends WebStarterOptions> {
    private final Deque<WebStarterOptionsLoaderIteration<T>> myIterationQueue = new ArrayDeque<WebStarterOptionsLoaderIteration<T>>(1);

    @Nullable
    public T loadOptions(String serviceUrl) throws IOException {
        Consumer addIterationToProcess = iteration -> this.myIterationQueue.addLast((WebStarterOptionsLoaderIteration<T>)iteration);
        T options = this.createEmptyOptionsContainer();
        this.myIterationQueue.addLast(this.getFirstIteration());
        while (!this.myIterationQueue.isEmpty()) {
            this.myIterationQueue.removeFirst().doIteration(options, serviceUrl, addIterationToProcess);
        }
        this.doAfterAllIterations(options);
        return options;
    }

    protected abstract T createEmptyOptionsContainer();

    @NotNull
    protected abstract WebStarterOptionsLoaderIteration<T> getFirstIteration();

    protected void doAfterAllIterations(T options) {
    }
}

