/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.web.dependencies;

import com.intellij.frameworks.starters.FrameworksStartersBundle;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.utils.DependencyAvailabilityVerificationResult;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class WebStarterSelectedDependenciesPanel
extends JPanel {
    private final WebStarterModuleBuilder<?> myBuilder;
    private final List<? extends WebStarterOptions.MultiSelectGroup> myDependencies;
    private StatusText myEmptyText;
    private final JPanel mySelectedDependenciesPanel;
    private final MyActionListener myActionListener;

    WebStarterSelectedDependenciesPanel(WebStarterModuleBuilder<?> builder, List<? extends WebStarterOptions.MultiSelectGroup> dependencies, MyActionListener listener) {
        super(new BorderLayout());
        this.myBuilder = builder;
        this.myDependencies = dependencies;
        this.myActionListener = listener;
        JLabel selectedDepsLabel = new JLabel(FrameworksStartersBundle.message("title.some.selected.things", this.myBuilder.getDependenciesValidWord(true, true)));
        selectedDepsLabel.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        selectedDepsLabel.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)12, (int)0));
        this.add((Component)selectedDepsLabel, "North");
        this.mySelectedDependenciesPanel = new JPanel(new BorderLayout());
        this.mySelectedDependenciesPanel.setBackground(UIUtil.getListBackground());
        this.mySelectedDependenciesPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border()));
        this.add((Component)this.mySelectedDependenciesPanel, "Center");
    }

    void updateSelection(final Set<String> selectedDependenciesIds) {
        JPanel allDependencies = new JPanel((LayoutManager)new VerticalLayout(JBUIScale.scale((int)4))){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                WebStarterSelectedDependenciesPanel.this.myEmptyText.paint((Component)this, g);
            }
        };
        allDependencies.setBorder(JBUI.Borders.empty((int)4));
        allDependencies.setBackground(UIUtil.getListBackground());
        for (final WebStarterOptions.MultiSelectGroup multiSelectGroup : this.myDependencies) {
            if (!ContainerUtil.intersects(selectedDependenciesIds, (Collection)ContainerUtil.map(multiSelectGroup.options, option -> option.id))) continue;
            JPanel groupPanel = new JPanel(new BorderLayout());
            groupPanel.setBackground(UIUtil.getListBackground());
            groupPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
            HoverHyperlinkLabel groupLabel = new HoverHyperlinkLabel(multiSelectGroup.name, JBUI.CurrentTheme.Link.linkColor());
            groupLabel.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
            groupLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)8));
            groupLabel.setToolTipText(FrameworksStartersBundle.message("message.switch.to.category.on.the.left", new Object[0]));
            groupLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    WebStarterSelectedDependenciesPanel.this.myActionListener.navigateCategory(multiSelectGroup.name);
                }
            });
            groupPanel.add((Component)groupLabel, "North");
            JPanel groupDependencies = new JPanel((LayoutManager)new VerticalLayout(JBUIScale.scale((int)4)));
            groupDependencies.setBackground(UIUtil.getListBackground());
            groupDependencies.setBorder((Border)JBUI.Borders.empty((int)0, (int)20, (int)0, (int)10));
            for (final WebStarterOptions.Option option2 : multiSelectGroup.options) {
                if (!selectedDependenciesIds.contains(option2.id)) continue;
                DependencyAvailabilityVerificationResult result = this.myBuilder.isDependencyAvailable(option2, false);
                JLabel dependencyLabel = new JLabel(option2.display);
                dependencyLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)4, (int)10));
                if (!result.isAvailable) {
                    dependencyLabel.setEnabled(false);
                    dependencyLabel.setDisabledIcon(AllIcons.General.BalloonWarning);
                    if (!StringUtil.isEmpty((String)result.explanation)) {
                        dependencyLabel.setToolTipText(result.explanation);
                    }
                }
                JPanel dependencyPanel = new JPanel(new BorderLayout());
                dependencyPanel.setBackground(UIUtil.getListBackground());
                dependencyPanel.add((Component)dependencyLabel, "West");
                if (!this.myBuilder.isDependencyMustBeSelected(option2)) {
                    InplaceButton removeDependencyButton = new InplaceButton(new IconButton(FrameworksStartersBundle.message("button.tooltip.remove", new Object[0]), AllIcons.Actions.Close, AllIcons.Actions.CloseHovered), new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            WebStarterSelectedDependenciesPanel.this.myActionListener.onDependencyDeleted(option2.id);
                        }
                    });
                    removeDependencyButton.setCursor(Cursor.getPredefinedCursor(12));
                    removeDependencyButton.setTransform(0, -JBUIScale.scale((int)Math.max(2, dependencyLabel.getFont().getSize() / 15)));
                    dependencyPanel.add((Component)removeDependencyButton, "East");
                }
                groupDependencies.add(dependencyPanel);
            }
            groupPanel.add((Component)groupDependencies, "Center");
            allDependencies.add((Component)groupPanel, "TOP");
        }
        JScrollPane allDependenciesScrollPane = ScrollPaneFactory.createScrollPane((Component)allDependencies, (boolean)true);
        this.mySelectedDependenciesPanel.removeAll();
        this.mySelectedDependenciesPanel.add((Component)allDependenciesScrollPane, "Center");
        this.mySelectedDependenciesPanel.revalidate();
        this.myEmptyText = new StatusText(allDependencies){

            protected boolean isStatusVisible() {
                return selectedDependenciesIds.isEmpty();
            }
        };
        this.myEmptyText.setText(FrameworksStartersBundle.message("message.select.some.things.on.the.left", this.myBuilder.getDependenciesValidWord(true, false)));
        String string = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonShortcuts.getFind());
        this.myEmptyText.appendSecondaryText(FrameworksStartersBundle.message("message.use.shortcut.to.search.in.some.things", string, this.myBuilder.getDependenciesValidWord(true, false)), SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        WebStarterSelectedDependenciesPanel.setButtonsEnabled(this.mySelectedDependenciesPanel, enabled);
    }

    private static void setButtonsEnabled(Container container, boolean enabled) {
        for (Component component : container.getComponents()) {
            if (component instanceof JButton) {
                component.setEnabled(enabled);
                continue;
            }
            if (!(component instanceof Container)) continue;
            WebStarterSelectedDependenciesPanel.setButtonsEnabled((Container)component, enabled);
        }
    }

    static interface MyActionListener {
        public void onDependencyDeleted(String var1);

        public void navigateCategory(String var1);
    }
}

