/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.web.dependencies;

import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.utils.DependencyAvailabilityVerificationResult;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class WebStarterDependenciesTable
extends JBTable {
    private static final ColoredTableCellRenderer DEPENDENCY_RENDERER = new ColoredTableCellRenderer(){

        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (table == null) {
                1.$$$reportNull$$$0(0);
            }
            WebStarterOptions.Option option = (WebStarterOptions.Option)((Object)value);
            assert (option != null);
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            boolean tableHasFocus = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, table);
            this.setPaintFocusBorder(tableHasFocus && table.isRowSelected(row));
            boolean selectable = table.getModel().isCellEditable(row, 0);
            if (selectable) {
                this.append(option.display);
            } else {
                this.append(option.display, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/frameworks/starters/web/dependencies/WebStarterDependenciesTable$1", "customizeCellRenderer"));
        }
    };
    private final WebStarterModuleBuilder<?> myBuilder;

    WebStarterDependenciesTable(WebStarterModuleBuilder<?> builder) {
        this.myBuilder = builder;
        this.setFocusTraversalKeys(0, null);
        this.setFocusTraversalKeys(1, null);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (WebStarterDependenciesTable.this.getSelectedRow() == -1) {
                    WebStarterDependenciesTable.this.setRowSelectionInterval(0, 0);
                } else {
                    WebStarterDependenciesTable.this.repaint(WebStarterDependenciesTable.this.getVisibleRect());
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.setRowMargin(0);
        this.setShowColumns(false);
        this.setShowGrid(false);
        this.setShowVerticalLines(false);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        this.getActionMap().put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WebStarterDependenciesTable.this.isEditing()) {
                    return;
                }
                int row = WebStarterDependenciesTable.this.getSelectedRow();
                if (row < 0) {
                    return;
                }
                if (!WebStarterDependenciesTable.this.getModel().isCellEditable(row, 0)) {
                    return;
                }
                SpeedSearchSupply speedSearch = SpeedSearchSupply.getSupply((JComponent)((Object)WebStarterDependenciesTable.this));
                if (speedSearch != null) {
                    return;
                }
                boolean value = (Boolean)WebStarterDependenciesTable.this.getModel().getValueAt(row, 0);
                WebStarterDependenciesTable.this.getModel().setValueAt(!value, row, 0);
            }
        });
        new TableSpeedSearch((JTable)((Object)this), o -> {
            if (o instanceof WebStarterOptions.Option) {
                return ((WebStarterOptions.Option)((Object)((Object)o))).display;
            }
            return "";
        });
    }

    @Nullable
    WebStarterOptions.Option getSelectedValue() {
        int row = this.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return (WebStarterOptions.Option)((Object)this.getModel().getValueAt(row, 1));
    }

    void setDependencies(List<WebStarterOptions.Option> deps, Set<String> selectedDependenciesIds) {
        DependenciesTableModel model = new DependenciesTableModel(this.myBuilder, selectedDependenciesIds, deps);
        this.setModel(model);
        this.setupColumns();
    }

    private void setupColumns() {
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.setColumnMargin(0);
        TableColumn checkBoxColumn = columnModel.getColumn(0);
        TableUtil.setupCheckboxColumn((JTable)((Object)this), (int)0);
        checkBoxColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        TableColumn dependencyColumn = columnModel.getColumn(1);
        dependencyColumn.setCellRenderer((TableCellRenderer)DEPENDENCY_RENDERER);
    }

    void updateSelection(Set<String> selectedDependenciesIds) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            String id = ((WebStarterOptions.Option)((Object)this.getValueAt((int)row, (int)1))).id;
            this.setValueAt(selectedDependenciesIds.contains(id), row, 0);
        }
    }

    private static class DependenciesTableModel
    extends AbstractTableModel {
        private final Set<String> mySelectedDependenciesIds;
        private final List<WebStarterOptions.Option> myDependencies;
        private final boolean[] myChecked;
        private final boolean[] myDisabledCheckBoxes;
        private static final int COL_CHECK = 0;
        private static final int COL_DEP = 1;

        DependenciesTableModel(WebStarterModuleBuilder<?> builder, Set<String> selectedDependenciesIds, List<WebStarterOptions.Option> dependencies) {
            this.mySelectedDependenciesIds = selectedDependenciesIds;
            this.myDependencies = dependencies;
            this.myChecked = new boolean[this.myDependencies.size()];
            this.myDisabledCheckBoxes = new boolean[this.myDependencies.size()];
            int i = 0;
            for (WebStarterOptions.Option dependency : dependencies) {
                DependencyAvailabilityVerificationResult availability = builder.isDependencyAvailable(dependency, false);
                boolean mustBeSelected = builder.isDependencyMustBeSelected(dependency);
                if (!availability.isAvailable || mustBeSelected) {
                    this.myDisabledCheckBoxes[i] = true;
                }
                if (selectedDependenciesIds.contains(dependency.id)) {
                    this.myChecked[i] = true;
                }
                ++i;
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Boolean.class : String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return rowIndex >= 0 && rowIndex < this.myDependencies.size() && columnIndex == 0 && !this.myDisabledCheckBoxes[rowIndex];
        }

        @Override
        public int getRowCount() {
            return this.myDependencies.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                return this.myDependencies.get(rowIndex);
            }
            return this.myChecked[rowIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 0);
            this.myChecked[rowIndex] = (Boolean)aValue;
            boolean selected = this.myChecked[rowIndex];
            String id = this.myDependencies.get((int)rowIndex).id;
            if (selected) {
                this.mySelectedDependenciesIds.add(id);
            } else {
                this.mySelectedDependenciesIds.remove(id);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

