/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.web.dependencies;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.frameworks.starters.FrameworksStartersBundle;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.dependencies.LinkData;
import com.intellij.frameworks.starters.web.dependencies.WebStarterDependenciesTable;
import com.intellij.frameworks.starters.web.dependencies.WebStarterSelectedDependenciesPanel;
import com.intellij.frameworks.starters.web.utils.DependencyAvailabilityVerificationResult;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebStarterDependenciesStepPanel
extends JBLoadingPanel {
    private final WebStarterModuleBuilder<?> myBuilder;
    private final WebStarterOptions myOptions;
    private final SearchDependenciesFilter mySearchDependenciesFilter;
    @Nullable
    private final JBList<WebStarterOptions.MultiSelectGroup> myCategoriesList;
    @NotNull
    private final WebStarterDependenciesTable myDependenciesTable;
    @Nullable
    private final WebStarterSelectedDependenciesPanel mySelectedDependenciesPanel;

    public WebStarterDependenciesStepPanel(WebStarterModuleBuilder<?> builder, @NotNull Disposable parent) {
        if (parent == null) {
            WebStarterDependenciesStepPanel.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new BorderLayout(), parent);
        this.myBuilder = builder;
        this.myOptions = builder.getOptions();
        assert (this.myOptions != null);
        this.mySearchDependenciesFilter = new SearchDependenciesFilter();
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)4, (int)0));
        toolbarPanel.add((Component)((Object)this.mySearchDependenciesFilter), "West");
        AnAction customAction = this.myBuilder.createCustomDependenciesStepToolbarAction(this);
        if (customAction != null) {
            DefaultActionGroup group = new DefaultActionGroup();
            group.addAction(customAction);
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("WebStarterDependenciesStep", (ActionGroup)group, true);
            toolbar.updateActionsImmediately();
            toolbarPanel.add((Component)toolbar.getComponent(), "East");
        }
        AnAction activateSearchAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)WebStarterDependenciesStepPanel.this.mySearchDependenciesFilter.getTextEditor(), true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/frameworks/starters/web/dependencies/WebStarterDependenciesStepPanel$1", "actionPerformed"));
            }
        };
        activateSearchAction.registerCustomShortcutSet(CommonShortcuts.getFind(), (JComponent)((Object)this));
        String dependenciesWord = this.myBuilder.getDependenciesValidWord(true, false);
        this.mySearchDependenciesFilter.getTextEditor().setToolTipText(KeymapUtil.createTooltipText((String)FrameworksStartersBundle.message("hint.search.in.some.things", dependenciesWord), (AnAction)activateSearchAction));
        this.myDependenciesTable = new WebStarterDependenciesTable(this.myBuilder);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBackground(UIUtil.getListBackground());
        descriptionPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.setBackground(UIUtil.getListBackground());
        final JBLabel descriptionHeader = new JBLabel();
        descriptionHeader.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
        descriptionHeader.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        MultiLineLabel descriptionVersion = new MultiLineLabel();
        descriptionVersion.setIcon(AllIcons.General.BalloonWarning);
        descriptionVersion.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)8, (int)0));
        descriptionVersion.setVisible(false);
        headerPanel.add((Component)descriptionHeader, "North");
        headerPanel.add((Component)descriptionVersion, "Center");
        descriptionPanel.add((Component)headerPanel, "North");
        JTextArea descriptionText = new JTextArea();
        descriptionText.setFocusable(false);
        descriptionText.setBackground(UIUtil.getListBackground());
        descriptionText.setLineWrap(true);
        descriptionText.setWrapStyleWord(true);
        descriptionText.setEditable(false);
        descriptionText.setFont((Font)JBUI.Fonts.smallFont());
        descriptionPanel.add((Component)descriptionText, "Center");
        JPanel linksPanel = new JPanel((LayoutManager)new VerticalLayout(JBUIScale.scale((int)4)));
        linksPanel.setBackground(UIUtil.getListBackground());
        linksPanel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        descriptionPanel.add((Component)linksPanel, "South");
        this.myDependenciesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener((JLabel)descriptionVersion, descriptionText, linksPanel){
            final /* synthetic */ JLabel val$descriptionVersion;
            final /* synthetic */ JTextArea val$descriptionText;
            final /* synthetic */ JPanel val$linksPanel;
            {
                this.val$descriptionVersion = jLabel;
                this.val$descriptionText = jTextArea;
                this.val$linksPanel = jPanel;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                WebStarterOptions.Option dependency = WebStarterDependenciesStepPanel.this.myDependenciesTable.getSelectedValue();
                if (dependency == null) {
                    descriptionHeader.setText("");
                    this.val$descriptionVersion.setVisible(false);
                    this.val$descriptionText.setText("");
                    this.val$linksPanel.removeAll();
                    return;
                }
                descriptionHeader.setText(dependency.display);
                this.val$descriptionVersion.setVisible(false);
                DependencyAvailabilityVerificationResult result = WebStarterDependenciesStepPanel.this.myBuilder.isDependencyAvailable(dependency, true);
                if (!result.isAvailable) {
                    String explanation = result.explanation;
                    if (StringUtil.isEmpty((String)explanation)) {
                        explanation = FrameworksStartersBundle.message("message.unavailable.dependency.explanation.for.not.explained.cases", new Object[0]);
                    }
                    this.val$descriptionVersion.setText(explanation);
                    this.val$descriptionVersion.setVisible(true);
                }
                this.val$descriptionText.setText(dependency.description);
                this.val$descriptionText.setCaretPosition(0);
                this.val$linksPanel.removeAll();
                List<LinkData> links = WebStarterDependenciesStepPanel.this.myOptions.getLinksFor(dependency);
                if (links != null) {
                    for (LinkData link : links) {
                        String parsedUrl = WebStarterDependenciesStepPanel.this.myBuilder.parseLinkTemplate(link.getUrlTemplate());
                        if (parsedUrl == null || StringUtil.containsChar((String)parsedUrl, (char)'{')) continue;
                        HyperlinkLabel linkLabel = new HyperlinkLabel(link.getTitle());
                        linkLabel.setFont((Font)JBUI.Fonts.smallFont());
                        linkLabel.setHyperlinkTarget(parsedUrl);
                        linkLabel.setIconAtRight(false);
                        linkLabel.setIcon(link.getIcon());
                        linkLabel.setToolTipText(parsedUrl);
                        this.val$linksPanel.add((Component)linkLabel);
                    }
                }
            }
        });
        OnePixelSplitter depsAndDescriptionSplitter = new OnePixelSplitter(true, 0.7f, 0.5f, 0.8f);
        depsAndDescriptionSplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myDependenciesTable), (boolean)true));
        depsAndDescriptionSplitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)descriptionPanel, (boolean)true));
        if (this.myOptions.getDependenciesCategories().size() > 1) {
            this.myCategoriesList = this.createCategoriesList();
            this.mySelectedDependenciesPanel = this.createSelectedDependenciesPanel();
            OnePixelSplitter depsAndCategoriesSplitter = new OnePixelSplitter(false, 0.5f, 0.2f, 0.5f);
            depsAndCategoriesSplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane(this.myCategoriesList, (boolean)true));
            depsAndCategoriesSplitter.setSecondComponent((JComponent)depsAndDescriptionSplitter);
            JPanel depsAndCategoriesSplitterPanel = new JPanel(new BorderLayout());
            depsAndCategoriesSplitterPanel.setBorder(JBUI.Borders.merge((Border)JBUI.Borders.customLine((Color)JBColor.border()), (Border)JBUI.Borders.empty((int)0, (int)4), (boolean)true));
            depsAndCategoriesSplitterPanel.add((Component)depsAndCategoriesSplitter, "Center");
            JPanel depsAndCategoriesAndSearchPanel = new JPanel(new BorderLayout());
            depsAndCategoriesAndSearchPanel.setMinimumSize(depsAndCategoriesAndSearchPanel.getPreferredSize());
            depsAndCategoriesAndSearchPanel.add((Component)toolbarPanel, "North");
            depsAndCategoriesAndSearchPanel.add((Component)depsAndCategoriesSplitterPanel, "Center");
            JBSplitter mainSplitter = new JBSplitter(false, 0.7f);
            mainSplitter.setShowDividerIcon(false);
            mainSplitter.setShowDividerControls(false);
            mainSplitter.setDividerWidth(JBUIScale.scale((int)10));
            mainSplitter.setFirstComponent((JComponent)depsAndCategoriesAndSearchPanel);
            mainSplitter.setSecondComponent((JComponent)this.mySelectedDependenciesPanel);
            this.add((Component)mainSplitter, "Center");
        } else {
            this.myCategoriesList = null;
            this.mySelectedDependenciesPanel = null;
            JPanel depsAndDescriptionPanel = new JPanel(new BorderLayout());
            depsAndDescriptionPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border()));
            depsAndDescriptionPanel.add((Component)depsAndDescriptionSplitter, "Center");
            this.add(toolbarPanel, "North");
            this.add(depsAndDescriptionPanel, "Center");
        }
        this.rebuildDependenciesPanel();
    }

    @NotNull
    protected JBList<WebStarterOptions.MultiSelectGroup> createCategoriesList() {
        final JBList categoriesList = new JBList(this.myOptions.getDependenciesCategories());
        categoriesList.setSelectedIndex(0);
        categoriesList.setFixedCellHeight(JBUIScale.scale((int)22));
        ColoredListCellRenderer<WebStarterOptions.MultiSelectGroup> categoryRenderer = new ColoredListCellRenderer<WebStarterOptions.MultiSelectGroup>(){

            protected void customizeCellRenderer(@NotNull JList<? extends WebStarterOptions.MultiSelectGroup> list, WebStarterOptions.MultiSelectGroup value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.append(value.name);
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)categoriesList, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/frameworks/starters/web/dependencies/WebStarterDependenciesStepPanel$3", "customizeCellRenderer"));
            }
        };
        categoriesList.setCellRenderer((ListCellRenderer)categoryRenderer);
        new ListSpeedSearch((JList)categoriesList, entry -> entry.name);
        categoriesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                WebStarterDependenciesStepPanel.this.rebuildDependenciesPanel();
            }
        });
        JBList jBList = categoriesList;
        if (jBList == null) {
            WebStarterDependenciesStepPanel.$$$reportNull$$$0(1);
        }
        return jBList;
    }

    @NotNull
    protected WebStarterSelectedDependenciesPanel createSelectedDependenciesPanel() {
        return new WebStarterSelectedDependenciesPanel(this.myBuilder, this.myOptions.getDependenciesCategories(), new WebStarterSelectedDependenciesPanel.MyActionListener(){

            @Override
            public void onDependencyDeleted(String dependencyId) {
                WebStarterDependenciesStepPanel.this.myOptions.getSelectedDependenciesIds().remove(dependencyId);
                WebStarterDependenciesStepPanel.this.updateDependenciesTable();
                WebStarterDependenciesStepPanel.this.updateSelectedDependenciesPanel();
            }

            @Override
            public void navigateCategory(String categoryName) {
                if (WebStarterDependenciesStepPanel.this.myCategoriesList == null) {
                    return;
                }
                for (int i = 0; i < WebStarterDependenciesStepPanel.this.myCategoriesList.getItemsCount(); ++i) {
                    if (!((WebStarterOptions.MultiSelectGroup)WebStarterDependenciesStepPanel.this.myCategoriesList.getModel().getElementAt((int)i)).name.equals(categoryName)) continue;
                    WebStarterDependenciesStepPanel.this.myCategoriesList.setSelectedIndex(i);
                    break;
                }
            }
        });
    }

    public void onBecomeVisible() {
        this.ensureAllUnavailableDependenciesAreDeselected();
        this.ensureAllNecessaryDependenciesAreSelected();
        this.rebuildDependenciesPanel();
        this.updateSelectedDependenciesPanel();
    }

    private void ensureAllUnavailableDependenciesAreDeselected() {
        Set<String> selectedDependenciesIds = this.myOptions.getSelectedDependenciesIds();
        for (WebStarterOptions.MultiSelectGroup group : this.myOptions.getDependenciesCategories()) {
            for (WebStarterOptions.Option dependency : group.options) {
                if (this.myBuilder.isDependencyAvailable((WebStarterOptions.Option)dependency, (boolean)false).isAvailable) continue;
                selectedDependenciesIds.remove(dependency.id);
            }
        }
    }

    private void ensureAllNecessaryDependenciesAreSelected() {
        for (WebStarterOptions.MultiSelectGroup group : this.myOptions.getDependenciesCategories()) {
            for (WebStarterOptions.Option dependency : group.options) {
                if (!this.myBuilder.isDependencyMustBeSelected(dependency)) continue;
                this.myOptions.getSelectedDependenciesIds().add(dependency.id);
            }
        }
    }

    public void rebuildDependenciesPanel() {
        WebStarterOptions.MultiSelectGroup selectedCategory;
        if (this.myCategoriesList != null) {
            selectedCategory = (WebStarterOptions.MultiSelectGroup)this.myCategoriesList.getSelectedValue();
        } else if (!this.myOptions.getDependenciesCategories().isEmpty()) {
            selectedCategory = this.myOptions.getDependenciesCategories().get(0);
        } else {
            return;
        }
        this.myDependenciesTable.setDependencies(selectedCategory.options, this.myOptions.getSelectedDependenciesIds());
        this.myDependenciesTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                WebStarterDependenciesStepPanel.this.updateSelectedDependenciesPanel();
            }
        });
        this.updateDependenciesTable();
    }

    private void updateDependenciesTable() {
        this.myDependenciesTable.updateSelection(this.myOptions.getSelectedDependenciesIds());
    }

    public void updateSelectedDependenciesPanel() {
        if (this.mySelectedDependenciesPanel != null) {
            this.mySelectedDependenciesPanel.updateSelection(this.myOptions.getSelectedDependenciesIds());
        }
    }

    JComponent getPreferredFocusedComponent() {
        return this.myCategoriesList != null ? this.myCategoriesList : this.myDependenciesTable;
    }

    public void startLoading() {
        super.startLoading();
        WebStarterDependenciesStepPanel.updateEnabled(false, Arrays.asList(new JComponent[]{this.myCategoriesList, this.myDependenciesTable, this.mySearchDependenciesFilter.getTextEditor()}));
    }

    public void stopLoading() {
        super.stopLoading();
        WebStarterDependenciesStepPanel.updateEnabled(true, Arrays.asList(new JComponent[]{this.myCategoriesList, this.myDependenciesTable, this.mySearchDependenciesFilter.getTextEditor()}));
    }

    public void updateDataModel() {
        this.ensureAllUnavailableDependenciesAreDeselected();
    }

    private static void updateEnabled(boolean enabled, List<@Nullable JComponent> components) {
        for (JComponent component : components) {
            if (component == null) continue;
            component.setEnabled(enabled);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/frameworks/starters/web/dependencies/WebStarterDependenciesStepPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/frameworks/starters/web/dependencies/WebStarterDependenciesStepPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCategoriesList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SearchDependenciesFilter
    extends SearchTextField {
        private final SimpleTextAttributes DESCRIPTION_TEXT_ATTRIBUTES;
        private final SimpleTextAttributes DESCRIPTION_TEXT_DISABLED_ATTRIBUTES;
        private final JBList<WebStarterOptions.Option> myList;
        private JBPopup mySearchResultsPopup;

        private SearchDependenciesFilter() {
            super(false);
            this.DESCRIPTION_TEXT_ATTRIBUTES = new SimpleTextAttributes(128, null);
            this.DESCRIPTION_TEXT_DISABLED_ATTRIBUTES = SimpleTextAttributes.merge((SimpleTextAttributes)this.DESCRIPTION_TEXT_ATTRIBUTES, (SimpleTextAttributes)SimpleTextAttributes.GRAY_ATTRIBUTES);
            this.myList = new JBList();
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    SearchDependenciesFilter.this.filter();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/frameworks/starters/web/dependencies/WebStarterDependenciesStepPanel$SearchDependenciesFilter$1", "textChanged"));
                }
            });
            JLabel label = new JLabel(WebStarterDependenciesStepPanel.this.myBuilder.getDependenciesValidWord(true, true));
            label.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
            label.setBorder((Border)JBUI.Borders.emptyRight((int)10));
            this.add(label, "West");
            ScrollingUtil.installActions(this.myList, (JComponent)this.getTextEditor());
            new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    SearchDependenciesFilter.this.mySearchResultsPopup.closeOk(e.getInputEvent());
                    SearchDependenciesFilter.this.handleSelection();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/frameworks/starters/web/dependencies/WebStarterDependenciesStepPanel$SearchDependenciesFilter$2", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)this.getTextEditor());
        }

        protected void showPopup() {
        }

        private void filter() {
            String filterText = this.getText().trim();
            if (filterText.length() <= 1) {
                this.hideSearchResults();
                return;
            }
            MultiMap matchingDegreeResultsMap = new MultiMap(new TreeMap(Comparator.reverseOrder()));
            final MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + filterText)).withSeparators(" ").build();
            for (WebStarterOptions.MultiSelectGroup dependency : WebStarterDependenciesStepPanel.this.myOptions.getDependenciesCategories()) {
                for (WebStarterOptions.Option option : dependency.options) {
                    if (!matcher.matches(option.display) && !matcher.matches(option.description)) continue;
                    int display = matcher.matchingDegree(option.display);
                    int description = matcher.matchingDegree(option.description);
                    int matching = (display == Integer.MIN_VALUE ? 0 : display * 10) + (description == Integer.MIN_VALUE ? 0 : description);
                    boolean available = this.isDependencyAvailable(option);
                    int ranking = available ? Math.abs(matching) : -100000 + Math.abs(matching);
                    matchingDegreeResultsMap.putValue((Object)ranking, (Object)option);
                }
            }
            this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<WebStarterOptions.Option>(){

                protected void customizeCellRenderer(@NotNull JList<? extends WebStarterOptions.Option> list, WebStarterOptions.Option value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    boolean alreadySelectedDependency = WebStarterDependenciesStepPanel.this.myOptions.getSelectedDependenciesIds().contains(value.id);
                    boolean available = SearchDependenciesFilter.this.isDependencyAvailable(value);
                    Color listBackground = UIUtil.getListBackground((boolean)selected, (boolean)true);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)(value.display + "   "), (SimpleColoredComponent)this, (SimpleTextAttributes)(alreadySelectedDependency ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : (available ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES)), (Matcher)matcher, (Color)listBackground, (boolean)true);
                    String shortenedDescription = StringUtil.shortenTextWithEllipsis((String)value.description, (int)100, (int)0);
                    SpeedSearchUtil.appendColoredFragmentForMatcher((String)shortenedDescription, (SimpleColoredComponent)this, (SimpleTextAttributes)(available ? SearchDependenciesFilter.this.DESCRIPTION_TEXT_ATTRIBUTES : SearchDependenciesFilter.this.DESCRIPTION_TEXT_DISABLED_ATTRIBUTES), (Matcher)matcher, (Color)listBackground, (boolean)true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/frameworks/starters/web/dependencies/WebStarterDependenciesStepPanel$SearchDependenciesFilter$3", "customizeCellRenderer"));
                }
            });
            ArrayList matches = new ArrayList(matchingDegreeResultsMap.values());
            this.myList.setModel((ListModel)new CollectionListModel(matches));
            this.myList.setSelectedIndex(0);
            if (this.mySearchResultsPopup == null || this.mySearchResultsPopup.isDisposed()) {
                this.mySearchResultsPopup = JBPopupFactory.getInstance().createListPopupBuilder(this.myList).setItemChoosenCallback(this::handleSelection).setAdText(FrameworksStartersBundle.message("tip.how.to.select.a.thing.and.that.selected.things.are.shown.as.bold", KeymapUtil.getKeystrokeText((KeyStroke)KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.ENTER)), WebStarterDependenciesStepPanel.this.myBuilder.getDependenciesValidWord(true, false))).setRequestFocus(false).createPopup();
            }
            this.mySearchResultsPopup.pack(true, true);
            if (!this.mySearchResultsPopup.isVisible()) {
                this.mySearchResultsPopup.showUnderneathOf((Component)this.getTextEditor());
            }
        }

        private void handleSelection() {
            WebStarterOptions.Option selectedValue = (WebStarterOptions.Option)((Object)this.myList.getSelectedValue());
            if (selectedValue == null) {
                return;
            }
            if (this.isDependencyAvailable(selectedValue)) {
                WebStarterDependenciesStepPanel.this.myOptions.getSelectedDependenciesIds().add(selectedValue.id);
                WebStarterDependenciesStepPanel.this.updateDependenciesTable();
                WebStarterDependenciesStepPanel.this.updateSelectedDependenciesPanel();
                this.setText("");
            } else {
                this.showNotAvailableNotification(selectedValue);
            }
        }

        private void showNotAvailableNotification(WebStarterOptions.Option selectedValue) {
            for (WebStarterOptions.MultiSelectGroup dependency : WebStarterDependenciesStepPanel.this.myOptions.getDependenciesCategories()) {
                for (WebStarterOptions.Option option : dependency.options) {
                    if (!option.id.equals(selectedValue.id)) continue;
                    String dependencyWord = WebStarterDependenciesStepPanel.this.myBuilder.getDependenciesValidWord(false, true);
                    JComponent message = HintUtil.createErrorLabel((String)FrameworksStartersBundle.message("hint.something.with.name.is.not.available", dependencyWord, selectedValue.display, dependency.name));
                    BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder(message);
                    builder.setRequestFocus(false).setFadeoutTime(3000L).setFillColor(HintUtil.getErrorColor()).createBalloon().showInCenterOf((JComponent)this.getTextEditor());
                    return;
                }
            }
        }

        private void hideSearchResults() {
            if (this.mySearchResultsPopup != null) {
                this.mySearchResultsPopup.cancel();
            }
        }

        private boolean isDependencyAvailable(@NotNull WebStarterOptions.Option value) {
            if (value == null) {
                SearchDependenciesFilter.$$$reportNull$$$0(0);
            }
            return WebStarterDependenciesStepPanel.this.myBuilder.isDependencyAvailable((WebStarterOptions.Option)value, (boolean)false).isAvailable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/frameworks/starters/web/dependencies/WebStarterDependenciesStepPanel$SearchDependenciesFilter", "isDependencyAvailable"));
        }
    }
}

