/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.web.dependencies;

import com.intellij.frameworks.starters.FrameworksStartersBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkData {
    @NotNull
    private final String myUrlTemplate;
    @NotNull
    private final LinkType myLinkType;
    @Nullable
    private final String myCustomTitle;

    public LinkData(@NotNull String urlTemplate, @NotNull LinkType linkType) {
        if (urlTemplate == null) {
            LinkData.$$$reportNull$$$0(0);
        }
        if (linkType == null) {
            LinkData.$$$reportNull$$$0(1);
        }
        this(urlTemplate, linkType, null);
    }

    public LinkData(@NotNull String urlTemplate, @NotNull LinkType type, @Nullable String customTitle) {
        if (urlTemplate == null) {
            LinkData.$$$reportNull$$$0(2);
        }
        if (type == null) {
            LinkData.$$$reportNull$$$0(3);
        }
        this.myLinkType = type;
        this.myUrlTemplate = urlTemplate;
        this.myCustomTitle = customTitle;
    }

    @NotNull
    public LinkType getLinkType() {
        LinkType linkType = this.myLinkType;
        if (linkType == null) {
            LinkData.$$$reportNull$$$0(4);
        }
        return linkType;
    }

    @NotNull
    public String getUrlTemplate() {
        String string = this.myUrlTemplate;
        if (string == null) {
            LinkData.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getTitle() {
        String string = StringUtil.notNullize((String)this.myCustomTitle, (String)this.myLinkType.getDefaultTitle());
        if (string == null) {
            LinkData.$$$reportNull$$$0(6);
        }
        return string;
    }

    public Icon getIcon() {
        return this.myLinkType.getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlTemplate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/frameworks/starters/web/dependencies/LinkData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/frameworks/starters/web/dependencies/LinkData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum LinkType {
        GUIDE{

            @Override
            public Icon getIcon() {
                return AllIcons.Nodes.HomeFolder;
            }

            @Override
            public String getDefaultTitle() {
                return FrameworksStartersBundle.message("title.guide.link", new Object[0]);
            }
        }
        ,
        REFERENCE{

            @Override
            public Icon getIcon() {
                return AllIcons.Actions.Preview;
            }

            @Override
            public String getDefaultTitle() {
                return FrameworksStartersBundle.message("title.reference.doc.link", new Object[0]);
            }
        }
        ,
        OTHER{

            @Override
            public Icon getIcon() {
                return AllIcons.Actions.Help;
            }

            @Override
            public String getDefaultTitle() {
                return FrameworksStartersBundle.message("title.non.categorized.link", new Object[0]);
            }
        };


        public abstract Icon getIcon();

        public abstract String getDefaultTitle();
    }
}

