/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.web;

import com.intellij.frameworks.starters.FrameworksStartersBundle;
import com.intellij.frameworks.starters.web.WebStarterFormBuilder;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class WebStarterServiceChooserStep
extends ModuleWizardStep {
    private final String myLastServiceUrlPropertyName;
    private final WebStarterModuleBuilder<?> myBuilder;
    private final JBRadioButton defaultRadioButton = new JBRadioButton(FrameworksStartersBundle.message("radiobutton.name.default", new Object[0]) + ":", true);
    private final JBRadioButton customRadioButton = new JBRadioButton(FrameworksStartersBundle.message("radiobutton.name.custom", new Object[0]) + ":", false);
    private final TextFieldWithStoredHistory myServiceUrl;
    private final ComponentWithBrowseButton<TextFieldWithStoredHistory> customUrlWithBrowseButton;

    WebStarterServiceChooserStep(WebStarterModuleBuilder<?> builder) {
        this.myBuilder = builder;
        this.myLastServiceUrlPropertyName = this.myBuilder.getBuilderId() + ".service.url.last";
        this.myServiceUrl = new TextFieldWithStoredHistory(this.myBuilder.getBuilderId() + ".service.url.history");
        this.customUrlWithBrowseButton = new ComponentWithBrowseButton((JComponent)this.myServiceUrl, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    WebStarterServiceChooserStep.this.validate();
                    BrowserUtil.browse((String)WebStarterServiceChooserStep.this.myServiceUrl.getText());
                }
                catch (ConfigurationException ex) {
                    Messages.showErrorDialog((String)ex.getMessage(), (String)FrameworksStartersBundle.message("error.title.cannot.open.url", new Object[0]));
                }
            }
        });
        String lastServiceUrl = PropertiesComponent.getInstance().getValue(this.myLastServiceUrlPropertyName, this.myBuilder.getDefaultServiceUrl());
        if (!lastServiceUrl.equals(this.myBuilder.getDefaultServiceUrl())) {
            this.myServiceUrl.setSelectedItem((Object)lastServiceUrl);
            this.defaultRadioButton.setSelected(false);
            this.customRadioButton.setSelected(true);
        } else {
            this.defaultRadioButton.setSelected(true);
        }
        List history = this.myServiceUrl.getHistory();
        history.remove(this.myBuilder.getDefaultServiceUrl());
        this.myServiceUrl.setHistory(history);
        this.updateCustomUrl();
    }

    public JComponent getComponent() {
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.defaultRadioButton);
        group.add((AbstractButton)this.customRadioButton);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebStarterServiceChooserStep.this.updateCustomUrl();
            }
        };
        this.defaultRadioButton.addActionListener(listener);
        this.customRadioButton.addActionListener(listener);
        WebStarterFormBuilder builder = new WebStarterFormBuilder();
        builder.setFormLeftIndent(5);
        builder.addComponent((JComponent)new JBLabel(FrameworksStartersBundle.message("title.choose.starter.service.url", new Object[0]) + ":"));
        builder.addVerticalSpacing();
        BorderLayoutPanel defaultPanel = JBUI.Panels.simplePanel((int)10, (int)0);
        defaultPanel.addToLeft((Component)this.defaultRadioButton);
        HyperlinkLabel label = new HyperlinkLabel(this.myBuilder.getDefaultServiceUrl());
        label.setHyperlinkTarget(this.myBuilder.getDefaultServiceUrl());
        defaultPanel.addToCenter((Component)label);
        JPanel defaultPanelWrapper = new JPanel(new BorderLayout());
        defaultPanelWrapper.add((Component)defaultPanel, "West");
        builder.addComponent(defaultPanelWrapper);
        BorderLayoutPanel customPanel = JBUI.Panels.simplePanel((int)10, (int)0);
        customPanel.addToLeft((Component)this.customRadioButton);
        this.customUrlWithBrowseButton.setButtonIcon(AllIcons.Actions.ShowViewer);
        customPanel.addToCenter(this.customUrlWithBrowseButton);
        builder.addComponent((JComponent)customPanel);
        builder.addVerticalSpacing();
        builder.addTooltip(FrameworksStartersBundle.message("hint.check.network.connection.is.active", new Object[0]));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)builder.getPanel(), "North");
        return panel2;
    }

    private void updateCustomUrl() {
        boolean custom = this.customRadioButton.isSelected();
        this.myServiceUrl.getTextEditor().setEnabled(custom);
        this.myServiceUrl.getTextEditor().setEditable(custom);
        this.myServiceUrl.setEnabled(custom);
        this.customUrlWithBrowseButton.setButtonEnabled(custom);
    }

    public boolean validate() throws ConfigurationException {
        if (this.defaultRadioButton.isSelected()) {
            return true;
        }
        String serviceUrl = this.myServiceUrl.getText();
        if (serviceUrl.isEmpty()) {
            throw new ConfigurationException(FrameworksStartersBundle.message("message.custom.starter.service.url.must.be.set", new Object[0]));
        }
        if (!serviceUrl.startsWith("http://") && !serviceUrl.startsWith("https://")) {
            throw new ConfigurationException(FrameworksStartersBundle.message("message.invalid.custom.starter.service.url", new Object[0]));
        }
        try {
            new URL(serviceUrl);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException(FrameworksStartersBundle.message("message.invalid.custom.starter.service.url", new Object[0]));
        }
        return true;
    }

    public void updateDataModel() {
        String newServiceUrl;
        String string = newServiceUrl = this.customRadioButton.isSelected() ? this.myServiceUrl.getText() : this.myBuilder.getDefaultServiceUrl();
        if (!Comparing.strEqual((String)this.myBuilder.getServiceUrl(), (String)newServiceUrl)) {
            this.myServiceUrl.addCurrentTextToHistory();
            this.myBuilder.setServiceUrl(newServiceUrl);
            PropertiesComponent.getInstance().setValue(this.myLastServiceUrlPropertyName, newServiceUrl);
            this.myBuilder.setOptions(null);
        }
    }
}

