/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.web;

import com.intellij.frameworks.starters.FrameworksStartersBundle;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.Url;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.io.Decompressor;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebStarterProjectDownloader<T extends WebStarterOptions> {
    protected final WebStarterModuleBuilder<T> myBuilder;
    private static final String FILENAME = "filename=";

    protected WebStarterProjectDownloader(WebStarterModuleBuilder<T> builder) {
        this.myBuilder = builder;
    }

    public static String userAgent() {
        return ApplicationNamesInfo.getInstance().getFullProductName() + "/" + ApplicationInfo.getInstance().getFullVersion();
    }

    final void execute(final ProgressIndicator indicator) throws IOException {
        final File tempFile = FileUtil.createTempFile((String)this.myBuilder.getBuilderId(), (String)".tmp", (boolean)true);
        DownloadResult downloadResult = (DownloadResult)HttpRequests.request((String)this.buildUrl().toExternalForm()).userAgent(WebStarterProjectDownloader.userAgent()).connectTimeout(10000).isReadResponseOnError(true).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<DownloadResult>(){

            public DownloadResult process(@NotNull HttpRequests.Request request) throws IOException {
                URLConnection requestConnection;
                if (request == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    requestConnection = request.getConnection();
                }
                catch (IOException e) {
                    Logger.getInstance(WebStarterProjectDownloader.class).info("Can't download project. Message (with headers info): " + HttpRequests.createErrorMessage((IOException)e, (HttpRequests.Request)request, (boolean)true));
                    throw new IOException(HttpRequests.createErrorMessage((IOException)e, (HttpRequests.Request)request, (boolean)false), e);
                }
                String contentType = requestConnection.getContentType();
                String contentDisposition = requestConnection.getHeaderField("Content-Disposition");
                String filename = WebStarterProjectDownloader.getFilename(contentDisposition);
                boolean isZip = StringUtil.isNotEmpty((String)contentType) && contentType.startsWith("application/zip") || filename.endsWith(".zip");
                indicator.setText(filename);
                request.saveToFile(tempFile, indicator);
                return new DownloadResult(isZip, filename);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/frameworks/starters/web/WebStarterProjectDownloader$1", "process"));
            }
        });
        indicator.setText(FrameworksStartersBundle.message("message.state.preparing.template", new Object[0]));
        String path = this.myBuilder.getContentEntryPath();
        assert (path != null);
        File contentEntryDir = new File(path);
        if (downloadResult.isZip) {
            this.unzip(tempFile, contentEntryDir);
            WebStarterProjectDownloader.fixExecutableFlag(contentEntryDir, "gradlew");
            WebStarterProjectDownloader.fixExecutableFlag(contentEntryDir, "mvnw");
        } else {
            File targetFile = new File(contentEntryDir, downloadResult.filename);
            FileUtil.copy((File)tempFile, (File)targetFile);
        }
        VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(contentEntryDir);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{vf});
    }

    protected abstract void unzip(File var1, File var2) throws IOException;

    protected abstract Url buildUrl();

    private static void fixExecutableFlag(File containingDir, String relativePath) {
        File toFix = new File(containingDir, relativePath);
        if (toFix.exists()) {
            toFix.setExecutable(true, false);
        }
    }

    @NlsSafe
    @NotNull
    private static String getFilename(@Nullable String contentDisposition) {
        if (StringUtil.isEmpty((String)contentDisposition)) {
            return "unknown";
        }
        int startIdx = contentDisposition.indexOf(FILENAME);
        int endIdx = contentDisposition.indexOf(59, startIdx);
        String fileName = contentDisposition.substring(startIdx + FILENAME.length(), endIdx > 0 ? endIdx : contentDisposition.length());
        if (StringUtil.startsWithChar((CharSequence)fileName, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName, (char)'\"')) {
            fileName = fileName.substring(1, fileName.length() - 1);
        }
        String string = fileName;
        if (string == null) {
            WebStarterProjectDownloader.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected static String getParameter(CollectionComboBoxModel<WebStarterOptions.Option> model) {
        return WebStarterProjectDownloader.getParameter(model, false);
    }

    protected static String getParameter(CollectionComboBoxModel<WebStarterOptions.Option> model, boolean toUpperCase) {
        WebStarterOptions.Option item = (WebStarterOptions.Option)((Object)model.getSelected());
        assert (item != null) : model;
        return toUpperCase ? item.id.toUpperCase(Locale.ENGLISH) : item.id;
    }

    protected static void unzipSubfolder(File tempZipFile, File contentEntryDir) throws IOException {
        String rootFolderName;
        try (ZipFile jar = new ZipFile(tempZipFile);){
            Enumeration<? extends ZipEntry> entries = jar.entries();
            if (!entries.hasMoreElements()) {
                throw new UnexpectedArchiveStructureException("The archive is empty");
            }
            SmartHashSet rootFolders = new SmartHashSet();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Path path = Paths.get(entry.getName(), new String[0]);
                if (path.getNameCount() <= 0) continue;
                rootFolders.add(path.normalize().getName(0).toString());
            }
            if (rootFolders.size() != 1) {
                throw new UnexpectedArchiveStructureException("The archive should have 1 subdirectory, but has: " + StringUtil.join((Collection)rootFolders, (String)","));
            }
            rootFolderName = (String)rootFolders.iterator().next();
        }
        new Decompressor.Zip(tempZipFile).removePrefixPath(rootFolderName).extract(contentEntryDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/frameworks/starters/web/WebStarterProjectDownloader", "getFilename"));
    }

    private static final class UnexpectedArchiveStructureException
    extends IOException {
        private UnexpectedArchiveStructureException(String message) {
            super(message);
        }
    }

    private static class DownloadResult {
        final boolean isZip;
        final String filename;

        DownloadResult(boolean isZip, String filename) {
            this.isZip = isZip;
            this.filename = filename;
        }
    }
}

