/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.web;

import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.frameworks.starters.FrameworksStartersBundle;
import com.intellij.frameworks.starters.shared.StarterModuleImportTask;
import com.intellij.frameworks.starters.web.WebStarterApplicationInfoStep;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.WebStarterProjectDownloader;
import com.intellij.frameworks.starters.web.WebStarterServiceChooserStep;
import com.intellij.frameworks.starters.web.dependencies.WebStarterDependenciesStep;
import com.intellij.frameworks.starters.web.dependencies.WebStarterDependenciesStepPanel;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoader;
import com.intellij.frameworks.starters.web.utils.DependencyAvailabilityVerificationResult;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.util.concurrency.EdtExecutorService;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebStarterModuleBuilder<T extends WebStarterOptions>
extends ModuleBuilder {
    private T myOptions;
    private String myServiceUrl;
    private boolean myCreatingNewProject;

    public final T getOptions() {
        return this.myOptions;
    }

    public final void setOptions(T options) {
        this.myOptions = options;
    }

    public final String getServiceUrl() {
        return this.myServiceUrl;
    }

    final void setServiceUrl(String serviceUrl) {
        this.myServiceUrl = serviceUrl;
    }

    @Nullable
    public final ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        ModuleNameLocationSettings moduleNameLocationSettings;
        if (settingsStep == null) {
            WebStarterModuleBuilder.$$$reportNull$$$0(0);
        }
        if ((moduleNameLocationSettings = settingsStep.getModuleNameLocationSettings()) != null) {
            moduleNameLocationSettings.setModuleName(((WebStarterOptions)this.myOptions).getArtifact());
        }
        return super.modifySettingsStep(settingsStep);
    }

    public final ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            WebStarterModuleBuilder.$$$reportNull$$$0(1);
        }
        if (modulesProvider == null) {
            WebStarterModuleBuilder.$$$reportNull$$$0(2);
        }
        return new ModuleWizardStep[]{this.createApplicationInfoStep(wizardContext), this.createDependenciesStep(wizardContext)};
    }

    @NotNull
    protected WebStarterDependenciesStep createDependenciesStep(@NotNull WizardContext wizardContext) {
        if (wizardContext == null) {
            WebStarterModuleBuilder.$$$reportNull$$$0(3);
        }
        return new WebStarterDependenciesStep(this, wizardContext);
    }

    protected abstract WebStarterApplicationInfoStep<T> createApplicationInfoStep(WizardContext var1);

    public final ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new WebStarterServiceChooserStep(this);
    }

    public final String getParentGroup() {
        return "Build Tools";
    }

    public final int getWeight() {
        return 90;
    }

    public ModuleType<?> getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public final boolean isSuitableSdkType(SdkTypeId sdkType) {
        return sdkType instanceof JavaSdkType && !((JavaSdkType)sdkType).isDependent();
    }

    protected void setCreatingNewProject(boolean creatingNewProject) {
        this.myCreatingNewProject = creatingNewProject;
    }

    protected void setupModule(Module module) throws ConfigurationException {
        super.setupModule(module);
        Project project = module.getProject();
        if (this.myCreatingNewProject) {
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
            project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)Boolean.TRUE);
        }
        StartupManager.getInstance((Project)project).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> this.downloadAndImport(module), ModalityState.NON_MODAL, module.getDisposed()));
    }

    private void downloadAndImport(@NotNull Module module) {
        if (module == null) {
            WebStarterModuleBuilder.$$$reportNull$$$0(4);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                WebStarterProjectDownloader<T> downloader = this.createProjectDownloader();
                downloader.execute(ProgressManager.getInstance().getProgressIndicator());
            }
            catch (IOException e) {
                Logger.getInstance(WebStarterModuleBuilder.class).info((Throwable)e);
                EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
                    String message = FrameworksStartersBundle.message("error.text.with.error.content", e.getMessage());
                    message = StringUtil.shortenTextWithEllipsis((String)message, (int)1024, (int)0);
                    Messages.showErrorDialog((String)message, (String)this.getPresentableName());
                }, 3L, TimeUnit.SECONDS);
            }
        }, FrameworksStartersBundle.message("message.state.downloading.template", this.getPresentableName()), true, null);
        LocalFileSystem.getInstance().refresh(false);
        if (this.isReformatAfterCreation(module.getProject())) {
            new ReformatCodeProcessor(module.getProject(), module, false).run();
        }
        this.performModuleBuilderPostTask(module);
        this.verifyIdePlugins(module.getProject());
    }

    protected void performModuleBuilderPostTask(Module module) {
        StarterModuleImportTask[] moduleBuilderPostTasks;
        if (module.isDisposed()) {
            return;
        }
        for (StarterModuleImportTask task : moduleBuilderPostTasks = (StarterModuleImportTask[])StarterModuleImportTask.EP_NAME.getExtensions()) {
            if (!task.runAfterSetup(module)) break;
        }
    }

    @NotNull
    public abstract DependencyAvailabilityVerificationResult isDependencyAvailable(WebStarterOptions.Option var1, boolean var2);

    public AnAction createCustomDependenciesStepToolbarAction(WebStarterDependenciesStepPanel dependenciesStepPanel) {
        return null;
    }

    @NlsSafe
    public String parseLinkTemplate(String linkTemplate) {
        return linkTemplate;
    }

    @Nls
    public abstract String getDependenciesValidWord(boolean var1, boolean var2);

    @NotNull
    @NonNls
    public abstract String getBuilderId();

    @NlsSafe
    public abstract String getDefaultServiceUrl();

    protected abstract boolean isReformatAfterCreation(Project var1);

    protected abstract WebStarterOptionsLoader<T> createOptionsDownloader();

    protected abstract WebStarterProjectDownloader<T> createProjectDownloader();

    protected void verifyIdePlugins(Project project) {
    }

    public String getHelpId() {
        return null;
    }

    public boolean isDependencyMustBeSelected(WebStarterOptions.Option dependency) {
        return false;
    }

    static {
        PluginVerifier.verifyUltimatePlugin();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/frameworks/starters/web/WebStarterModuleBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "modifySettingsStep";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createWizardSteps";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createDependenciesStep";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadAndImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

