/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.web;

import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class WebStarterFormBuilder
extends FormBuilder {
    private static final String FILL_KEY = "Fill";

    public WebStarterFormBuilder() {
        this.setFormLeftIndent(10);
    }

    protected int getFill(JComponent component) {
        if (component.getClientProperty(FILL_KEY) == Boolean.TRUE) {
            return 2;
        }
        return super.getFill(component);
    }

    public ComboBox<WebStarterOptions.Option> addComboBox(@NlsContexts.Label String label, CollectionComboBoxModel<WebStarterOptions.Option> model) {
        return this.addComboBox(label, model, false);
    }

    public ComboBox<WebStarterOptions.Option> addComboBox(@NlsContexts.Label String label, CollectionComboBoxModel<WebStarterOptions.Option> model, boolean fillWidth) {
        final ComboBox comboBox = new ComboBox(model);
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<WebStarterOptions.Option>(){

            protected void customizeCellRenderer(@NotNull JList<? extends WebStarterOptions.Option> list, WebStarterOptions.Option option, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (option == null) {
                    return;
                }
                this.append(option.display);
                String description = option.description;
                if (StringUtil.isNotEmpty((String)description)) {
                    this.append(" (" + description + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)comboBox, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/frameworks/starters/web/WebStarterFormBuilder$1", "customizeCellRenderer"));
            }
        });
        new ComboboxSpeedSearch((JComboBox)comboBox){

            protected String getElementText(Object element) {
                WebStarterOptions.Option option = (WebStarterOptions.Option)((Object)element);
                return option.display;
            }
        };
        if (fillWidth) {
            comboBox.putClientProperty((Object)FILL_KEY, (Object)Boolean.TRUE);
        }
        this.addLabeledComponent(label + ":", (JComponent)comboBox);
        return comboBox;
    }

    public JBTextField addTextField(@NlsContexts.Label String label, @NlsSafe String value) {
        JBTextField field = new JBTextField(value);
        this.addLabeledComponent(label + ":", (JComponent)field);
        return field;
    }

    public void addVerticalSpacing() {
        this.addVerticalGap(4);
    }

    public JPanel addRadioButtonsGroup(@NlsContexts.Label String label, final CollectionComboBoxModel<WebStarterOptions.Option> optionsModel) {
        JPanel panel2 = new JPanel(null);
        panel2.setLayout(new BoxLayout(panel2, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean needToSelectOne = true;
        for (final WebStarterOptions.Option item : optionsModel.getItems()) {
            JBRadioButton radioButton = new JBRadioButton(item.display, false);
            radioButton.getModel().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        optionsModel.setSelectedItem((Object)item);
                    }
                }
            });
            if (needToSelectOne) {
                radioButton.setSelected(true);
                needToSelectOne = false;
            }
            buttonGroup.add((AbstractButton)radioButton);
            panel2.add((Component)radioButton);
            panel2.add(Box.createHorizontalStrut(10));
        }
        this.addLabeledComponent(label + ":", panel2);
        return panel2;
    }
}

