/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.web;

import com.intellij.frameworks.starters.FrameworksStartersBundle;
import com.intellij.frameworks.starters.shared.StartersValidationUtils;
import com.intellij.frameworks.starters.web.WebStarterFormBuilder;
import com.intellij.frameworks.starters.web.WebStarterModuleBuilder;
import com.intellij.frameworks.starters.web.WebStarterOptions;
import com.intellij.frameworks.starters.web.optionsDownloader.WebStarterOptionsLoader;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBFont;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public abstract class WebStarterApplicationInfoStep<T extends WebStarterOptions>
extends ModuleWizardStep
implements Disposable {
    protected final WebStarterModuleBuilder<T> myBuilder;
    protected final WizardContext myWizardContext;
    private final List<JTextField> validatedTextComponents = new ArrayList<JTextField>();
    private final JBLoadingPanel myPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
    private boolean isDisposed = false;

    public WebStarterApplicationInfoStep(WebStarterModuleBuilder<T> builder, WizardContext wizardContext) {
        this.myBuilder = builder;
        this.myWizardContext = wizardContext;
    }

    public final void _init() {
        T options = this.myBuilder.getOptions();
        if (options == null) {
            this.loadOptions();
        }
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        super._commit(finishChosen);
    }

    public void updateDataModel() {
        this.myBuilder.setCreatingNewProject(this.myWizardContext.isCreatingNewProject());
    }

    public final void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public boolean validate() throws ConfigurationException {
        if (this.myBuilder.getOptions() == null) {
            return false;
        }
        boolean[] errorFound = new boolean[]{false};
        for (JTextComponent jTextComponent : this.validatedTextComponents) {
            ComponentValidator.getInstance((JComponent)jTextComponent).ifPresent(validator -> {
                validator.revalidate();
                if (validator.getValidationInfo() != null) {
                    if (!errorFound[0]) {
                        component.requestFocus();
                    }
                    errorFound[0] = true;
                }
            });
        }
        return !errorFound[0];
    }

    private void loadOptions() {
        this.myPanel.getContentPanel().removeAll();
        this.myPanel.setLoadingText(FrameworksStartersBundle.message("message.state.connecting.and.retrieving.options", new Object[0]));
        this.myPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String serviceUrl = this.myBuilder.getServiceUrl();
            try {
                WebStarterOptionsLoader<T> loader = this.myBuilder.createOptionsDownloader();
                T options = loader.loadOptions(serviceUrl);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.isDisposed) {
                        return;
                    }
                    this.myBuilder.setOptions((WebStarterOptions)options);
                    this.createAppSettingsPanel(options);
                }, ModalityState.stateForComponent((Component)this.myPanel));
            }
            catch (IOException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)FrameworksStartersBundle.message("message.no.connection.with.error.content", serviceUrl, e.getMessage()), (String)FrameworksStartersBundle.message("message.title.error", new Object[0])), ModalityState.stateForComponent((Component)this.myPanel));
                this.myWizardContext.getWizard().updateButtons(false, false, false);
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myPanel.stopLoading();
                    this.myPanel.revalidate();
                }, ModalityState.stateForComponent((Component)this.myPanel));
            }
        });
    }

    private void createAppSettingsPanel(T options) {
        if (options == null) {
            return;
        }
        WebStarterFormBuilder formBuilder = new WebStarterFormBuilder();
        JLabel label = new JLabel(FrameworksStartersBundle.message("title.for.application.info.step", this.myBuilder.getPresentableName()));
        label.setFont(JBFont.label().deriveFont(1));
        formBuilder.addVerticalSpacing();
        formBuilder.addComponent(label);
        formBuilder.addVerticalSpacing();
        this.fillAppSettingsPanel(formBuilder, options);
        formBuilder.addVerticalSpacing();
        JPanel panelWithComponents = formBuilder.getPanel();
        WebStarterApplicationInfoStep.fixatePanelWidth(panelWithComponents);
        JPanel sizeLimiterPanel = new JPanel(null);
        sizeLimiterPanel.setLayout(new BoxLayout(sizeLimiterPanel, 0));
        sizeLimiterPanel.add(panelWithComponents);
        this.myPanel.add((Component)sizeLimiterPanel, (Object)"North");
        this.setInitialFocus(this.myPanel);
    }

    protected abstract void fillAppSettingsPanel(WebStarterFormBuilder var1, T var2);

    protected void registerTextComponentValidation(final JTextField textField, StartersValidationUtils.ValidationUnit ... validationUnits) {
        if (validationUnits.length <= 0) {
            return;
        }
        Supplier<ValidationInfo> validationFunc2 = () -> {
            String text = textField.getText();
            for (StartersValidationUtils.ValidationUnit validationUnit : validationUnits) {
                String errorMessage = validationUnit.checkText(text);
                if (errorMessage == null) continue;
                return new ValidationInfo(errorMessage, (JComponent)textField);
            }
            return null;
        };
        new ComponentValidator((Disposable)this).withValidator(validationFunc2).installOn((JComponent)textField);
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ComponentValidator.getInstance((JComponent)textField).ifPresent(v -> v.updateInfo(null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/frameworks/starters/web/WebStarterApplicationInfoStep$1", "textChanged"));
            }
        });
        textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ComponentValidator.getInstance((JComponent)textField).ifPresent(v -> v.revalidate());
            }
        });
        this.validatedTextComponents.add(textField);
    }

    protected static void equalizeAllInnerComponentsWidthByIndex(List<JPanel> panels) {
        int index = 0;
        while (true) {
            Component comp;
            int componentsCount = 0;
            int maxPrefWidth = 0;
            for (JPanel panel2 : panels) {
                if (index >= panel2.getComponentCount()) continue;
                comp = panel2.getComponent(index);
                ++componentsCount;
                maxPrefWidth = Math.max(maxPrefWidth, comp.getPreferredSize().width);
            }
            if (componentsCount < 2) {
                return;
            }
            if (maxPrefWidth > 0) {
                for (JPanel panel2 : panels) {
                    if (index >= panel2.getComponentCount()) continue;
                    comp = panel2.getComponent(index);
                    if (comp.getPreferredSize().width != maxPrefWidth) {
                        comp.setPreferredSize(new Dimension(maxPrefWidth, comp.getPreferredSize().height));
                    }
                    if (comp.getMaximumSize().width == maxPrefWidth) continue;
                    comp.setMaximumSize(new Dimension(maxPrefWidth, comp.getMaximumSize().height));
                }
            }
            ++index;
        }
    }

    protected abstract void setInitialFocus(JBLoadingPanel var1);

    private static void fixatePanelWidth(JPanel panel2) {
        int maxWidth = GraphicsUtil.stringWidth((String)"m", (Font)JBFont.label()) * 60;
        panel2.setMaximumSize(new Dimension(maxWidth, panel2.getMaximumSize().height));
    }

    public final JComponent getComponent() {
        return this.myPanel;
    }

    public void dispose() {
        this.isDisposed = true;
    }

    public final String getHelpId() {
        return this.myBuilder.getHelpId();
    }
}

