/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.shared;

import com.intellij.frameworks.starters.FrameworksStartersBundle;
import com.intellij.psi.impl.PsiNameHelperImpl;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;

public class StartersValidationUtils {
    public static final ValidationUnit CHECK_PACKAGE_NAME = fieldText -> {
        if (!PsiNameHelperImpl.getInstance().isQualifiedName(fieldText)) {
            return FrameworksStartersBundle.message("message.some.string.is.not.a.valid.package.name", fieldText);
        }
        return null;
    };
    public static final ValidationUnit CHECK_SIMPLE_NAME_FORMAT = new ValidationUnit(){
        private final Pattern myPattern = Pattern.compile("[a-zA-Z0-9-._ ]*");

        @Override
        public String checkText(String fieldText) {
            if (!this.myPattern.matcher(fieldText).matches()) {
                return FrameworksStartersBundle.message("message.only.latin.characters.digits.spaces.and.some.other.symbols.are.allowed.here", new Object[0]);
            }
            return null;
        }
    };
    public static final ValidationUnit CHECK_NOT_EMPTY = fieldText -> {
        if (fieldText.isEmpty()) {
            return FrameworksStartersBundle.message("message.field.must.be.set", new Object[0]);
        }
        return null;
    };
    public static final ValidationUnit CHECK_NO_WHITESPACES = fieldText -> {
        if (fieldText.contains(" ")) {
            return FrameworksStartersBundle.message("message.whitespaces.are.not.allowed.here", new Object[0]);
        }
        return null;
    };
    public static final ValidationUnit CHECK_NO_RESERVED_WORDS = new ValidationUnit(){
        private final Pattern myPattern = Pattern.compile("(^|[ .])(con|prn|aux|nul|com\\d|lpt\\d)($|[ .])", 2);

        @Override
        public String checkText(String fieldText) {
            if (this.myPattern.matcher(fieldText).find()) {
                return FrameworksStartersBundle.message("message.some.parts.are.not.allowed.here", new Object[0]);
            }
            return null;
        }
    };
    public static final ValidationUnit CHECK_GROUP_FORMAT = new ValidationUnit(){
        private final Pattern myPatternForEntireText = Pattern.compile("[a-zA-Z\\d_.]*");
        private final Pattern myPatternForOneWord = Pattern.compile("[a-zA-Z_].*");

        @Override
        public String checkText(String fieldText) {
            String[] wordsBetweenDots;
            if (!this.myPatternForEntireText.matcher(fieldText).matches()) {
                return FrameworksStartersBundle.message("message.only.latin.characters.digits.and.some.other.symbols.are.allowed.here", new Object[0]);
            }
            char firstSymbol = fieldText.charAt(0);
            char lastSymbol = fieldText.charAt(fieldText.length() - 1);
            if (firstSymbol == '.' || lastSymbol == '.') {
                return FrameworksStartersBundle.message("message.must.not.start.or.end.with.dot", new Object[0]);
            }
            if (fieldText.contains("..")) {
                return FrameworksStartersBundle.message("message.must.not.contain.double.dot.sequences", new Object[0]);
            }
            for (String word : wordsBetweenDots = fieldText.split("\\.")) {
                if (this.myPatternForOneWord.matcher(word).matches()) continue;
                return FrameworksStartersBundle.message("message.part.is.incorrect.and.must.start.with.latin.character.or.some.other.symbols", word);
            }
            return null;
        }
    };
    public static final ValidationUnit CHECK_ARTIFACT_SIMPLE_FORMAT = new ValidationUnit(){
        private final Pattern myUsedSymbolsCheckPattern = Pattern.compile("[a-zA-Z0-9-_]*");
        private final Pattern myFirstSymbolCheckPattern = Pattern.compile("[a-zA-Z_].*");

        @Override
        public String checkText(String fieldText) {
            if (!this.myUsedSymbolsCheckPattern.matcher(fieldText).matches()) {
                return FrameworksStartersBundle.message("message.allowed.symbols.for.check.artifact.simple.format", new Object[0]);
            }
            if (!this.myFirstSymbolCheckPattern.matcher(fieldText).matches()) {
                return FrameworksStartersBundle.message("message.allows.first.symbol.for.check.artifact.simple.format", new Object[0]);
            }
            return null;
        }
    };
    public static final ValidationUnit CHECK_ARTIFACT_FORMAT_FOR_WEB = new ValidationUnit(){
        private final Pattern myPattern = Pattern.compile("[a-z0-9-._]*");

        @Override
        public String checkText(String fieldText) {
            if (!this.myPattern.matcher(fieldText).matches()) {
                return FrameworksStartersBundle.message("message.only.lowercase.latin.characters.digits.and.some.other.symbols.are.allowed.here", new Object[0]);
            }
            if (fieldText.charAt(0) < 'a' || fieldText.charAt(0) > 'z') {
                return FrameworksStartersBundle.message("message.must.start.with.lowercase.latin.character", new Object[0]);
            }
            return null;
        }
    };

    @FunctionalInterface
    public static interface ValidationUnit {
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String checkText(String var1);
    }
}

