/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.shared;

import com.intellij.frameworks.starters.shared.StarterModuleImportTask;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

final class MavenModuleImportTask
implements StarterModuleImportTask {
    MavenModuleImportTask() {
    }

    @Override
    public String getId() {
        return "maven";
    }

    @Override
    public String getTitle() {
        return "Maven";
    }

    @Override
    public boolean runAfterSetup(Module module) {
        Project project = module.getProject();
        ArrayList<VirtualFile> pomXmls = new ArrayList<VirtualFile>();
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            MavenModuleImportTask.collectPomXml(contentRoot, pomXmls);
            if (!pomXmls.isEmpty()) break;
        }
        if (pomXmls.isEmpty()) {
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                for (VirtualFile child : contentRoot.getChildren()) {
                    if (!child.isDirectory()) continue;
                    MavenModuleImportTask.collectPomXml(child, pomXmls);
                }
            }
        }
        if (pomXmls.isEmpty()) {
            return true;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
        mavenProjectsManager.addManagedFiles(pomXmls);
        return false;
    }

    private static void collectPomXml(VirtualFile directoryFrom, Collection<VirtualFile> collectionInto) {
        VirtualFile child = directoryFrom.findChild("pom.xml");
        if (child != null) {
            collectionInto.add(child);
        }
    }
}

