/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.shared;

import com.intellij.frameworks.starters.shared.StarterModuleImportTask;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;

final class GradleModuleImportTask
implements StarterModuleImportTask {
    GradleModuleImportTask() {
    }

    @Override
    public String getId() {
        return "gradle";
    }

    @Override
    public String getTitle() {
        return "Gradle";
    }

    @Override
    public boolean runAfterSetup(Module module) {
        Project project = module.getProject();
        File gradleFile = GradleModuleImportTask.findGradleFile(module);
        if (gradleFile == null) {
            return true;
        }
        String rootDirectory = gradleFile.getParent();
        GradleModuleImportTask.fixGradlewExecutableFlag(gradleFile.getParentFile());
        if (!GradleProjectImportUtil.canLinkAndRefreshGradleProject((String)rootDirectory, (Project)project)) {
            return false;
        }
        GradleProjectImportUtil.linkAndRefreshGradleProject((String)rootDirectory, (Project)project);
        return true;
    }

    @Nullable
    private static File findGradleFile(@NotNull Module module) {
        if (module == null) {
            GradleModuleImportTask.$$$reportNull$$$0(0);
        }
        for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            File baseDir = VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot);
            File file = new File(baseDir, "build.gradle");
            if (file.exists()) {
                return file;
            }
            file = new File(baseDir, "build.gradle.kts");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private static void fixGradlewExecutableFlag(File containingDir) {
        File toFix = new File(containingDir, "gradlew");
        if (toFix.exists()) {
            toFix.setExecutable(true, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/frameworks/starters/shared/GradleModuleImportTask", "findGradleFile"));
    }
}

