/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.local.generator;

import com.intellij.frameworks.starters.local.GeneratorAsset;
import com.intellij.frameworks.starters.local.GeneratorContext;
import com.intellij.frameworks.starters.local.GeneratorEmptyDirectory;
import com.intellij.frameworks.starters.local.GeneratorResourceFile;
import com.intellij.frameworks.starters.local.GeneratorTemplateFile;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/frameworks/starters/local/generator/AssetsProcessor;", "", "()V", "generateSources", "", "context", "Lcom/intellij/frameworks/starters/local/GeneratorContext;", "templateProps", "", "", "TemplateProcessingException", "intellij.frameworks.starters"})
public final class AssetsProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateSources(@NotNull GeneratorContext context, @NotNull Map<String, ? extends Object> templateProps) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(templateProps, (String)"templateProps");
        boolean bl = false;
        Map templateProperties = new LinkedHashMap();
        templateProperties.put("context", context);
        templateProperties.putAll(templateProps);
        for (GeneratorAsset asset : context.getAssets()) {
            VirtualFile virtualFile;
            VirtualFile outputDirectory;
            String subPath;
            String string = subPath = StringsKt.contains$default((CharSequence)asset.getTargetFileName(), (CharSequence)"/", (boolean)false, (int)2, null) ? "/" + StringsKt.substringBeforeLast$default((String)asset.getTargetFileName(), (String)"/", null, (int)2, null) : "";
            if (VfsUtil.createDirectoryIfMissing((String)context.getOutputDirectory().getPath()) == null) {
                throw (Throwable)new IllegalStateException("Unable to create directory " + context.getOutputDirectory().getPath());
            }
            Intrinsics.checkNotNullExpressionValue((Object)outputDirectory, (String)"VfsUtil.createDirectoryI\u2026t.outputDirectory.path}\")");
            if (asset instanceof GeneratorEmptyDirectory) {
                VfsUtil.createDirectoryIfMissing((VirtualFile)outputDirectory, (String)asset.getTargetFileName());
                continue;
            }
            CharSequence charSequence = subPath;
            boolean bl2 = false;
            if (charSequence.length() == 0) {
                virtualFile = outputDirectory;
            } else {
                virtualFile = VfsUtil.createDirectoryIfMissing((VirtualFile)outputDirectory, (String)subPath);
                if (virtualFile == null) {
                    throw (Throwable)new IllegalStateException("Unable to create directory " + subPath + " in " + context.getOutputDirectory().getPath());
                }
            }
            VirtualFile fileDirectory = virtualFile;
            String fileName = StringsKt.substringAfterLast$default((String)asset.getTargetFileName(), (String)"/", null, (int)2, null);
            GeneratorAsset generatorAsset = asset;
            if (generatorAsset instanceof GeneratorTemplateFile) {
                VirtualFile file;
                String sourceCode = null;
                try {
                    String string2 = ((GeneratorTemplateFile)asset).getTemplate().getText(templateProperties);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asset.template.getText(templateProperties)");
                    sourceCode = string2;
                }
                catch (Exception e) {
                    throw (Throwable)new TemplateProcessingException(e);
                }
                Intrinsics.checkNotNullExpressionValue((Object)fileDirectory.findOrCreateChildData((Object)this, fileName), (String)"fileDirectory.findOrCrea\u2026ChildData(this, fileName)");
                VfsUtil.saveText((VirtualFile)file, (String)sourceCode);
                continue;
            }
            if (generatorAsset instanceof GeneratorResourceFile) {
                Intrinsics.checkNotNullExpressionValue((Object)fileDirectory.findOrCreateChildData((Object)this, fileName), (String)"fileDirectory.findOrCrea\u2026ChildData(this, fileName)");
                Closeable closeable = ((GeneratorResourceFile)asset).getResource().openStream();
                boolean bl3 = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    VirtualFile file;
                    InputStream it = (InputStream)closeable;
                    boolean bl5 = false;
                    InputStream inputStream = it;
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"it");
                    file.setBinaryContent(ByteStreamsKt.readBytes((InputStream)inputStream));
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    continue;
                }
            }
            throw (Throwable)new UnsupportedOperationException("Unsupported asset type");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/frameworks/starters/local/generator/AssetsProcessor$TemplateProcessingException;", "Ljava/io/IOException;", "t", "", "(Ljava/lang/Throwable;)V", "intellij.frameworks.starters"})
    private static final class TemplateProcessingException
    extends IOException {
        public TemplateProcessingException(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            super("Unable to process template", t);
        }
    }
}

