/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.frameworks.starters.local;

import com.intellij.frameworks.starters.local.Dependency;
import com.intellij.frameworks.starters.local.DependencyConfig;
import com.intellij.frameworks.starters.local.GeneratorAsset;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\u0010\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010\"\u001a\u00020\u0003J\u0010\u0010$\u001a\u0004\u0018\u00010\u00032\u0006\u0010\"\u001a\u00020\u0003J\u0018\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J\u001f\u0010%\u001a\u00020&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030(\"\u00020\u0003\u00a2\u0006\u0002\u0010)J\u001f\u0010*\u001a\u00020&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030(\"\u00020\u0003\u00a2\u0006\u0002\u0010)J\u000e\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020\u0003J\u000e\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020\u0003R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0017R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0017\u00a8\u0006/"}, d2={"Lcom/intellij/frameworks/starters/local/GeneratorContext;", "", "starterId", "", "moduleName", "group", "artifact", "version", "testRunnerId", "languageIds", "", "libraryIds", "dependencyConfig", "Lcom/intellij/frameworks/starters/local/DependencyConfig;", "properties", "", "assets", "", "Lcom/intellij/frameworks/starters/local/GeneratorAsset;", "outputDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;Lcom/intellij/frameworks/starters/local/DependencyConfig;Ljava/util/Map;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getArtifact", "()Ljava/lang/String;", "getAssets", "()Ljava/util/List;", "getGroup", "getModuleName", "getOutputDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getStarterId", "getTestRunnerId", "getVersion", "asPlaceholder", "propertyId", "getBomProperty", "getProperty", "hasAllLibraries", "", "ids", "", "([Ljava/lang/String;)Z", "hasAnyLibrary", "hasLanguage", "languageId", "hasLibrary", "libraryId", "intellij.frameworks.starters"})
public final class GeneratorContext {
    @NotNull
    private final String starterId;
    @NotNull
    private final String moduleName;
    @NotNull
    private final String group;
    @NotNull
    private final String artifact;
    @NotNull
    private final String version;
    @Nullable
    private final String testRunnerId;
    private final Set<String> languageIds;
    private final Set<String> libraryIds;
    private final DependencyConfig dependencyConfig;
    private final Map<String, String> properties;
    @NotNull
    private final List<GeneratorAsset> assets;
    @NotNull
    private final VirtualFile outputDirectory;

    public final boolean hasLanguage(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return this.languageIds.contains(languageId);
    }

    public final boolean hasLibrary(@NotNull String libraryId) {
        Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
        return this.libraryIds.contains(libraryId);
    }

    public final boolean hasAnyLibrary(String ... ids) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            String[] $this$any$iv = ids;
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (!this.libraryIds.contains(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final boolean hasAllLibraries(String ... ids) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
            String[] $this$all$iv = ids;
            boolean $i$f$all = false;
            String[] stringArray = $this$all$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (this.libraryIds.contains(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Nullable
    public final String getVersion(@NotNull String group, @NotNull String artifact) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
            Iterable iterable = this.dependencyConfig.getDependencies();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Dependency it = (Dependency)t;
                boolean bl3 = false;
                if (!(Intrinsics.areEqual((Object)it.getGroup(), (Object)group) && Intrinsics.areEqual((Object)it.getArtifact(), (Object)artifact))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Dependency dependency = v0;
        return dependency != null ? dependency.getVersion() : null;
    }

    @Nullable
    public final String getBomProperty(@NotNull String propertyId) {
        Intrinsics.checkNotNullParameter((Object)propertyId, (String)"propertyId");
        return this.dependencyConfig.getProperties().get(propertyId);
    }

    @Nullable
    public final String getProperty(@NotNull String propertyId) {
        Intrinsics.checkNotNullParameter((Object)propertyId, (String)"propertyId");
        return this.properties.get(propertyId);
    }

    @NotNull
    public final String asPlaceholder(@NotNull String propertyId) {
        Intrinsics.checkNotNullParameter((Object)propertyId, (String)"propertyId");
        return "${" + propertyId + '}';
    }

    @NotNull
    public final String getStarterId() {
        return this.starterId;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final String getGroup() {
        return this.group;
    }

    @NotNull
    public final String getArtifact() {
        return this.artifact;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final String getTestRunnerId() {
        return this.testRunnerId;
    }

    @NotNull
    public final List<GeneratorAsset> getAssets() {
        return this.assets;
    }

    @NotNull
    public final VirtualFile getOutputDirectory() {
        return this.outputDirectory;
    }

    public GeneratorContext(@NotNull String starterId, @NotNull String moduleName, @NotNull String group, @NotNull String artifact, @NotNull String version2, @Nullable String testRunnerId, @NotNull Set<String> languageIds, @NotNull Set<String> libraryIds, @NotNull DependencyConfig dependencyConfig, @NotNull Map<String, String> properties, @NotNull List<? extends GeneratorAsset> assets, @NotNull VirtualFile outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)starterId, (String)"starterId");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter(languageIds, (String)"languageIds");
        Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
        Intrinsics.checkNotNullParameter((Object)dependencyConfig, (String)"dependencyConfig");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(assets, (String)"assets");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        this.starterId = starterId;
        this.moduleName = moduleName;
        this.group = group;
        this.artifact = artifact;
        this.version = version2;
        this.testRunnerId = testRunnerId;
        this.languageIds = languageIds;
        this.libraryIds = libraryIds;
        this.dependencyConfig = dependencyConfig;
        this.properties = properties;
        this.assets = assets;
        this.outputDirectory = outputDirectory;
    }
}

