/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.treeHash.AbstractTreeHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.TreeHashResult;
import com.intellij.dupLocator.treeHash.TreeHashingUtils;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaTreeHasher
extends AbstractTreeHasher {
    private final boolean myCheckValidity;
    private SearchScope mySearchScope;
    private final DuplocatorSettings mySettings;

    public JavaTreeHasher(FragmentsCollector cb, DuplocatorSettings settings, boolean forIndexing) {
        super(cb, forIndexing);
        this.myCheckValidity = forIndexing ? false : settings.CHECK_VALIDITY;
        this.mySearchScope = null;
        this.mySettings = settings;
    }

    protected boolean ignoreChildHash(PsiElement child) {
        return child instanceof PsiExpression && (!this.myCheckValidity || JavaTreeHasher.checkValidity((PsiExpression)child, this.mySearchScope));
    }

    protected TreeHashResult hash(@NotNull PsiElement root, PsiFragment upper, @NotNull NodeSpecificHasher hasher) {
        if (root == null) {
            JavaTreeHasher.$$$reportNull$$$0(0);
        }
        if (hasher == null) {
            JavaTreeHasher.$$$reportNull$$$0(1);
        }
        SearchScope savedScope = null;
        if (this.myCheckValidity) {
            if (this.mySearchScope == null) {
                PsiElement papa = PsiTreeUtil.getParentOfType((PsiElement)root, PsiClass.class);
                if (papa != null) {
                    this.mySearchScope = new LocalSearchScope(papa);
                }
            } else if (root instanceof PsiClass) {
                savedScope = this.mySearchScope;
                this.mySearchScope = new LocalSearchScope(root);
            }
        }
        if (root instanceof PsiCodeBlock) {
            return this.hashCodeBlock((PsiCodeBlock)root, upper, hasher);
        }
        if (this.myCheckValidity && savedScope != null) {
            this.mySearchScope = savedScope;
        }
        return this.computeElementHash(root, upper, hasher);
    }

    protected int getDiscardCost(PsiElement root) {
        return this.mySettings.DISCARD_COST;
    }

    protected int getCost(PsiElement root) {
        return root instanceof PsiExpressionList ? -1 : 0;
    }

    private TreeHashResult hashCodeBlock(PsiCodeBlock block, PsiFragment upper, NodeSpecificHasher hasher) {
        List statements = hasher.getNodeChildren((PsiElement)block);
        int statementsCount = statements.size();
        if (block.getParent() instanceof PsiSwitchStatement && statementsCount < 20) {
            return new TreeHashResult(1, 0, (PsiFragment)this.buildFragment(hasher, statements, 0, statementsCount - 1));
        }
        return super.hashCodeBlock(statements, upper, hasher);
    }

    protected TreeHashResult hashCodeBlock(List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher, boolean forceHash) {
        if (!this.myForIndexing) {
            return super.hashCodeBlock(statements, upper, hasher, forceHash);
        }
        return TreeHashingUtils.hashCodeBlockForIndexing((AbstractTreeHasher)this, (FragmentsCollector)this.myCallBack, statements, (PsiFragment)upper, (NodeSpecificHasher)hasher);
    }

    private static boolean checkValidity(PsiExpression expr, final SearchScope scope) {
        final Ref isValid = new Ref((Object)true);
        expr.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiElement resolved = expression.resolve();
                if (resolved != null) {
                    isValid.set((Object)((Boolean)isValid.get() & !PsiSearchScopeUtil.isInScope((SearchScope)scope, (PsiElement)resolved)));
                }
            }
        });
        return (Boolean)isValid.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "hasher";
                break;
            }
        }
        objectArray[1] = "com/intellij/dupLocator/treeHash/JavaTreeHasher";
        objectArray[2] = "hash";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

