/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.IntStack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaLightDuplicateProfileImplementation
implements LightDuplicateProfile {
    private static final int LIMIT = 4;

    JavaLightDuplicateProfileImplementation() {
    }

    public void process(final @NotNull LighterAST ast, final @NotNull LightDuplicateProfile.Callback callback) {
        if (ast == null) {
            JavaLightDuplicateProfileImplementation.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            JavaLightDuplicateProfileImplementation.$$$reportNull$$$0(1);
        }
        LighterASTNode node = ast.getRoot();
        final IntStack numberOfChildrenIndexedStack = new IntStack();
        final IntStack numberOfNodesIndexedStack = new IntStack();
        final IntStack hashStack = new IntStack();
        final IntStack hash2Stack = new IntStack();
        numberOfChildrenIndexedStack.push(0);
        numberOfNodesIndexedStack.push(0);
        hashStack.push(0);
        hash2Stack.push(0);
        LighterAST wrapperAst = new LighterAST(ast.getCharTable()){

            @NotNull
            public LighterASTNode getRoot() {
                LighterASTNode lighterASTNode = ast.getRoot();
                if (lighterASTNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                return lighterASTNode;
            }

            @Nullable
            public LighterASTNode getParent(@NotNull LighterASTNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                return ast.getParent(node);
            }

            @NotNull
            public List<LighterASTNode> getChildren(@NotNull LighterASTNode parent) {
                if (parent == null) {
                    1.$$$reportNull$$$0(2);
                }
                List children = ast.getChildren(parent);
                ArrayList<LighterASTNode> good = new ArrayList<LighterASTNode>(children.size());
                for (int i = 0; i < children.size(); ++i) {
                    LighterASTNode node = (LighterASTNode)children.get(i);
                    if (!JavaLightDuplicateProfileImplementation.hasIndexableChildren(node)) continue;
                    good.add(node);
                }
                ArrayList<LighterASTNode> arrayList = good;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRoot";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getParent";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getChildren";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        RecursiveLighterASTNodeWalkingVisitor visitor = new RecursiveLighterASTNodeWalkingVisitor(wrapperAst){

            public void visitNode(@NotNull LighterASTNode element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                int hash = JavaLightDuplicateProfileImplementation.nodeHash(element, ast);
                hashStack.push(hash);
                hash2Stack.push(hash);
                int numberOfNodesIndexed = 0;
                int numberOfChildrenIndexed = 0;
                numberOfNodesIndexedStack.push(numberOfNodesIndexed);
                numberOfChildrenIndexedStack.push(numberOfChildrenIndexed);
                if (this.skipVisiting(element, ast)) {
                    return;
                }
                super.visitNode(element);
            }

            private boolean skipVisiting(LighterASTNode element, LighterAST ast2) {
                LighterASTNode methodNameNode;
                if (element.getTokenType() == JavaElementType.METHOD && (methodNameNode = LightTreeUtil.firstChildOfType((LighterAST)ast2, (LighterASTNode)element, (IElementType)JavaTokenType.IDENTIFIER)) != null) {
                    String methodName = LightTreeUtil.toFilteredString((LighterAST)ast2, (LighterASTNode)methodNameNode, null);
                    if (methodName.equals("hashCode") || methodName.equals("toString") || methodName.equals("equals")) {
                        return true;
                    }
                    if (this.isConstructor(element, ast2)) {
                        return true;
                    }
                }
                return false;
            }

            private boolean isConstructor(LighterASTNode method, LighterAST ast2) {
                return LightTreeUtil.firstChildOfType((LighterAST)ast2, (LighterASTNode)method, (IElementType)JavaElementType.TYPE) == null;
            }

            protected void elementFinished(@NotNull LighterASTNode element) {
                if (element == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.elementFinished(element);
                int hash = hashStack.pop();
                int hash2 = hash2Stack.pop();
                int parentHash = hashStack.pop();
                int parentHash2 = hash2Stack.pop();
                int numberOfChildrenIndexed = numberOfChildrenIndexedStack.pop();
                int numberOfNodesIndexed = numberOfNodesIndexedStack.pop();
                int parenNumberOfChildrenIndexed = numberOfChildrenIndexedStack.pop();
                int parentNumberOfNodesIndexed = numberOfNodesIndexedStack.pop();
                IElementType elementType = element.getTokenType();
                boolean includeNodeToHash = JavaLightDuplicateProfileImplementation.toIncludeNodeToHash(element, ast);
                if (elementType == JavaElementType.FOR_STATEMENT) {
                    numberOfNodesIndexed = Math.max(0, numberOfNodesIndexed - 2);
                    numberOfChildrenIndexed = Math.max(0, numberOfChildrenIndexed - 2);
                }
                if (includeNodeToHash && elementType != JavaElementType.CODE_BLOCK) {
                    ++numberOfNodesIndexed;
                }
                if (includeNodeToHash && numberOfNodesIndexed > 4 && (elementType != JavaElementType.CODE_BLOCK || numberOfChildrenIndexed > 4) && hash != 0) {
                    callback.process(hash, hash2 ^= numberOfNodesIndexed - 4 - 1, ast, new LighterASTNode[]{element});
                }
                if (hash != 0) {
                    parentHash = parentHash * 31 + hash;
                    parentHash2 = parentHash2 * 37 + hash2;
                    parentNumberOfNodesIndexed += numberOfNodesIndexed;
                    ++parenNumberOfChildrenIndexed;
                }
                hashStack.push(parentHash);
                hash2Stack.push(parentHash2);
                numberOfChildrenIndexedStack.push(parenNumberOfChildrenIndexed);
                numberOfNodesIndexedStack.push(parentNumberOfNodesIndexed);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        visitor.visitNode(node);
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            JavaLightDuplicateProfileImplementation.$$$reportNull$$$0(2);
        }
        return JavaFileElementType.isInSourceContent((VirtualFile)file);
    }

    private static int nodeHash(LighterASTNode node, LighterAST ast) {
        IElementType type = node.getTokenType();
        if (type == JavaElementType.TYPE) {
            return LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)node, (TokenSet)ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET).hashCode();
        }
        if (type == JavaElementType.NEW_EXPRESSION) {
            LighterASTNode calledMethod = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)node, (IElementType)JavaElementType.JAVA_CODE_REFERENCE);
            if (calledMethod != null) {
                return LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)calledMethod, null).hashCode();
            }
            return 0;
        }
        if (type == JavaElementType.METHOD_CALL_EXPRESSION) {
            LighterASTNode calledMethod = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)node, (TokenSet)ElementType.EXPRESSION_BIT_SET);
            if (calledMethod != null) {
                LighterASTNode identifier;
                LighterASTNode qualifierNode = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)calledMethod, (TokenSet)ElementType.EXPRESSION_BIT_SET);
                if (qualifierNode == null && (identifier = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)calledMethod, (IElementType)JavaTokenType.IDENTIFIER)) != null) {
                    return LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)identifier, null).hashCode();
                }
                return 0;
            }
        } else if (type == JavaElementType.REFERENCE_EXPRESSION) {
            LighterASTNode identifier;
            LighterASTNode qualifierNode = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)node, (TokenSet)ElementType.EXPRESSION_BIT_SET);
            if (qualifierNode != null && (identifier = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)node, (IElementType)JavaTokenType.IDENTIFIER)) != null) {
                return JavaLightDuplicateProfileImplementation.identifierHash(ast, identifier, qualifierNode);
            }
            return 0;
        }
        if (type == JavaElementType.POLYADIC_EXPRESSION || type == JavaElementType.PREFIX_EXPRESSION || type == JavaElementType.POSTFIX_EXPRESSION || type == JavaElementType.ASSIGNMENT_EXPRESSION || type == JavaElementType.BINARY_EXPRESSION) {
            LighterASTNode operationSign = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)node, (TokenSet)ElementType.OPERATION_BIT_SET);
            if (operationSign != null) {
                return operationSign.getTokenType().toString().hashCode();
            }
        } else {
            if (type == JavaElementType.LOCAL_VARIABLE) {
                return 1;
            }
            if (type == JavaElementType.SWITCH_LABEL_STATEMENT) {
                LighterASTNode caseExpression = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)node, (TokenSet)ElementType.EXPRESSION_BIT_SET);
                if (caseExpression != null) {
                    return LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)caseExpression, (TokenSet)ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET).hashCode();
                }
            } else if (type == JavaElementType.LITERAL_EXPRESSION) {
                LighterASTNode childNode = (LighterASTNode)ast.getChildren(node).get(0);
                return LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)childNode, (TokenSet)ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET).hashCode();
            }
        }
        if (ElementType.JAVA_STATEMENT_BIT_SET.contains(type) || ElementType.EXPRESSION_BIT_SET.contains(type)) {
            return 1;
        }
        if (JavaElementType.EXPRESSION_LIST == type) {
            return LightTreeUtil.getChildrenOfType((LighterAST)ast, (LighterASTNode)node, (TokenSet)ElementType.EXPRESSION_BIT_SET).size();
        }
        return 0;
    }

    private static int identifierHash(LighterAST ast, LighterASTNode identifier, LighterASTNode qualifierNode) {
        String qualifierText;
        int identifierHash = LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)identifier, null).hashCode();
        LighterASTNode qualifierOfQualifierNode = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)qualifierNode, (TokenSet)ElementType.EXPRESSION_BIT_SET);
        if (qualifierOfQualifierNode == null && StringUtil.isCapitalized((String)(qualifierText = LightTreeUtil.toFilteredString((LighterAST)ast, (LighterASTNode)qualifierNode, null)))) {
            return identifierHash ^ qualifierText.hashCode();
        }
        return identifierHash;
    }

    private static boolean hasIndexableChildren(LighterASTNode child) {
        IElementType type = child.getTokenType();
        return !ElementType.KEYWORD_BIT_SET.contains(type) && !ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type) && JavaElementType.IMPORT_LIST != type && JavaElementType.MODIFIER_LIST != type && JavaElementType.TYPE_PARAMETER_LIST != type && JavaElementType.REFERENCE_PARAMETER_LIST != type && JavaElementType.EXTENDS_LIST != type && JavaElementType.IMPLEMENTS_LIST != type && JavaElementType.THROWS_LIST != type && JavaTokenType.LBRACE != type && JavaTokenType.RBRACE != type && JavaTokenType.LBRACKET != type && JavaTokenType.IDENTIFIER != type && JavaTokenType.RBRACKET != type && JavaTokenType.RPARENTH != type && JavaTokenType.LPARENTH != type;
    }

    private static boolean toIncludeNodeToHash(LighterASTNode node, LighterAST ast) {
        LighterASTNode defaultKeyword;
        LighterASTNode expression;
        IElementType elementType = node.getTokenType();
        if (elementType == JavaElementType.CODE_BLOCK) {
            return true;
        }
        if (!ElementType.JAVA_STATEMENT_BIT_SET.contains(elementType)) {
            return false;
        }
        if (elementType == JavaElementType.BLOCK_STATEMENT) {
            return false;
        }
        if (elementType == JavaElementType.LABELED_STATEMENT || elementType == JavaElementType.CONTINUE_STATEMENT || elementType == JavaElementType.EMPTY_STATEMENT || elementType == JavaElementType.BREAK_STATEMENT) {
            return false;
        }
        if (elementType == JavaElementType.EXPRESSION_STATEMENT && (expression = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)node, (TokenSet)ElementType.EXPRESSION_BIT_SET)) != null) {
            List expressions;
            IElementType type = expression.getTokenType();
            if (type == JavaElementType.ASSIGNMENT_EXPRESSION && (expressions = LightTreeUtil.getChildrenOfType((LighterAST)ast, (LighterASTNode)expression, (TokenSet)ElementType.EXPRESSION_BIT_SET)).size() == 2 && ((LighterASTNode)expressions.get(1)).getTokenType() == JavaElementType.REFERENCE_EXPRESSION) {
                return false;
            }
            if (type == JavaElementType.METHOD_CALL_EXPRESSION) {
                LighterASTNode methodCall = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)expression, (IElementType)JavaElementType.REFERENCE_EXPRESSION);
                LighterASTNode superOrConstructorCall = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)methodCall, (IElementType)JavaTokenType.THIS_KEYWORD);
                if (superOrConstructorCall == null && methodCall != null) {
                    superOrConstructorCall = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)methodCall, (IElementType)JavaTokenType.SUPER_KEYWORD);
                }
                if (superOrConstructorCall != null) {
                    return false;
                }
            }
        }
        return elementType != JavaElementType.SWITCH_LABEL_STATEMENT || (defaultKeyword = LightTreeUtil.firstChildOfType((LighterAST)ast, (LighterASTNode)node, (IElementType)JavaTokenType.DEFAULT_KEYWORD)) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ast";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/JavaLightDuplicateProfileImplementation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptsFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

