/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.models;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.DirectTreeTableRenderer;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.RightAlignedRenderer;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.SizeRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AggregatesTableModel
implements TreeTableModelWithCustomRenderer {
    private final Object myRoot;
    private final ColumnInfo[] myColumns;
    @NotNull
    private final Project myProject;
    @NotNull
    private final V8CachingReader myReader;
    private DirectTreeTableRenderer myRenderer;
    private final List<Long> myKeys;

    public AggregatesTableModel(@NotNull Project project, @NotNull V8CachingReader reader) {
        if (project == null) {
            AggregatesTableModel.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            AggregatesTableModel.$$$reportNull$$$0(1);
        }
        this.myRoot = new Object();
        this.myProject = project;
        this.myReader = reader;
        this.myColumns = new ColumnInfo[5];
        this.fillColumns();
        TreeMap<Long, Aggregate> map = this.myReader.getAggregatesMap();
        this.myKeys = new ArrayList(map.keySet());
    }

    private void fillColumns() {
        this.myRenderer = new DirectTreeTableRenderer(this.myProject, this.myReader);
        this.myColumns[0] = new ColumnInfo<Object, Object>(NodeJSBundle.message("profile.table.column.constructor.name", new Object[0])){

            @Nullable
            public Object valueOf(Object o) {
                return o;
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                if (renderer instanceof TreeTableCellRenderer) {
                    ((TreeTableCellRenderer)renderer).setCellRenderer((TreeCellRenderer)((Object)AggregatesTableModel.this.myRenderer));
                }
                return super.getCustomizedRenderer(o, renderer);
            }
        };
        final RightAlignedRenderer alignedRenderer = new RightAlignedRenderer();
        this.myColumns[1] = new ColumnInfo<Object, Object>(NodeJSBundle.message("profile.table.column.distance.name", new Object[0])){

            @NotNull
            public Object valueOf(Object o) {
                if (o instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                    V8HeapContainmentTreeTableModel.NamedEntry entry = (V8HeapContainmentTreeTableModel.NamedEntry)o;
                    int distance = AggregatesTableModel.this.myReader.getDistance((int)entry.getEntry().getId());
                    String string = AggregatesTableModel.renderDistance(distance);
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                if (o instanceof Aggregate) {
                    int distance = ((Aggregate)o).getDistance();
                    String string = AggregatesTableModel.renderDistance(distance);
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return alignedRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/models/AggregatesTableModel$2", "valueOf"));
            }
        };
        this.myColumns[2] = new ColumnInfo<Object, Object>(NodeJSBundle.message("profile.table.column.objects_count.name", new Object[0])){

            @NotNull
            public Object valueOf(Object o) {
                if (o instanceof Aggregate) {
                    String string = String.valueOf(((Aggregate)o).getCnt());
                    if (string == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return alignedRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/models/AggregatesTableModel$3", "valueOf"));
            }
        };
        final SizeRenderer sizeRenderer = new SizeRenderer(this.myReader.getRetainedSize(0));
        this.myColumns[3] = new ColumnInfo<Object, Object>(NodeJSBundle.message("profile.table.column.shallow_size.name", new Object[0])){

            @NotNull
            public Object valueOf(Object o) {
                if (o instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                    V8HeapContainmentTreeTableModel.NamedEntry entry = (V8HeapContainmentTreeTableModel.NamedEntry)o;
                    Long l = entry.getEntry().getSize();
                    if (l == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return l;
                }
                if (o instanceof Aggregate) {
                    Long l = ((Aggregate)o).getSelfSize();
                    if (l == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return l;
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return sizeRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/models/AggregatesTableModel$4", "valueOf"));
            }
        };
        this.myColumns[4] = new ColumnInfo<Object, Object>(NodeJSBundle.message("profile.table.column.retained.size.name", new Object[0])){

            @NotNull
            public Object valueOf(Object o) {
                if (o instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                    V8HeapContainmentTreeTableModel.NamedEntry entry = (V8HeapContainmentTreeTableModel.NamedEntry)o;
                    Long l = AggregatesTableModel.this.myReader.getRetainedSize((int)entry.getEntry().getId());
                    if (l == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return l;
                }
                if (o instanceof Aggregate) {
                    Long l = ((Aggregate)o).getRetained();
                    if (l == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    return l;
                }
                return "";
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                return sizeRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/heap/view/models/AggregatesTableModel$5", "valueOf"));
            }
        };
    }

    @NotNull
    private static String renderDistance(int distance) {
        String string = distance >= 100000000 || distance < 0 ? "-" : String.valueOf(distance);
        if (string == null) {
            AggregatesTableModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(int column, Object o, TableCellRenderer renderer) {
        return this.myColumns[column].getCustomizedRenderer(o, renderer);
    }

    public int getColumnCount() {
        return this.myColumns.length;
    }

    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(node);
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public void setTree(JTree tree) {
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public Object getChild(Object parent, int index) {
        if (parent == this.myRoot) {
            return this.myReader.getAggregatesMap().get(this.myKeys.get(index));
        }
        if (parent instanceof Aggregate) {
            int id = ((Aggregate)parent).getId();
            List<Long> children = this.myReader.getAggregatesChildren(id);
            V8HeapContainmentTreeTableModel.NamedEntry top = V8HeapContainmentTreeTableModel.NamedEntry.create(children.get(index), this.myReader);
            top.setDoNotShowLink(true);
            return top;
        }
        if (parent instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
            Pair<V8HeapEntry, V8HeapEdge> pair = this.myReader.getChild(((V8HeapContainmentTreeTableModel.NamedEntry)parent).getEntry(), index);
            V8HeapEdge edge = (V8HeapEdge)pair.getSecond();
            return new V8HeapContainmentTreeTableModel.NamedEntry((V8HeapEntry)pair.getFirst(), this.myReader.getString(((V8HeapEntry)pair.getFirst()).getNameId()), edge.getPresentation(this.myReader), edge.getFileOffset());
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent == this.myRoot) {
            return this.myKeys.size();
        }
        if (parent instanceof Aggregate) {
            return ((Aggregate)parent).getCnt();
        }
        if (parent instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
            return this.myReader.getChildren(((V8HeapContainmentTreeTableModel.NamedEntry)parent).getEntry()).size();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.myRoot) {
            if (child instanceof Aggregate) {
                TreeMap<Long, Aggregate> aggregatesMap = this.myReader.getAggregatesMap();
                for (int i = 0; i < this.myKeys.size(); ++i) {
                    Long key = this.myKeys.get(i);
                    Aggregate aggregate = (Aggregate)aggregatesMap.get(key);
                    if (aggregate.getId() != ((Aggregate)child).getId()) continue;
                    return i;
                }
            }
        } else if (parent instanceof Aggregate && child instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
            int id = ((Aggregate)parent).getId();
            List<Long> children = this.myReader.getAggregatesChildren(id);
            long childId = ((V8HeapContainmentTreeTableModel.NamedEntry)child).getEntry().getId();
            for (int i = 0; i < children.size(); ++i) {
                Long idx = children.get(i);
                if (idx != childId) continue;
                return i;
            }
        } else if (parent instanceof V8HeapContainmentTreeTableModel.NamedEntry && child instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
            return this.myReader.getChildIndex(((V8HeapContainmentTreeTableModel.NamedEntry)parent).getEntry(), ((V8HeapContainmentTreeTableModel.NamedEntry)child).getLinkOffset());
        }
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/view/models/AggregatesTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/models/AggregatesTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDistance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

