/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingMainComponent;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.components.HeapViewCreatorPartner;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import icons.NodeJSIcons;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class V8HeapComponent {
    public static final Supplier<@Nls String> TOOL_WINDOW_TITLE = NodeJSBundle.messagePointer("profile.heap.tool_window.title", new Object[0]);
    private final Object myLock;
    private final Map<ByteArrayWrapper, Pair<Content, HeapViewCreatorPartner<V8HeapTreeTable>>> myOpenedTabs;
    private final Map<ByteArrayWrapper, Map<Long, @NlsSafe String>> myMarks;
    @NotNull
    private final Project myProject;

    public V8HeapComponent(@NotNull Project project) {
        if (project == null) {
            V8HeapComponent.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myLock = new Object();
        this.myOpenedTabs = new HashMap<ByteArrayWrapper, Pair<Content, HeapViewCreatorPartner<V8HeapTreeTable>>>();
        this.myMarks = new HashMap<ByteArrayWrapper, Map<Long, String>>();
    }

    public static V8HeapComponent getInstance(Project project) {
        return (V8HeapComponent)ServiceManager.getService((Project)project, V8HeapComponent.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nls
    public String getMark(ByteArrayWrapper digest, V8HeapEntry value) {
        Object object = this.myLock;
        synchronized (object) {
            Map<Long, @NlsSafe String> map = this.myMarks.get(digest);
            return map == null ? null : map.get(value.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markOrUnmark(ByteArrayWrapper digest, @NotNull V8HeapEntry entry, @NotNull String value) {
        if (entry == null) {
            V8HeapComponent.$$$reportNull$$$0(1);
        }
        if (value == null) {
            V8HeapComponent.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            Map<Long, String> map = this.myMarks.get(digest);
            if (map == null) {
                map = new HashMap<Long, String>();
                this.myMarks.put(digest, map);
            } else if (map.remove(entry.getId()) != null) {
                return;
            }
            map.put(entry.getId(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, String> searchByMark(ByteArrayWrapper digest, @NotNull String substring, boolean caseSensitive) {
        if (substring == null) {
            V8HeapComponent.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            Map<Long, String> marksMap = this.myMarks.get(digest);
            if (marksMap == null) {
                return Collections.emptyMap();
            }
            String lower = StringUtil.toLowerCase((String)substring);
            HashMap<Long, String> map = new HashMap<Long, String>();
            for (Map.Entry<Long, String> entry : marksMap.entrySet()) {
                boolean contains = caseSensitive ? entry.getValue().contains(substring) : StringUtil.toLowerCase((String)entry.getValue()).contains(lower);
                if (!contains) continue;
                map.put(entry.getKey(), entry.getValue());
            }
            return map.isEmpty() ? Collections.emptyMap() : map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMe(final ByteArrayWrapper digest, final HeapViewCreatorPartner<V8HeapTreeTable> partner, @NotNull @Nls String name, Icon contentIcon) throws IOException {
        if (name == null) {
            V8HeapComponent.$$$reportNull$$$0(4);
        }
        if (this.activateIfOpen(digest)) {
            return;
        }
        Disposable disposable = new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = V8HeapComponent.this.myLock;
                synchronized (object) {
                    V8HeapComponent.this.myOpenedTabs.remove(digest);
                    boolean[] used = new boolean[1];
                    Consumer consumer = wrapper -> {
                        used[0] = used[0] | digest.equals(wrapper);
                    };
                    for (Pair<Content, HeapViewCreatorPartner<V8HeapTreeTable>> pair : V8HeapComponent.this.myOpenedTabs.values()) {
                        ((HeapViewCreatorPartner)pair.getSecond()).reportInvolvedSnapshots((Consumer<ByteArrayWrapper>)consumer);
                    }
                    if (!used[0]) {
                        V8HeapComponent.this.myMarks.remove(digest);
                    }
                }
                partner.close();
            }
        };
        Object object = this.myLock;
        synchronized (object) {
            Content content = V8ProfilingMainComponent.showMe(this.myProject, name, TOOL_WINDOW_TITLE.get(), NodeJSIcons.OpenV8HeapSnapshot_ToolWin, 2, partner, disposable, null, contentIcon);
            this.myOpenedTabs.put(digest, (Pair<Content, HeapViewCreatorPartner<V8HeapTreeTable>>)Pair.create((Object)content, partner));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activateIfOpen(ByteArrayWrapper digest) {
        Object object = this.myLock;
        synchronized (object) {
            Pair<Content, HeapViewCreatorPartner<V8HeapTreeTable>> pair = this.myOpenedTabs.get(digest);
            if (pair != null) {
                Content content = (Content)pair.getFirst();
                ToolWindow toolWindow = V8ProfilingMainComponent.getToolWindow(this.myProject, TOOL_WINDOW_TITLE.get(), NodeJSIcons.OpenV8HeapSnapshot_ToolWin);
                if (toolWindow.getContentManager().getIndexOfContent(content) >= 0) {
                    toolWindow.activate(() -> toolWindow.getContentManager().setSelectedContent(content, true));
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V8MainTreeNavigator getNavigator(ByteArrayWrapper digest) {
        Object object = this.myLock;
        synchronized (object) {
            Pair<Content, HeapViewCreatorPartner<V8HeapTreeTable>> pair = this.myOpenedTabs.get(digest);
            return pair == null ? null : ((HeapViewCreatorPartner)pair.getSecond()).getNavigator();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substring";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/V8HeapComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "markOrUnmark";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "searchByMark";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showMe";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

