/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.LinkedByNameId;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReader;
import com.jetbrains.nodejs.util.CloseableProcessor;
import com.jetbrains.nodejs.util.CloseableThrowableProcessor;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8DistancesInspection
extends Task.Backgroundable {
    private static final String[] FILTER_NAMES = new String[]{"__proto__", "prototype", "constructor", "v8", "source", "exports", "super_", "type"};
    @NotNull
    private final V8CachingReader myReader;
    private static final int MIN_DISTANCE_VARIANCE = 5;
    private static final int MAX_DISTANCE_VARIANCE = 50;
    private static final int MAX_NAMES = 50;
    private final Map<Long, TypeData> myByTypesData;
    private TreeMap<Long, TypeData> mySortedByTypes;
    private IOException myException;
    private final HashMap<Long, Set<Long>> myByNamesMap;
    private ArrayList<List<Long>> mySortedByNames;

    public V8DistancesInspection(@Nullable Project project, @NotNull V8CachingReader reader) {
        if (reader == null) {
            V8DistancesInspection.$$$reportNull$$$0(0);
        }
        super(project, NodeJSBundle.message("progress.title.checking.snapshot.distances", new Object[0]), false);
        this.myReader = reader;
        this.myByTypesData = new HashMap<Long, TypeData>();
        this.myByNamesMap = new HashMap();
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            V8DistancesInspection.$$$reportNull$$$0(1);
        }
        try {
            this.doByTypes(indicator);
            this.doByNames(indicator);
        }
        catch (IOException e) {
            this.myException = e;
        }
    }

    private void doByNames(ProgressIndicator indicator) throws IOException {
        indicator.setText(NodeJSBundle.message("progress.text.looking.for.filtered.names.ids", new Object[0]));
        Set<Long> filterIds = this.fillFilteredStrings();
        indicator.setText(NodeJSBundle.message("progress.text.iterating.reverse.string.index", new Object[0]));
        this.myReader.getStringReverseIndexReaderFactory().create(true).iterate((Processor<List<LinkedByNameId>>)((Processor)ids -> {
            if (ids.size() >= 5) {
                V8HeapEdge edge;
                HashSet<Long> links = new HashSet<Long>();
                for (LinkedByNameId id : ids) {
                    if (id.isNode()) continue;
                    links.add(id.getId());
                }
                if (links.size() >= 5 && !filterIds.contains((edge = this.myReader.getEdge((Long)links.iterator().next())).getNameId())) {
                    this.myByNamesMap.put(edge.getNameId(), links);
                }
            }
            return true;
        }));
        indicator.setText(NodeJSBundle.message("progress.text.filtering.by.name.groups.removing.hidden.small", new Object[0]));
        Iterator<Map.Entry<Long, Set<Long>>> iterator = this.myByNamesMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Set<Long>> entry = iterator.next();
            HashSet<Integer> set = new HashSet<Integer>();
            Iterator<Long> edgeIterator = entry.getValue().iterator();
            boolean skipFinishChecks = false;
            while (edgeIterator.hasNext()) {
                Long edgeId = edgeIterator.next();
                V8HeapEdge edge = this.myReader.getEdge(edgeId);
                if (V8HeapGraphEdgeType.kElement.equals((Object)edge.getType())) {
                    iterator.remove();
                    skipFinishChecks = true;
                    break;
                }
                if (V8HeapGraphEdgeType.isInternalKind(edge.getType()) || V8DistancesInspection.nodeIsHidden(this.myReader.getNode(edge.getToIndex()))) {
                    edgeIterator.remove();
                    continue;
                }
                set.add(this.myReader.getDistance((int)edge.getToIndex()));
            }
            if (skipFinishChecks || !entry.getValue().isEmpty() && set.size() >= 5) continue;
            iterator.remove();
        }
        this.mySortedByNames = new ArrayList();
        for (Map.Entry<Long, Set<Long>> entry : this.myByNamesMap.entrySet()) {
            this.mySortedByNames.add(new ArrayList(entry.getValue()));
        }
        this.mySortedByNames.sort((o1, o2) -> Integer.compare(o2.size(), o1.size()));
        this.myByNamesMap.clear();
    }

    @NotNull
    private Set<Long> fillFilteredStrings() throws IOException {
        final Set filterStrings = ContainerUtil.set((Object[])FILTER_NAMES);
        final HashSet<Long> filterIds = new HashSet<Long>();
        this.myReader.getStringIndex().iterate(new CloseableProcessor<Pair<Long, String>, IOException>(){

            @Override
            public void exceptionThrown(@NotNull IOException e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                V8DistancesInspection.this.myException = e;
            }

            @Override
            public void close() throws IOException {
            }

            public boolean process(Pair<Long, String> pair) {
                if (filterStrings.remove(pair.getSecond())) {
                    filterIds.add((Long)pair.getFirst());
                }
                return !filterStrings.isEmpty();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/run/profile/heap/view/components/V8DistancesInspection$1", "exceptionThrown"));
            }
        });
        HashSet<Long> hashSet = filterIds;
        if (hashSet == null) {
            V8DistancesInspection.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static boolean nodeIsHidden(V8HeapEntry entry) {
        return V8HeapNodeType.kHidden.equals((Object)entry.getType()) || V8HeapNodeType.kSynthetic.equals((Object)entry.getType());
    }

    public ArrayList<List<Long>> getByNamesList() {
        return this.mySortedByNames;
    }

    private void doByTypes(ProgressIndicator indicator) throws IOException {
        indicator.setText(NodeJSBundle.message("progress.text.marking.nodes.referenced.by.hidden.links.only", new Object[0]));
        final TIntHashSet onlyHiddenLinks = new TIntHashSet();
        LinksReader<V8HeapEdge> linksReader = this.myReader.getReverseLinkIndexReaderFactory().create(true);
        linksReader.iterate(new Processor<List<V8HeapEdge>>(){
            int idx = 0;

            public boolean process(List<V8HeapEdge> edges) {
                boolean notHidden = false;
                for (V8HeapEdge edge : edges) {
                    if (V8HeapGraphEdgeType.isInternalKind(edge.getType())) continue;
                    notHidden = true;
                    break;
                }
                if (!notHidden) {
                    onlyHiddenLinks.add(this.idx);
                }
                ++this.idx;
                return true;
            }
        });
        indicator.setText(NodeJSBundle.message("progress.text.grouping.nodes.by.classes", new Object[0]));
        SequentialRawReader<V8HeapEntry> reader = new SequentialRawReader<V8HeapEntry>(this.myReader.getNodeIndexFile(), V8HeapEntry.MyRawSerializer.getInstance(), this.myReader.getNodeCount());
        reader.iterate(new CloseableThrowableProcessor<V8HeapEntry, IOException>(){

            @Override
            public boolean process(V8HeapEntry entry) throws IOException {
                if (onlyHiddenLinks.contains((int)entry.getId()) || V8HeapNodeType.kHidden.equals((Object)entry.getType()) || V8HeapNodeType.kSynthetic.equals((Object)entry.getType()) || V8HeapNodeType.kCode.equals((Object)entry.getType())) {
                    return true;
                }
                long classIndex = entry.getClassIndex();
                TypeData typeData = V8DistancesInspection.this.myByTypesData.get(classIndex);
                if (typeData == null) {
                    typeData = new TypeData();
                    V8DistancesInspection.this.myByTypesData.put(classIndex, typeData);
                }
                typeData.entry(entry);
                return true;
            }

            @Override
            public void close() throws IOException {
            }
        });
        indicator.setText(NodeJSBundle.message("progress.text.filtering.by.class.groups", new Object[0]));
        Iterator<TypeData> iterator = this.myByTypesData.values().iterator();
        while (iterator.hasNext()) {
            TypeData typeData = iterator.next();
            if (typeData.getMap().size() >= 5) continue;
            iterator.remove();
        }
        this.mySortedByTypes = new TreeMap((key1, key2) -> {
            if (this.myByTypesData.isEmpty()) {
                return Long.compare(this.mySortedByTypes.get(key2).getMaxRetainedSize(), this.mySortedByTypes.get(key1).getMaxRetainedSize());
            }
            return Long.compare(this.myByTypesData.get(key2).getMaxRetainedSize(), this.myByTypesData.get(key1).getMaxRetainedSize());
        });
        this.mySortedByTypes.putAll(this.myByTypesData);
        this.myByTypesData.clear();
    }

    public TreeMap<Long, TypeData> getSortedByTypes() {
        return this.mySortedByTypes;
    }

    public IOException getException() {
        return this.myException;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/heap/view/components/V8DistancesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/V8DistancesInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fillFilteredStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class TypeData {
        private long myMaxRetainedSize = 0L;
        private final TreeMap<Integer, Pair<V8HeapEntry, V8HeapEdge>> myMap = new TreeMap();
        private boolean mySomethingMissing;

        TypeData() {
        }

        private void putEntry(@NotNull V8HeapEntry entry, int distance) {
            if (entry == null) {
                TypeData.$$$reportNull$$$0(0);
            }
            long parentId = V8DistancesInspection.this.myReader.getNodeParent((int)entry.getId());
            V8HeapEntry parent = V8DistancesInspection.this.myReader.getNode(parentId);
            Pair<V8HeapEntry, V8HeapEdge> p = V8DistancesInspection.this.myReader.getChildById(parent, entry.getId());
            if (parent.getSnapshotObjectId() == -1L || ((V8HeapEntry)p.getFirst()).getSnapshotObjectId() == -1L) {
                this.myMap.put(distance, (Pair<V8HeapEntry, V8HeapEdge>)Pair.create((Object)entry, null));
            } else {
                this.myMap.put(distance, p);
            }
        }

        private long add(@NotNull V8HeapEntry entry, int distance) {
            if (entry == null) {
                TypeData.$$$reportNull$$$0(1);
            }
            long retainedSize = V8DistancesInspection.this.myReader.getRetainedSize((int)entry.getId());
            Pair<V8HeapEntry, V8HeapEdge> before = this.myMap.get(distance);
            if (before != null) {
                if (V8DistancesInspection.this.myReader.getRetainedSize((int)((V8HeapEntry)before.getFirst()).getId()) < retainedSize) {
                    this.putEntry(entry, distance);
                }
            } else {
                this.putEntry(entry, distance);
            }
            this.myMaxRetainedSize = Math.max(this.myMaxRetainedSize, retainedSize);
            return retainedSize;
        }

        public void entry(@NotNull V8HeapEntry entry) {
            int distance;
            if (entry == null) {
                TypeData.$$$reportNull$$$0(2);
            }
            if ((distance = V8DistancesInspection.this.myReader.getDistance((int)entry.getId())) < 0 || distance >= 100000000) {
                return;
            }
            this.add(entry, distance);
            if (this.myMap.size() > 50) {
                Integer key = null;
                long size = Long.MAX_VALUE;
                for (Map.Entry<Integer, Pair<V8HeapEntry, V8HeapEdge>> entryEntry : this.myMap.entrySet()) {
                    long currentSize = V8DistancesInspection.this.myReader.getRetainedSize((int)((V8HeapEntry)entryEntry.getValue().getFirst()).getId());
                    if (currentSize > size) continue;
                    key = entryEntry.getKey();
                    size = currentSize;
                }
                if (key != null) {
                    this.myMap.remove(key);
                    this.mySomethingMissing = true;
                }
            }
        }

        public boolean isSomethingMissing() {
            return this.mySomethingMissing;
        }

        public long getMaxRetainedSize() {
            return this.myMaxRetainedSize;
        }

        public TreeMap<Integer, Pair<V8HeapEntry, V8HeapEdge>> getMap() {
            return this.myMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "entry";
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/V8DistancesInspection$TypeData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "entry";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

