/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.view.components.Coordinator;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import com.jetbrains.nodejs.run.profile.heap.view.components.FindResultsWithOneTree;
import com.jetbrains.nodejs.run.profile.heap.view.components.SearchResultsTreeModelFactory;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapComponent;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTableWithRetainers;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import com.jetbrains.nodejs.util.CloseableProcessor;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SearchDialog {
    private static final int SIZE_LIMIT = 1000;
    private static final Logger LOG = Logger.getInstance(SearchDialog.class);
    private static final String ourBasePropName = "Node.js.profiling.heap.search.option.";
    private final Names myNames = new Names();
    @Nls
    private final String LINK_NAMES;
    @Nls
    private final String CLASS_NAMES;
    @Nls
    private final String TEXT_STRINGS;
    @Nls
    private final String SNAPSHOT_OBJECT_IDS;
    @Nls
    private final String MARKS;
    private final Project myProject;
    private final V8CachingReader myReader;
    private final V8MainTableWithRetainers<V8HeapContainmentTreeTableModel> myTableWithRetainers;
    private final Map<String, JBCheckBox> myOptions;
    private JBCheckBox mySearchEverywhere;
    private SearchTextFieldWithStoredHistory myText;
    private JBCheckBox myCaseSensitive;

    public SearchDialog(Project project, V8CachingReader reader, V8MainTableWithRetainers<V8HeapContainmentTreeTableModel> tableWithRetainers) {
        this.LINK_NAMES = this.myNames.LINK_NAMES;
        this.CLASS_NAMES = this.myNames.CLASS_NAMES;
        this.TEXT_STRINGS = this.myNames.TEXT_STRINGS;
        this.SNAPSHOT_OBJECT_IDS = this.myNames.SNAPSHOT_OBJECT_IDS;
        this.MARKS = this.myNames.MARKS;
        this.myProject = project;
        this.myReader = reader;
        this.myTableWithRetainers = tableWithRetainers;
        this.myOptions = new HashMap<String, JBCheckBox>();
        for (String option : SearchDialog.getOptions()) {
            JBCheckBox checkBox = new JBCheckBox(option);
            checkBox.setSelected(true);
            DialogUtil.registerMnemonic((AbstractButton)checkBox, (char)'&');
            this.myOptions.put(option, checkBox);
        }
    }

    public void search() {
        if (this.showDialog()) {
            String text = this.myText.getText().trim();
            if (text.isEmpty()) {
                return;
            }
            this.myText.addCurrentTextToHistory();
            this.storeOptions();
            ProgressManager.getInstance().run((Task)new Searcher(this.myProject, text, this.myReader, this.myOptions, this.myCaseSensitive.isSelected(), this.mySearchEverywhere.isSelected(), this.myTableWithRetainers));
        }
    }

    private void storeOptions() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        for (Map.Entry<String, JBCheckBox> entry : this.myOptions.entrySet()) {
            propertiesComponent.setValue(ourBasePropName + entry.getKey(), Boolean.toString(entry.getValue().isSelected()), "true");
        }
        propertiesComponent.setValue("Node.js.profiling.heap.search.option.everywhere", Boolean.toString(this.mySearchEverywhere.isSelected()), "false");
        propertiesComponent.setValue("Node.js.profiling.heap.search.option.caseSensitive", Boolean.toString(this.myCaseSensitive.isSelected()), "false");
    }

    private void readStoredOptions() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        for (Map.Entry<String, JBCheckBox> entry : this.myOptions.entrySet()) {
            boolean value = propertiesComponent.getBoolean(ourBasePropName + entry.getKey(), true);
            entry.getValue().setSelected(value);
        }
        this.mySearchEverywhere.setSelected(propertiesComponent.getBoolean("Node.js.profiling.heap.search.option.everywhere"));
        this.myCaseSensitive.setSelected(propertiesComponent.getBoolean("Node.js.profiling.heap.search.option.caseSensitive"));
    }

    private boolean showDialog() {
        this.myText = new SearchTextFieldWithStoredHistory("Node.js.profiling.heap.searh.history"){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                return new Dimension(150, size.height);
            }
        };
        this.mySearchEverywhere = new JBCheckBox(NodeJSBundle.message("checkbox.everywhere", new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.mySearchEverywhere, (char)'&');
        this.myCaseSensitive = new JBCheckBox(NodeJSBundle.message("checkbox.case.sensitive", new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.myCaseSensitive, (char)'&');
        FormBuilder formBuilder = new FormBuilder().addLabeledComponent(NodeJSBundle.message("label.search", new Object[0]), (JComponent)this.myText);
        formBuilder.addComponent((JComponent)this.myCaseSensitive);
        formBuilder.addVerticalGap(5);
        formBuilder.addComponent((JComponent)new JBLabel(NodeJSBundle.message("label.scope", new Object[0])));
        formBuilder.addComponent((JComponent)this.mySearchEverywhere);
        formBuilder.addVerticalGap(5);
        for (String option : SearchDialog.getOptions()) {
            formBuilder.addComponent((JComponent)this.myOptions.get(option));
        }
        ActionListener everyWhereListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (JBCheckBox checkBox : SearchDialog.this.myOptions.values()) {
                    checkBox.setEnabled(!SearchDialog.this.mySearchEverywhere.isSelected());
                    if (!SearchDialog.this.mySearchEverywhere.isSelected()) continue;
                    checkBox.setSelected(true);
                }
            }
        };
        this.mySearchEverywhere.addActionListener(everyWhereListener);
        this.readStoredOptions();
        everyWhereListener.actionPerformed(null);
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.setTitle(NodeJSBundle.message("dialog.title.search.in.v8.heap", new Object[0]));
        builder.setCenterPanel((JComponent)formBuilder.getPanel());
        builder.setPreferredFocusComponent((JComponent)this.myText);
        builder.setDimensionServiceKey("com.jetbrains.nodejs.run.profile.heap.view.components.SearchDialog");
        builder.setHelpId("reference.v8.heap.search");
        return builder.showAndGet();
    }

    @Nls
    public static String[] getOptions() {
        return new Names().OPTIONS;
    }

    private class Searcher
    extends Task.Backgroundable {
        private final Coordinator myCoordinator;
        private final String myText;
        private final boolean myCaseSensitive;
        private final boolean mySearchEverywhereSelected;
        private final V8MainTableWithRetainers<V8HeapContainmentTreeTableModel> myTableWithRetainers;
        private final V8CachingReader myReader;
        private final Map<String, JBCheckBox> myOptions;
        private final Map<String, Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>>> myResultsByType;
        private boolean myTooMany;
        private final String myTextLowered;

        Searcher(Project project, String text, V8CachingReader reader, Map<String, JBCheckBox> options, boolean caseSensitive, boolean searchEverywhereSelected, V8MainTableWithRetainers<V8HeapContainmentTreeTableModel> tableWithRetainers) {
            super(project, NodeJSBundle.message("progress.title.searching.in.heap.snapshot", text), true);
            this.myText = text;
            this.myCaseSensitive = caseSensitive;
            this.mySearchEverywhereSelected = searchEverywhereSelected;
            this.myTableWithRetainers = tableWithRetainers;
            this.myTextLowered = StringUtil.toLowerCase((String)this.myText);
            this.myReader = reader;
            this.myOptions = options;
            this.myCoordinator = new Coordinator(() -> this.show());
            this.myResultsByType = Collections.synchronizedMap(new HashMap());
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                Searcher.$$$reportNull$$$0(0);
            }
            Coordinator.Listener start = this.myCoordinator.start();
            this.trySearchByObjectId(indicator, this.myCoordinator.start());
            this.trySearchByTextMark(indicator, this.myCoordinator.start());
            this.trySearchByString(indicator, this.myCoordinator.start());
            start.finished();
        }

        private void show() {
            if (!this.myReader.isShowHidden()) {
                Set<Map.Entry<String, Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>>>> byTypeEntries = this.myResultsByType.entrySet();
                Iterator<Map.Entry<String, Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>>>> byTypeIterator = byTypeEntries.iterator();
                while (byTypeIterator.hasNext()) {
                    Map.Entry<String, Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>>> entry = byTypeIterator.next();
                    Set<Map.Entry<String, List<Pair<V8HeapEdge, V8HeapEntry>>>> entries = entry.getValue().entrySet();
                    Iterator<Map.Entry<String, List<Pair<V8HeapEdge, V8HeapEntry>>>> byStringIterator = entries.iterator();
                    while (byStringIterator.hasNext()) {
                        Map.Entry<String, List<Pair<V8HeapEdge, V8HeapEntry>>> listEntry = byStringIterator.next();
                        List<Pair<V8HeapEdge, V8HeapEntry>> value = listEntry.getValue();
                        Iterator<Pair<V8HeapEdge, V8HeapEntry>> iterator = value.iterator();
                        while (iterator.hasNext()) {
                            Pair<V8HeapEdge, V8HeapEntry> pair = iterator.next();
                            if (!V8HeapNodeType.kHidden.equals((Object)((V8HeapEntry)pair.getSecond()).getType()) && (pair.getFirst() == null || !V8HeapGraphEdgeType.kHidden.equals((Object)((V8HeapEdge)pair.getFirst()).getType()))) continue;
                            iterator.remove();
                        }
                        if (!value.isEmpty()) continue;
                        byStringIterator.remove();
                    }
                    if (!entries.isEmpty()) continue;
                    byTypeIterator.remove();
                }
            }
            if (this.myResultsByType.isEmpty()) {
                Notification notification = NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.heap.search.nothing_found_by_text.notification.content", this.myText), MessageType.INFO);
                notification.notify(this.myProject);
                return;
            }
            SearchResultsTreeModelFactory.ChainTreeModelWithTopLevelFilter<String> simple = new SearchResultsTreeModelFactory(this.myProject, this.myText, this.myReader, this.myResultsByType, this.mySearchEverywhereSelected).createSimple();
            SearchResultsTreeModelFactory.ChainTreeModelWithTopLevelFilter<String> byTypes = new SearchResultsTreeModelFactory(this.myProject, this.myText, this.myReader, this.myResultsByType, this.mySearchEverywhereSelected).createByTypes();
            ApplicationManager.getApplication().invokeLater(() -> {
                FindResultsWithOneTree results = new FindResultsWithOneTree(this.myProject, this.myReader, this.myText, simple.getNumResults(), this.myTableWithRetainers.getMainTreeNavigator());
                if (this.myTooMany) {
                    results.moreResultsThan(1000);
                }
                DataProviderPanel panel = results.showMe(simple, byTypes);
                DefaultActionGroup group = new DefaultActionGroup();
                results.addActions(group);
                this.myTableWithRetainers.addTab(NodeJSBundle.message("profile.search.occurences_tab.title", this.myText), (JComponent)((Object)panel), group, true);
                results.defaultExpand();
            });
        }

        private void trySearchByString(final ProgressIndicator indicator, final Coordinator.Listener listener) {
            if (!(this.myOptions.get(SearchDialog.this.LINK_NAMES).isSelected() || this.myOptions.get(SearchDialog.this.CLASS_NAMES).isSelected() || this.myOptions.get(SearchDialog.this.TEXT_STRINGS).isSelected())) {
                listener.finished();
                return;
            }
            this.myReader.getStringIndex().parallelIterate(new CloseableProcessor<Pair<Long, String>, IOException>(){
                private final Map<Long, Pair<Long, String>> myByStringIdMap = Collections.synchronizedMap(new HashMap());

                @Override
                public void exceptionThrown(@NotNull IOException e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.heap.search.processing.error.notification.content", e.getMessage()), MessageType.ERROR).notify(Searcher.this.myProject);
                    LOG.info((Throwable)e);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        for (Map.Entry<Long, Pair<Long, String>> entry : this.myByStringIdMap.entrySet()) {
                            List<Pair<V8HeapEdge, V8HeapEntry>> nodes = Searcher.this.myReader.getNodesByNameId(entry.getKey());
                            MultiMap<String, Pair<V8HeapEdge, V8HeapEntry>> byType = Searcher.this.filterNodesByType(entry.getKey(), nodes);
                            for (Map.Entry pairEntry : byType.entrySet()) {
                                List<Pair<V8HeapEdge, V8HeapEntry>> pairs;
                                String type = (String)pairEntry.getKey();
                                Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>> listMap = Searcher.this.myResultsByType.get(type);
                                if (listMap == null) {
                                    listMap = new HashMap<String, List<Pair<V8HeapEdge, V8HeapEntry>>>();
                                    Searcher.this.myResultsByType.put(type, listMap);
                                }
                                if ((pairs = listMap.get(entry.getValue().getSecond())) == null) {
                                    pairs = new ArrayList<Pair<V8HeapEdge, V8HeapEntry>>();
                                    listMap.put((String)entry.getValue().getSecond(), pairs);
                                }
                                pairs.addAll((Collection)pairEntry.getValue());
                            }
                        }
                    }
                    finally {
                        listener.finished();
                    }
                }

                public boolean process(Pair<Long, String> pair) {
                    if (indicator.isCanceled()) {
                        return false;
                    }
                    if (Searcher.this.myCaseSensitive ? !((String)pair.getSecond()).contains(Searcher.this.myText) : !StringUtil.toLowerCase((String)((String)pair.getSecond())).contains(Searcher.this.myTextLowered)) {
                        return true;
                    }
                    if (this.myByStringIdMap.size() >= 1000) {
                        Searcher.this.myTooMany = true;
                        return false;
                    }
                    this.myByStringIdMap.put((Long)pair.getFirst(), pair);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/run/profile/heap/view/components/SearchDialog$Searcher$1", "exceptionThrown"));
                }
            });
        }

        private MultiMap<String, Pair<V8HeapEdge, V8HeapEntry>> filterNodesByType(Long stringId, List<Pair<V8HeapEdge, V8HeapEntry>> nodes) {
            if (nodes == null || nodes.isEmpty()) {
                return new MultiMap();
            }
            MultiMap map = new MultiMap();
            for (Pair<V8HeapEdge, V8HeapEntry> pair : nodes) {
                String type = null;
                if (this.myOptions.get(SearchDialog.this.LINK_NAMES).isSelected() && pair.getFirst() != null && stringId.equals(((V8HeapEdge)pair.getFirst()).getNameId())) {
                    type = SearchDialog.this.LINK_NAMES;
                } else if (this.myOptions.get(SearchDialog.this.CLASS_NAMES).isSelected() && stringId.equals(((V8HeapEntry)pair.getSecond()).getNameId()) && !((V8HeapEntry)pair.getSecond()).getType().isStringType()) {
                    type = SearchDialog.this.CLASS_NAMES;
                } else if (this.myOptions.get(SearchDialog.this.TEXT_STRINGS).isSelected() && stringId.equals(((V8HeapEntry)pair.getSecond()).getNameId()) && ((V8HeapEntry)pair.getSecond()).getType().isStringType()) {
                    type = SearchDialog.this.TEXT_STRINGS;
                }
                if (type == null) continue;
                map.putValue((Object)type, pair);
            }
            return map;
        }

        private void trySearchByTextMark(ProgressIndicator indicator, Coordinator.Listener listener) {
            if (!this.myOptions.get(SearchDialog.this.MARKS).isSelected()) {
                listener.finished();
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    indicator.checkCanceled();
                    SearchByMarksWorker worker = new SearchByMarksWorker(this.myProject, this.myReader, this.myText, this.myCaseSensitive);
                    Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>> search = worker.search();
                    indicator.checkCanceled();
                    if (search != null) {
                        this.myResultsByType.put(SearchDialog.this.MARKS, search);
                        indicator.setText(NodeJSBundle.message("progress.text.found.nodes.by.text.mark", worker.getNodesCnt()));
                    }
                }
                finally {
                    listener.finished();
                }
            });
        }

        private void trySearchByObjectId(final ProgressIndicator indicator, final Coordinator.Listener listener) {
            long id;
            if (!this.myOptions.get(SearchDialog.this.SNAPSHOT_OBJECT_IDS).isSelected()) {
                listener.finished();
                return;
            }
            try {
                String searchText = this.myText.startsWith("@") ? this.myText.substring(1) : this.myText;
                id = Long.parseLong(searchText);
            }
            catch (NumberFormatException e) {
                listener.finished();
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    SequentialRawReader<V8HeapEntry> reader = new SequentialRawReader<V8HeapEntry>(this.myReader.getNodeIndexFile(), V8HeapEntry.MyRawSerializer.getInstance(), this.myReader.getNodeCount());
                    reader.iterate(new CloseableThrowableConsumer<V8HeapEntry, IOException>(){
                        private V8HeapEntry myEntry;

                        @Override
                        public void close() throws IOException {
                            if (this.myEntry != null) {
                                ArrayList<Pair> list = new ArrayList<Pair>();
                                list.add(Pair.create(null, (Object)this.myEntry));
                                HashMap<String, ArrayList<Pair>> map = new HashMap<String, ArrayList<Pair>>();
                                map.put(Searcher.this.myText, list);
                                Searcher.this.myResultsByType.put(SearchDialog.this.SNAPSHOT_OBJECT_IDS, map);
                            }
                            listener.finished();
                        }

                        public void consume(V8HeapEntry entry) throws IOException {
                            indicator.checkCanceled();
                            if (entry.getSnapshotObjectId() == id) {
                                this.myEntry = entry;
                                indicator.setText(NodeJSBundle.message("progress.text.found.object", id));
                                throw new ProcessCanceledException();
                            }
                        }
                    });
                }
                catch (IOException e) {
                    NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.heap.search.by.snapshot.object.id.error.notification.content", e.getMessage()), MessageType.ERROR).notify(this.myProject);
                    LOG.info((Throwable)e);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/heap/view/components/SearchDialog$Searcher", "run"));
        }

        private class SearchByMarksWorker {
            @NotNull
            private final Project myProject;
            private final V8CachingReader myReader;
            private final String myText;
            private final boolean myCaseSensitive;
            private final Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>> myResult;
            private int myNodesCnt;

            SearchByMarksWorker(@NotNull Project project, V8CachingReader reader, String text, boolean caseSensitive) {
                if (project == null) {
                    SearchByMarksWorker.$$$reportNull$$$0(0);
                }
                if (reader == null) {
                    SearchByMarksWorker.$$$reportNull$$$0(1);
                }
                this.myProject = project;
                this.myReader = reader;
                this.myText = text;
                this.myCaseSensitive = caseSensitive;
                this.myResult = new HashMap<String, List<Pair<V8HeapEdge, V8HeapEntry>>>();
            }

            public Map<String, List<Pair<V8HeapEdge, V8HeapEntry>>> search() {
                Map<Long, String> map = V8HeapComponent.getInstance(this.myProject).searchByMark(this.myReader.getDigest(), this.myText, this.myCaseSensitive);
                if (map.isEmpty()) {
                    return null;
                }
                HashSet<Long> existing = new HashSet<Long>();
                for (Map.Entry<Long, String> entry : map.entrySet()) {
                    if (existing.contains(entry.getKey())) continue;
                    existing.add(entry.getKey());
                    List<Pair<V8HeapEdge, V8HeapEntry>> list = this.myResult.get(entry.getValue());
                    if (list == null) {
                        list = new ArrayList<Pair<V8HeapEdge, V8HeapEntry>>();
                        this.myResult.put(entry.getValue(), list);
                    }
                    list.add((Pair<V8HeapEdge, V8HeapEntry>)Pair.create(null, (Object)this.myReader.getNode(entry.getKey())));
                }
                this.myNodesCnt = existing.size();
                return this.myResult;
            }

            public int getNodesCnt() {
                return this.myNodesCnt;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reader";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/SearchDialog$Searcher$SearchByMarksWorker";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class Names {
        @Nls
        private final String LINK_NAMES = NodeJSBundle.message("profile.search.option.link_names.text", new Object[0]);
        @Nls
        private final String CLASS_NAMES = NodeJSBundle.message("profile.search.option.class_names.text", new Object[0]);
        @Nls
        private final String TEXT_STRINGS = NodeJSBundle.message("profile.search.option.text_strings.text", new Object[0]);
        @Nls
        private final String SNAPSHOT_OBJECT_IDS = NodeJSBundle.message("profile.search.option.snapshot_object_ids.text", new Object[0]);
        @Nls
        private final String MARKS = NodeJSBundle.message("profile.search.option.marks.text", new Object[0]);
        @Nls
        private final String[] OPTIONS = new String[]{this.LINK_NAMES, this.CLASS_NAMES, this.TEXT_STRINGS, this.SNAPSHOT_OBJECT_IDS, this.MARKS};

        private Names() {
        }
    }
}

