/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.view.actions.GoToSourceAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.MarkUnmarkAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.V8NavigateToMainTreeAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.ChainTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import com.jetbrains.nodejs.run.profile.heap.view.components.DistancesInspectionResultsModel;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8DistancesInspection;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class DistancesInspectionView {
    @NotNull
    private final Project myProject;
    @NotNull
    private final V8CachingReader myReader;
    @NotNull
    private final V8MainTreeNavigator myNavigator;
    private final AtomicReference<ThreeState> myState;
    private V8HeapTreeTable myTable;
    private JPanel myMain;
    private MarkUnmarkAction myMarkUnmarkAction;
    private V8NavigateToMainTreeAction myToMainTreeAction;
    private GoToSourceAction myToSourceAction;
    private V8Utils.ExpandAllAction myExpandAllAction;
    private V8Utils.CollapseAllAction myCollapseAllAction;
    private JLabel myLabel;

    public DistancesInspectionView(@NotNull Project project, @NotNull V8CachingReader reader, @NotNull V8MainTreeNavigator navigator) {
        if (project == null) {
            DistancesInspectionView.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            DistancesInspectionView.$$$reportNull$$$0(1);
        }
        if (navigator == null) {
            DistancesInspectionView.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myReader = reader;
        this.myNavigator = navigator;
        this.myState = new AtomicReference<ThreeState>(ThreeState.NO);
    }

    public JComponent getMainComponent() {
        if (!ThreeState.NO.equals((Object)this.myState.get())) {
            return this.myMain;
        }
        this.myMain = new JPanel(new BorderLayout());
        JPanel inner = new JPanel(new BorderLayout());
        this.myLabel = new JLabel(CommonBundle.getLoadingTreeNodeText());
        inner.add((Component)this.myLabel, "North");
        this.myMain.add((Component)inner, "Center");
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myMain, (Runnable)new Runnable(){

            @Override
            public void run() {
                DistancesInspectionView.this.myState.set(ThreeState.UNSURE);
                ProgressManager.getInstance().run((Task)new V8DistancesInspection(DistancesInspectionView.this.myProject, DistancesInspectionView.this.myReader){

                    public void onSuccess() {
                        DistancesInspectionView.this.myState.set(ThreeState.YES);
                        DistancesInspectionView.this.updateUI(this);
                    }
                });
            }
        });
        return this.myMain;
    }

    private void updateUI(V8DistancesInspection inspection) {
        if (inspection.getException() != null) {
            this.myLabel.setText(inspection.getException().getMessage());
            return;
        }
        DistancesInspectionResultsModel model = new DistancesInspectionResultsModel(this.myProject, this.myReader, inspection);
        this.myTable = V8Utils.createTable(this.myProject, model, this.myReader);
        Object root = model.getRoot();
        List<ChainTreeTableModel.Node<?>> children = model.getChildren(root);
        for (ChainTreeTableModel.Node<?> child : children) {
            this.myTable.getTree().expandPath(new TreePath(new Object[]{root, child}));
        }
        this.myTable.setSelectionMode(0);
        this.myTable.setRowSelectionInterval(0, 0);
        this.myMarkUnmarkAction.setTable(this.myTable);
        this.myToMainTreeAction.setTable(this.myTable);
        this.myToSourceAction.setTable(this.myTable);
        this.myExpandAllAction.setTable(this.myTable);
        this.myCollapseAllAction.setTable(this.myTable);
        TreeTableSpeedSearch search = new TreeTableSpeedSearch((TreeTable)this.myTable, o -> {
            Object component = o.getLastPathComponent();
            return component.toString();
        });
        search.setComparator(new SpeedSearchComparator(false, true));
        V8Utils.installHeapPopupMenu(this.myProject, this.myTable, this.myReader, this.myNavigator);
        Component owner = FocusManager.getCurrentManager().getFocusOwner();
        boolean hasFocus = this.myMain.getParent().equals(owner) || this.myMain.equals(owner);
        DataProviderPanel panel = DataProviderPanel.wrap((JComponent)new JBScrollPane((Component)((Object)this.myTable)));
        this.myMain.removeAll();
        this.myMain.add((Component)((Object)panel), "Center");
        if (hasFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myTable), true));
        }
    }

    public void addActions(DefaultActionGroup group) {
        this.myMarkUnmarkAction = new MarkUnmarkAction(this.myProject, this.myReader);
        this.myToMainTreeAction = new V8NavigateToMainTreeAction();
        this.myToMainTreeAction.setFixedNavigator(this.myNavigator);
        this.myToSourceAction = new GoToSourceAction(this.myReader, null);
        this.myExpandAllAction = new V8Utils.ExpandAllAction(null);
        this.myCollapseAllAction = new V8Utils.CollapseAllAction(null);
        group.add((AnAction)this.myMarkUnmarkAction);
        group.add((AnAction)this.myToMainTreeAction);
        group.add((AnAction)this.myToSourceAction);
        group.add((AnAction)this.myExpandAllAction);
        group.add((AnAction)this.myCollapseAllAction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "reader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "navigator";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/DistancesInspectionView";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

