/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.heap.TempFiles;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapProcessor;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.ShowSnapshotDiffDialog;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8DiffCachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8HeapDiffCalculator;
import com.jetbrains.nodejs.run.profile.heap.calculation.diff.V8HeapDiffComponentPartner;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapComponent;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapComponentPartner;
import com.jetbrains.nodejs.run.profile.heap.view.main.OpenSnapshotWorker;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareWithSnapshotAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.heap.view.components.CompareWithSnapshotAction");
    private final V8CachingReader myReader;
    @NotNull
    private final Project myProject;
    @Nls
    private final String myName;

    public CompareWithSnapshotAction(@NotNull V8CachingReader reader, @NotNull Project project, @Nls String name) {
        if (reader == null) {
            CompareWithSnapshotAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CompareWithSnapshotAction.$$$reportNull$$$0(1);
        }
        super(NodeJSBundle.message("action.CompareWithSnapshotAction.compare.with.text", new Object[0]), NodeJSBundle.message("action.CompareWithSnapshotAction.compare.with.another.snapshot.description", new Object[0]), AllIcons.Actions.Diff);
        this.myReader = reader;
        this.myProject = project;
        this.myName = name;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ShowSnapshotDiffDialog dialog;
        VirtualFile[] files;
        if (e == null) {
            CompareWithSnapshotAction.$$$reportNull$$$0(2);
        }
        if ((files = (dialog = new ShowSnapshotDiffDialog(FileChooserDescriptorFactory.createSingleFileDescriptor((String)"heapsnapshot"), this.myProject, NodeJSBundle.message("profile.CompareWithSnapshot.snapshot_was_taken.text", new Object[0]))).choose(this.myProject, new VirtualFile[0])).length != 1) {
            return;
        }
        VirtualFile file = files[0];
        if (file != null) {
            File changedFile = new File(file.getPath());
            if (FileUtil.filesEqual((File)changedFile, (File)this.myReader.getOriginalFile())) {
                NodeProfilingSettings.HEAP_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.compare_snapshot_with_itself.action.name", new Object[0]), MessageType.WARNING).notify(this.myProject);
                return;
            }
            CalculateSecondAndDiff calculateSecondAndDiff = new CalculateSecondAndDiff(this.myProject, changedFile, this.myReader, this.myName, file.getNameWithoutExtension(), !dialog.isAfter());
            ProgressManager.getInstance().run((Task)calculateSecondAndDiff);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/CompareWithSnapshotAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CalculateSecondAndDiff
    extends Task.Backgroundable {
        @NotNull
        private final File myFile;
        @NotNull
        private final V8CachingReader myBaseReader;
        @Nls
        private final String myName;
        @Nls
        private final String myChangedName;
        private final boolean mySwitchSnapshots;
        private final Consumer<String> myNotificator;
        private V8CachingReader mySecondReader;
        private V8DiffCachingReader myDiffCachingReader;
        private V8CachingReader myChangedForDiffReader;
        private V8CachingReader myBaseForDiffReader;

        CalculateSecondAndDiff(@Nullable Project project, @NotNull File file, @NotNull V8CachingReader baseReader, @Nls String name, @Nls String changedName, boolean switchSnapshots) {
            if (file == null) {
                CalculateSecondAndDiff.$$$reportNull$$$0(0);
            }
            if (baseReader == null) {
                CalculateSecondAndDiff.$$$reportNull$$$0(1);
            }
            super(project, NodeJSBundle.message("progress.title.processing.heap.snapshot.building.snapshots.diff", file.getName()));
            this.myFile = file;
            this.myBaseReader = baseReader;
            this.myName = name;
            this.myChangedName = changedName;
            this.mySwitchSnapshots = switchSnapshots;
            this.myNotificator = OpenSnapshotWorker.createNotificator(this.myProject);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                CalculateSecondAndDiff.$$$reportNull$$$0(2);
            }
            try {
                V8HeapProcessor processor = new V8HeapProcessor(this.myNotificator, this.myFile, this.myBaseReader.isShowHidden(), indicator);
                this.mySecondReader = processor.getFromCacheOrProcess();
                V8HeapProcessor processorChangedForDiff = new V8HeapProcessor(this.myNotificator, this.myFile, this.myBaseReader.isShowHidden(), indicator);
                V8HeapProcessor baseForDiffProcessor = new V8HeapProcessor(this.myNotificator, this.myBaseReader.getOriginalFile(), this.myBaseReader.isShowHidden(), indicator);
                if (this.mySwitchSnapshots) {
                    this.myBaseForDiffReader = processorChangedForDiff.getFromCacheOrProcess();
                    this.myChangedForDiffReader = baseForDiffProcessor.getFromCacheOrProcess();
                } else {
                    this.myBaseForDiffReader = baseForDiffProcessor.getFromCacheOrProcess();
                    this.myChangedForDiffReader = processorChangedForDiff.getFromCacheOrProcess();
                }
                V8HeapDiffCalculator diffCalculator = new V8HeapDiffCalculator(this.myBaseForDiffReader, this.myChangedForDiffReader, new TempFiles("v8"));
                diffCalculator.execute();
                this.myDiffCachingReader = new V8DiffCachingReader(this.myBaseForDiffReader, this.myChangedForDiffReader, diffCalculator.getBaseSnapshotIds(), diffCalculator.getChangedSnapshotIds(), diffCalculator.getBaseSnapshotSizes(), diffCalculator.getChangedSnapshotSizes(), diffCalculator.getAggregatesViewDiff(), diffCalculator.getBiggestObjectsDiff());
                this.myDiffCachingReader.prepare();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.myNotificator.consume((Object)e.getMessage());
                indicator.cancel();
            }
            catch (ClassNotFoundException e) {
                LOG.info((Throwable)e);
                this.myNotificator.consume((Object)e.getMessage());
                indicator.cancel();
            }
        }

        public void onSuccess() {
            ByteArrayWrapper baseDigest = this.myBaseReader.getDigest();
            ByteArrayWrapper changedDigest = this.mySecondReader.getDigest();
            byte[] bytes = new byte[baseDigest.getData().length + changedDigest.getData().length];
            if (this.mySwitchSnapshots) {
                System.arraycopy(changedDigest.getData(), 0, bytes, 0, changedDigest.getData().length);
                System.arraycopy(baseDigest.getData(), 0, bytes, changedDigest.getData().length, baseDigest.getData().length);
            } else {
                System.arraycopy(baseDigest.getData(), 0, bytes, 0, baseDigest.getData().length);
                System.arraycopy(changedDigest.getData(), 0, bytes, baseDigest.getData().length, changedDigest.getData().length);
            }
            try {
                V8HeapComponent heapComponent = V8HeapComponent.getInstance(this.myProject);
                heapComponent.showMe(this.mySecondReader.getDigest(), new V8HeapComponentPartner(this.mySecondReader, this.myChangedName), this.myChangedName, null);
                ByteArrayWrapper digest = new ByteArrayWrapper(bytes);
                if (heapComponent.activateIfOpen(digest)) {
                    return;
                }
                if (this.mySwitchSnapshots) {
                    V8HeapDiffComponentPartner partner = new V8HeapDiffComponentPartner(this.myProject, this.myDiffCachingReader, this.myChangedName, this.myName);
                    heapComponent.showMe(digest, partner, this.myChangedName + " -> " + this.myName, AllIcons.Actions.Diff);
                } else {
                    V8HeapDiffComponentPartner partner = new V8HeapDiffComponentPartner(this.myProject, this.myDiffCachingReader, this.myName, this.myChangedName);
                    heapComponent.showMe(digest, partner, this.myName + " -> " + this.myChangedName, AllIcons.Actions.Diff);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.myNotificator.consume((Object)e.getMessage());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseReader";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/CompareWithSnapshotAction$CalculateSecondAndDiff";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

