/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.AggregatesPortionBuilder;
import com.jetbrains.nodejs.run.profile.heap.calculation.DominatedNodesBuilder;
import com.jetbrains.nodejs.run.profile.heap.calculation.Flags;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager;
import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import com.jetbrains.nodejs.run.profile.heap.io.LongRawSerializer;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawWriter;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.SizeOffset;
import gnu.trove.TLongHashSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class AggregatesBuilder {
    private static final int PORTION_SIZE = 10000;
    @NotNull
    private final IndexFiles myIndexFiles;
    @NotNull
    private final V8CachingReader myReader;
    @NotNull
    private final Flags myFlags;
    private final boolean myShowHiddenData;
    @NotNull
    private final DominatedNodesBuilder myDominatedNodesBuilder;
    private final LongArrayList myRetainedSizes;
    private final IntList myDistances;
    private final IntList myUnreachable;
    private File myNumAggregated;
    private File myLinks;
    private final Map<Long, Aggregate> myAggregateMap;
    private final LongArrayList myTmpClassShortcut;
    private final LongArrayList myTmpSize;
    private final IntList myTmpTypeShortcut;

    /*
     * WARNING - void declaration
     */
    public AggregatesBuilder(@NotNull IndexFiles indexFiles, @NotNull V8CachingReader reader, @NotNull Flags flags, boolean showHiddenData, long nodesCnt, @NotNull DominatedNodesBuilder dominatedNodesBuilder, LongArrayList retainedSizes, IntList distances, IntList intList) {
        void unreachable;
        if (indexFiles == null) {
            AggregatesBuilder.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            AggregatesBuilder.$$$reportNull$$$0(1);
        }
        if (flags == null) {
            AggregatesBuilder.$$$reportNull$$$0(2);
        }
        if (dominatedNodesBuilder == null) {
            AggregatesBuilder.$$$reportNull$$$0(3);
        }
        this.myIndexFiles = indexFiles;
        this.myReader = reader;
        this.myFlags = flags;
        this.myShowHiddenData = showHiddenData;
        this.myDominatedNodesBuilder = dominatedNodesBuilder;
        this.myRetainedSizes = retainedSizes;
        this.myDistances = distances;
        this.myUnreachable = unreachable;
        this.myAggregateMap = new HashMap<Long, Aggregate>();
        this.myTmpTypeShortcut = new IntArrayList((int)nodesCnt);
        this.myTmpClassShortcut = new LongArrayList((int)nodesCnt);
        this.myTmpSize = new LongArrayList((int)nodesCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        this.myNumAggregated = this.myIndexFiles.generate(V8HeapIndexManager.Category.aggregateNum, ".aggregate");
        this.myLinks = this.myIndexFiles.generate(V8HeapIndexManager.Category.aggregateLinks, ".aggregateLinks");
        SequentialRawWriter<SizeOffset> numWriter = new SequentialRawWriter<SizeOffset>(this.myNumAggregated, SizeOffset.MySerializer.getInstance());
        SequentialRawWriter<Long> writer = new SequentialRawWriter<Long>(this.myLinks, new LongRawSerializer());
        try {
            long from = -100L;
            long to = 9999L;
            AggregatesPortionBuilder first = new AggregatesPortionBuilder(this.myReader, this.myFlags, this.myShowHiddenData, from, to, 0, this.myDistances, this.myUnreachable){

                @Override
                protected void additionalProcessing(V8HeapEntry entry) {
                    AggregatesBuilder.this.myTmpTypeShortcut.add(entry.getType().getNumber());
                    AggregatesBuilder.this.myTmpClassShortcut.add(entry.getClassIndex());
                    AggregatesBuilder.this.myTmpSize.add(entry.getSize());
                }
            };
            first.calculate(numWriter, writer);
            this.myAggregateMap.putAll(first.getAggregates());
            from = 10001L;
            to = from + 10000L - 1L;
            long stringNum = this.myReader.getStringIndex().getCnt();
            while (to <= stringNum) {
                AggregatesPortionBuilder builder = new AggregatesPortionBuilder(this.myReader, this.myFlags, this.myShowHiddenData, from, to, this.myAggregateMap.size(), this.myDistances, this.myUnreachable);
                builder.calculate(numWriter, writer);
                this.myAggregateMap.putAll(builder.getAggregates());
                from = to + 1L;
                to = from + 10000L - 1L;
            }
        }
        finally {
            numWriter.close();
            writer.close();
        }
        this.calculateRetainedSizes(this.myDominatedNodesBuilder.getDominatedIdx(), this.myDominatedNodesBuilder.getDominatedLinks());
    }

    public LinksReaderFactory<Long> createLinksReaderFactory() {
        return new LinksReaderFactory<Long>(new LongRawSerializer(), this.myNumAggregated, this.myLinks);
    }

    public Map<Long, Aggregate> getAggregateMap() {
        return this.myAggregateMap;
    }

    public void calculateRetainedSizes(IntList dominatedIdx, IntList dominatedLinks) {
        TLongHashSet seen = new TLongHashSet();
        ArrayDeque<Long> sizes = new ArrayDeque<Long>();
        ArrayDeque<Long> classes = new ArrayDeque<Long>();
        ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
        queue.add(0);
        int nativeNumber = V8HeapNodeType.kNative.getNumber();
        while (!queue.isEmpty()) {
            int domTo;
            int nodeIdx = (Integer)queue.removeLast();
            long classIdx = this.myTmpClassShortcut.getLong(nodeIdx);
            int type = this.myTmpTypeShortcut.getInt(nodeIdx);
            long size = this.myTmpSize.getLong(nodeIdx);
            Aggregate aggregate = this.myAggregateMap.get(classIdx);
            if (aggregate == null) {
                // empty if block
            }
            int domFrom = dominatedIdx.getInt(nodeIdx);
            int n = domTo = nodeIdx == dominatedIdx.size() - 1 ? dominatedLinks.size() : dominatedIdx.getInt(nodeIdx + 1);
            if (!(seen.contains(classIdx) || !this.myShowHiddenData && !this.myFlags.isPage(nodeIdx) || nativeNumber != type && size <= 0L)) {
                long current = this.myRetainedSizes.getLong(nodeIdx);
                if (aggregate != null) {
                    aggregate.addRetained(current);
                }
                if (domFrom != domTo) {
                    seen.add(classIdx);
                    sizes.addLast(Long.valueOf(queue.size()));
                    classes.addLast(classIdx);
                }
            }
            for (int i = domFrom; i < domTo; ++i) {
                int dependent = dominatedLinks.getInt(i);
                if (dependent < 0) continue;
                queue.addLast(dependent);
            }
            while (!sizes.isEmpty() && (Long)sizes.getLast() == (long)queue.size()) {
                sizes.removeLast();
                Long classIndex = (Long)classes.removeLast();
                seen.remove(classIndex.longValue());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "indexFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "reader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "flags";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "dominatedNodesBuilder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/AggregatesBuilder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

