/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.jetbrains.nodejs.run.profile.TreeTableWidthController;
import com.jetbrains.nodejs.run.profile.TreeTableWithTreeWidthController;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.CallHolder;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLineFileDescriptor;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import java.awt.Dimension;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8ProfilingCallTreeTable
extends TreeTableWithTreeWidthController
implements DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable");
    private final CopyProvider myProvider;
    private final ColoredTableCellRenderer myDefaultTableRenderer;
    private final Project myProject;
    private final ColoredTreeCellRenderer myDefaultRenderer;
    private TreeTableWidthController myController;

    public V8ProfilingCallTreeTable(Project project, TreeTableModel treeTableModel, Disposable disposable) {
        super(treeTableModel, disposable);
        this.myProject = project;
        this.getTree().setUI((TreeUI)new WideSelectionTreeUI(true, Conditions.alwaysTrue()));
        this.setAutoResizeMode(0);
        this.getTableHeader().setResizingAllowed(false);
        this.myDefaultRenderer = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean treeHasFocus = ((TreeTableTree)tree).getTreeTable().hasFocus();
                this.setPaintFocusBorder(false);
                this.setBackground(UIUtil.getTreeBackground((boolean)selected, (boolean)treeHasFocus));
                @NlsSafe String fragment = value.toString();
                if (selected && !treeHasFocus) {
                    this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, UIUtil.getTableForeground(), null, null));
                } else {
                    this.append(fragment);
                }
            }

            protected boolean shouldDrawBackground() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/nodejs/run/profile/cpu/view/V8ProfilingCallTreeTable$1", "customizeCellRenderer"));
            }
        };
        this.myDefaultTableRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.setPaintFocusBorder(false);
                this.setBackground(UIUtil.getTreeBackground((boolean)selected, (boolean)table.hasFocus()));
                @NlsSafe String fragment = value.toString();
                if (selected && !table.hasFocus()) {
                    this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(-1, UIUtil.getTableForeground(), null, null));
                } else {
                    this.append(fragment);
                }
            }

            protected SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes) {
                return attributes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/nodejs/run/profile/cpu/view/V8ProfilingCallTreeTable$2", "customizeCellRenderer"));
            }
        };
        this.myProvider = new CopyProvider(){

            public void performCopy(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    3.$$$reportNull$$$0(0);
                }
                try {
                    int row = V8ProfilingCallTreeTable.this.getSelectedRow();
                    TreePath path = V8ProfilingCallTreeTable.this.getTree().getSelectionPath();
                    if (row < 0 || path == null) {
                        return;
                    }
                    Object selectedObject = path.getLastPathComponent();
                    TreeTableModel model = V8ProfilingCallTreeTable.this.getTableModel();
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < model.getColumnCount(); ++i) {
                        Object valueAt;
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        if ((valueAt = model.getValueAt(selectedObject, i)) instanceof Pair) {
                            Pair pair = (Pair)valueAt;
                            sb.append(pair.getFirst().toString()).append(" ").append(pair.getSecond().toString());
                            continue;
                        }
                        sb.append(valueAt.toString());
                    }
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
                }
                catch (Exception ex) {
                    LOG.info((Throwable)ex);
                }
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    3.$$$reportNull$$$0(1);
                }
                return V8ProfilingCallTreeTable.this.getSelectedRowCount() > 0;
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext) {
                if (dataContext == null) {
                    3.$$$reportNull$$$0(2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "dataContext";
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/V8ProfilingCallTreeTable$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performCopy";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyEnabled";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCopyVisible";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        V8Utils.setSmallerTreeIndent(this.getTree());
    }

    @Override
    @Nullable
    public TreeTableWidthController getWidthController() {
        return this.myController;
    }

    public void setController(TreeTableWidthController controller) {
        this.myController = controller;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int parentWidth = this.getParent().getWidth();
        if (this.myController == null || parentWidth == 0) {
            return size;
        }
        int width = this.myController.getWidth(parentWidth);
        return new Dimension(width, size.height);
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            V8ProfilingCallTreeTable.$$$reportNull$$$0(0);
        }
        if (V8Utils.NAVIGATABLE_ONLY_FOR_ACTION.is(dataId)) {
            Navigatable[] navigatables = this.getNavigatables();
            if (navigatables != null) {
                return navigatables;
            }
        } else if (V8Utils.NAVIGATION_POSITION.is(dataId)) {
            CallHolder v8ProfileLine;
            int row = this.getSelectedRow();
            if (row >= 0 && (v8ProfileLine = this.getV8ProfileLine(row)) != null && v8ProfileLine.getCall().getDescriptor() != null) {
                V8ProfileLineFileDescriptor descriptor = v8ProfileLine.getCall().getDescriptor();
                return Pair.create((Object)descriptor.getRow(), (Object)descriptor.getCol());
            }
        } else if (V8Utils.IS_NAVIGATABLE.is(dataId)) {
            CallHolder v8ProfileLine;
            int row = this.getSelectedRow();
            if (row >= 0 && (v8ProfileLine = this.getV8ProfileLine(row)) != null && v8ProfileLine.getCall().getDescriptor() != null) {
                return true;
            }
        } else {
            CallHolder v8ProfileLine;
            int row;
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return this.myProvider;
            }
            if (V8Utils.SELECTED_CALL.is(dataId) && (row = this.getSelectedRow()) >= 0 && (v8ProfileLine = this.getV8ProfileLine(row)) != null) {
                return v8ProfileLine.getCall();
            }
        }
        return null;
    }

    private Navigatable @Nullable [] getNavigatables() {
        CallHolder v8ProfileLine;
        int row = this.getSelectedRow();
        if (row >= 0 && (v8ProfileLine = this.getV8ProfileLine(row)) != null && v8ProfileLine.getCall().getDescriptor() != null) {
            return v8ProfileLine.getCall().getNavigatables(this.myProject);
        }
        return null;
    }

    public CallHolder getV8ProfileLine(int row) {
        Object o;
        TreePath pathForRow = this.getTree().getPathForRow(row);
        if (pathForRow != null && (o = pathForRow.getLastPathComponent()) instanceof CallHolder) {
            return (CallHolder)o;
        }
        return null;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer;
        TableCellRenderer superRenderer = super.getCellRenderer(row, column);
        CallHolder v8ProfileLine = this.getV8ProfileLine(row);
        if (v8ProfileLine != null && (renderer = ((TreeTableModelWithCustomRenderer)this.getTableModel()).getCustomizedRenderer(column, v8ProfileLine, superRenderer)) != null) {
            return renderer;
        }
        if (!(superRenderer instanceof TreeTableCellRenderer)) {
            return this.myDefaultTableRenderer;
        }
        ((TreeTableCellRenderer)superRenderer).setCellRenderer((TreeCellRenderer)this.myDefaultRenderer);
        return superRenderer;
    }

    public void collapseRowRecursively() {
        TreeTableTree tree = this.getTree();
        TreePath leadSelectionPath = tree.getLeadSelectionPath();
        if (leadSelectionPath == null) {
            return;
        }
        Enumeration descendants = tree.getExpandedDescendants(leadSelectionPath);
        if (descendants != null) {
            while (descendants.hasMoreElements()) {
                TreePath path = (TreePath)descendants.nextElement();
                tree.collapsePath(path);
            }
        }
        tree.collapsePath(leadSelectionPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/jetbrains/nodejs/run/profile/cpu/view/V8ProfilingCallTreeTable", "getData"));
    }
}

