/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.execution.ui.layout.impl.JBRunnerTabs;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingCallTreeTable;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsTreeTableWithDetails {
    @NonNls
    public static final String V8_CPU_PROFILING_SEARCH_RESULTS_PLACE = "v8CpuProfilingSearchResultsTab";
    private final Project myProject;
    @NotNull
    private final Disposable myDisposable;
    private final V8ProfilingCallTreeTable myTable;
    private final TreeTableSpeedSearch mySpeedSearch;
    private final Splitter mySplitter;
    private JBTabs myRunnerTabs;
    private final Set<String> myKeepTabs;

    public StatisticsTreeTableWithDetails(Project project, @NotNull V8ProfilingCallTreeTable table, @NotNull Convertor<TreePath, String> searchConvertor, @NotNull Disposable disposable) {
        if (table == null) {
            StatisticsTreeTableWithDetails.$$$reportNull$$$0(0);
        }
        if (searchConvertor == null) {
            StatisticsTreeTableWithDetails.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            StatisticsTreeTableWithDetails.$$$reportNull$$$0(2);
        }
        this.myTable = table;
        this.myProject = project;
        this.myDisposable = disposable;
        this.mySplitter = new Splitter(true);
        this.mySplitter.setFirstComponent((JComponent)new JBScrollPane((Component)((Object)this.myTable)));
        this.mySpeedSearch = new TreeTableSpeedSearch((TreeTable)this.myTable, searchConvertor);
        this.myKeepTabs = new HashSet<String>();
    }

    public void addDetails(@NotNull JComponent component, @Nullable List<AnAction> actions, @NotNull @NlsContexts.TabTitle String title, boolean addRemove) {
        TabInfo info;
        if (component == null) {
            StatisticsTreeTableWithDetails.$$$reportNull$$$0(3);
        }
        if (title == null) {
            StatisticsTreeTableWithDetails.$$$reportNull$$$0(4);
        }
        if (this.mySplitter.getSecondComponent() == null) {
            this.myRunnerTabs = JBRunnerTabs.create((Project)this.myProject, (Disposable)this.myDisposable);
            this.myRunnerTabs.addTabMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(@NotNull MouseEvent e) {
                    TabInfo tabInfo;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (UIUtil.isCloseClick((MouseEvent)e) && (tabInfo = StatisticsTreeTableWithDetails.this.myRunnerTabs.findInfo(e)) != null && !StatisticsTreeTableWithDetails.this.myKeepTabs.contains(tabInfo.getText())) {
                        StatisticsTreeTableWithDetails.this.closeTab(tabInfo);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/run/profile/cpu/view/StatisticsTreeTableWithDetails$1", "mousePressed"));
                }
            });
            this.mySplitter.setSecondComponent(this.myRunnerTabs.getComponent());
        }
        JBScrollPane scroll = new JBScrollPane((Component)component);
        if (actions != null) {
            DefaultActionGroup group = new DefaultActionGroup();
            group.addAll(actions);
            V8Utils.WithToolbarWrapper wrapper = new V8Utils.WithToolbarWrapper((JComponent)scroll, group);
            info = new TabInfo((JComponent)wrapper.getMainPanel()).setText(title);
        } else {
            info = new TabInfo((JComponent)scroll).setText(title);
        }
        if (!addRemove) {
            this.myKeepTabs.add(info.getText());
        }
        this.myRunnerTabs.setPopupGroup((ActionGroup)new DefaultActionGroup(new AnAction[]{new DumbAwareAction(){
            {
                AnAction action = ActionManager.getInstance().getAction("CloseActiveTab");
                this.getTemplatePresentation().copyFrom(action.getTemplatePresentation());
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                TabInfo selectedInfo = StatisticsTreeTableWithDetails.this.myRunnerTabs.getSelectedInfo();
                e.getPresentation().setEnabled(selectedInfo != null && !StatisticsTreeTableWithDetails.this.myKeepTabs.contains(selectedInfo.getText()));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                StatisticsTreeTableWithDetails.this.closeTab(StatisticsTreeTableWithDetails.this.myRunnerTabs.getSelectedInfo());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/StatisticsTreeTableWithDetails$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }}), V8_CPU_PROFILING_SEARCH_RESULTS_PLACE, true);
        this.myRunnerTabs.addTab(info);
        this.myRunnerTabs.select(info, true);
    }

    private void closeTab(TabInfo tabInfo) {
        this.myRunnerTabs.removeTab(tabInfo);
        if (this.myRunnerTabs.getTabCount() == 0) {
            this.mySplitter.setSecondComponent(null);
            Disposer.dispose((Disposable)((Disposable)this.myRunnerTabs));
            this.myRunnerTabs = null;
        }
    }

    public JComponent getComponent() {
        return this.mySplitter;
    }

    public V8ProfilingCallTreeTable getTable() {
        return this.myTable;
    }

    public void showSpeedSearch(@NotNull V8CpuLogCall call) {
        if (call == null) {
            StatisticsTreeTableWithDetails.$$$reportNull$$$0(5);
        }
        String secondWord = call.getDescriptor() == null ? "" : call.getDescriptor().getShortLink();
        String firstWord = StringUtil.notNullize((String)call.getFunctionName());
        String presentation = (firstWord + " " + secondWord).trim();
        if (this.mySpeedSearch.isPopupActive()) {
            this.mySpeedSearch.hidePopup();
        }
        this.mySpeedSearch.showPopup(presentation);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myTable), true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchConvertor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/StatisticsTreeTableWithDetails";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addDetails";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showSpeedSearch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

