/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RequestsMerger;
import com.intellij.util.BeforeAfter;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8CpuViewCallback;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8StackTableModel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartParameters;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartView;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.V8CpuOverviewChart;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class FlameChartViewUpdater {
    private final FlameChartView myView;
    @NotNull
    private final V8CpuViewCallback myViewCallback;
    @NotNull
    private final Consumer<? super String> myNotificator;
    private FlameChartParameters myParameters;
    private final Map<LoadKind, AtomicBoolean> myNeededLoad;
    private final Map<UiUpdateKind, AtomicBoolean> myNeededUiUpdate;
    private final RequestsMerger myUiUpdater;
    private final RequestsMerger myBackgroundUpdater;
    private final Object myStackUpdateLock;
    private int myStackIdx;
    private V8StackTableModel myStackTableModel;

    public FlameChartViewUpdater(@NotNull FlameChartView flameChartView, @NotNull V8CpuViewCallback viewCallback, @NotNull Consumer<? super String> notificator, FlameChartParameters parameters) {
        if (flameChartView == null) {
            FlameChartViewUpdater.$$$reportNull$$$0(0);
        }
        if (viewCallback == null) {
            FlameChartViewUpdater.$$$reportNull$$$0(1);
        }
        if (notificator == null) {
            FlameChartViewUpdater.$$$reportNull$$$0(2);
        }
        this.myView = flameChartView;
        this.myViewCallback = viewCallback;
        this.myNotificator = notificator;
        this.myParameters = parameters;
        this.myStackUpdateLock = new Object();
        this.myStackIdx = -1;
        this.myStackTableModel = null;
        this.myNeededLoad = new HashMap<LoadKind, AtomicBoolean>();
        for (LoadKind loadKind : LoadKind.values()) {
            this.myNeededLoad.put(loadKind, new AtomicBoolean(false));
        }
        this.myNeededUiUpdate = new HashMap<UiUpdateKind, AtomicBoolean>();
        for (Enum enum_ : UiUpdateKind.values()) {
            this.myNeededUiUpdate.put((UiUpdateKind)enum_, new AtomicBoolean(false));
        }
        this.myUiUpdater = new RequestsMerger(this.createUiUpdate(), runnable -> ApplicationManager.getApplication().invokeLater(runnable));
        this.myBackgroundUpdater = new RequestsMerger(this.createLoadUpdate(), runnable -> ApplicationManager.getApplication().executeOnPooledThread(runnable));
    }

    private Runnable createLoadUpdate() {
        return () -> {
            if (this.myNeededLoad.get((Object)LoadKind.flame).getAndSet(false)) {
                this.myNeededLoad.get((Object)LoadKind.stack).getAndSet(false);
                this.updateFlameData();
                return;
            }
            if (this.myNeededLoad.get((Object)LoadKind.stack).getAndSet(false)) {
                this.updateStack();
            }
        };
    }

    private Runnable createUiUpdate() {
        return () -> {
            if (this.myNeededUiUpdate.get((Object)UiUpdateKind.overviewSelection).getAndSet(false) && this.doOverviewSelectionChanged()) {
                return;
            }
            if (this.myNeededUiUpdate.get((Object)UiUpdateKind.overviewSelectionResult).getAndSet(false)) {
                this.doApplyOverviewSelectionResult();
            }
            if (this.myNeededUiUpdate.get((Object)UiUpdateKind.detailsInChart).getAndSet(false)) {
                this.doDetailsInChartChanged();
            }
            if (this.myNeededUiUpdate.get((Object)UiUpdateKind.detailsRowInChart).getAndSet(false)) {
                this.doDetailsRowInChartChanged();
            }
        };
    }

    @RequiresEdt
    private void reportUiChange(@NotNull UiUpdateKind kind) {
        if (kind == null) {
            FlameChartViewUpdater.$$$reportNull$$$0(3);
        }
        this.myNeededUiUpdate.get((Object)kind).set(true);
        this.myUiUpdater.request();
    }

    @RequiresEdt
    private boolean doOverviewSelectionChanged() {
        try {
            this.myViewCallback.updateActionsAvailability();
            V8CpuOverviewChart overview = this.myView.getOverviewChart();
            BeforeAfter<Long> currentSelection = this.myView.getFlameChart().getSelection();
            if (Comparing.equal((Object)overview.getLeftBound(), (Object)((Long)currentSelection.getBefore())) && Comparing.equal((Object)overview.getRightBound(), (Object)((Long)currentSelection.getAfter()))) {
                this.checkAndInit();
                return false;
            }
            this.myView.getFlameChart().selection(overview.getLeftBound(), overview.getRightBound());
            this.myView.getEventsStripe().selection(overview.getLeftBound(), overview.getRightBound());
            this.myNeededLoad.get((Object)LoadKind.flame).set(true);
            this.myBackgroundUpdater.request();
        }
        catch (IOException e) {
            this.myNotificator.consume((Object)e.getMessage());
        }
        return true;
    }

    private void checkAndInit() {
        if (this.myParameters != null) {
            this.myParameters.updateView(this.myView);
            this.myParameters = null;
        }
    }

    @RequiresEdt
    private void doApplyOverviewSelectionResult() {
        boolean empty = !this.myNeededUiUpdate.get((Object)UiUpdateKind.overviewSelection).get();
        this.myView.getFlameChart().getUIUpdate().consume((Object)empty);
        this.myView.getEventsStripe().getUIUpdate().consume((Object)empty);
        this.checkAndInit();
    }

    @RequiresBackgroundThread
    private void updateFlameData() {
        this.myView.getFlameChart().updateData();
        this.myView.getEventsStripe().updateData();
        this.reportUiChange(UiUpdateKind.overviewSelectionResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private void updateStack() {
        Pair<Long, Integer> detailsPosition = this.myView.getFlameChart().getDetailsPosition();
        Object object = this.myStackUpdateLock;
        synchronized (object) {
            if ((Integer)detailsPosition.getSecond() == this.myStackIdx) {
                this.reportUiChange(UiUpdateKind.detailsInChart);
                return;
            }
        }
        try {
            V8StackTableModel model = this.myView.createStackTableModel((Integer)detailsPosition.getSecond());
            Object object2 = this.myStackUpdateLock;
            synchronized (object2) {
                this.myStackIdx = (Integer)detailsPosition.getSecond();
                this.myStackTableModel = model;
            }
            this.reportUiChange(UiUpdateKind.detailsInChart);
        }
        catch (IOException e) {
            this.myNotificator.consume((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private void doDetailsInChartChanged() {
        V8StackTableModel model;
        Object object = this.myStackUpdateLock;
        synchronized (object) {
            model = this.myStackTableModel;
        }
        this.myView.updateStackTraceTable(model);
    }

    @RequiresEdt
    private void doDetailsRowInChartChanged() {
        this.myView.setSelectedRowInTableByChart();
    }

    @RequiresEdt
    public void overviewSelectionChanged() {
        this.reportUiChange(UiUpdateKind.overviewSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public void detailsLineChanged() {
        Pair<Long, Integer> detailsPosition = this.myView.getFlameChart().getDetailsPosition();
        Object object = this.myStackUpdateLock;
        synchronized (object) {
            if ((Integer)detailsPosition.getSecond() == this.myStackIdx) {
                this.reportUiChange(UiUpdateKind.detailsRowInChart);
            } else {
                this.myNeededLoad.get((Object)LoadKind.stack).set(true);
                this.myBackgroundUpdater.request();
            }
        }
    }

    public void afterLoad(final Runnable runnable) {
        this.myBackgroundUpdater.waitRefresh(() -> this.myUiUpdater.waitRefresh(new Runnable(){

            @Override
            public void run() {
                if (!FlameChartViewUpdater.this.myBackgroundUpdater.isEmpty() || !FlameChartViewUpdater.this.myUiUpdater.isEmpty() || this.somethingRaised()) {
                    ApplicationManager.getApplication().invokeLater(() -> FlameChartViewUpdater.this.afterLoad(runnable));
                } else {
                    runnable.run();
                }
            }

            private boolean somethingRaised() {
                boolean raised = false;
                for (AtomicBoolean aBoolean : FlameChartViewUpdater.this.myNeededLoad.values()) {
                    raised |= aBoolean.get();
                }
                for (AtomicBoolean aBoolean : FlameChartViewUpdater.this.myNeededUiUpdate.values()) {
                    raised |= aBoolean.get();
                }
                return raised;
            }
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flameChartView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewCallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/FlameChartViewUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reportUiChange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum UiUpdateKind {
        overviewSelection,
        detailsInChart,
        detailsRowInChart,
        overviewSelectionResult;

    }

    private static enum LoadKind {
        flame,
        stack;

    }
}

