/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.reading;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameColors;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfileLineTreeCellRenderer;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8StackTableModel
extends AbstractTableModel {
    private final String[] HEADERS;
    private final V8LogCachingReader myReader;
    private final List<? extends V8CpuLogCall> myLines;
    private final List<JBColor> myColors;
    private final List<Long> myDurations;
    private final ColoredTableCellRenderer myRenderer;
    private ColoredTableCellRenderer myLastColumnRenderer;

    public V8StackTableModel(V8LogCachingReader reader, @NotNull List<? extends V8CpuLogCall> lines, @NotNull List<Long> durations) throws IOException {
        if (lines == null) {
            V8StackTableModel.$$$reportNull$$$0(0);
        }
        if (durations == null) {
            V8StackTableModel.$$$reportNull$$$0(1);
        }
        this.HEADERS = new String[]{"Function", "File", "Duration"};
        this.myReader = reader;
        this.myLines = lines;
        this.myColors = new ArrayList<JBColor>();
        this.myDurations = durations;
        this.fillData();
        this.myLastColumnRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                V8CpuLogCall call;
                if (table == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((call = V8StackTableModel.this.getCall(row)) != null) {
                    V8ProfileLineTreeCellRenderer.Attributes attributes = V8ProfileLineTreeCellRenderer.getAttributes(call.isLocal(), call.isNative() || call.isNotNavigatable());
                    if (value instanceof Long) {
                        long lValue = (Long)value;
                        if (lValue < 0L) {
                            return;
                        }
                        this.append(NodeJSBundle.message("profile.cpu.milliseconds.text", Math.round((double)lValue / 1000.0)), attributes.getAttributes(false));
                        return;
                    }
                }
                if (value != null) {
                    @NlsSafe String fragment = value.toString();
                    this.append(fragment);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8StackTableModel$1", "customizeCellRenderer"));
            }
        };
        this.myRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                @NlsSafe String fragment = value.toString();
                if (value instanceof V8ProfileLine.ExecKind) {
                    this.append(fragment, SimpleTextAttributes.GRAY_ATTRIBUTES);
                    return;
                }
                V8CpuLogCall call = V8StackTableModel.this.getCall(row);
                if (call != null) {
                    V8ProfileLineTreeCellRenderer.Attributes attributes = V8ProfileLineTreeCellRenderer.getAttributes(call.isLocal(), call.isNative() || call.isNotNavigatable());
                    if (value instanceof String) {
                        if (column == 0) {
                            this.setIcon((Icon)JBUIScale.scaleIcon((JBScalableIcon)new ColorIcon(16, (Color)V8StackTableModel.this.myColors.get(row), true)));
                            if (0L == call.getStringId()) {
                                this.append(call.getPresentation(), SimpleTextAttributes.GRAY_ATTRIBUTES);
                            } else if (!V8ProfileLine.ExecKind.Function.equals((Object)call.getExecKind()) && !V8ProfileLine.ExecKind.LazyCompile.equals((Object)call.getExecKind())) {
                                this.append("(" + call.getExecKind() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                            } else {
                                this.append(fragment, attributes.getAttributes(false));
                                if (V8ProfileLine.ExecKind.LazyCompile.equals((Object)call.getExecKind())) {
                                    this.append(" (" + NodeJSBundle.message("profile.cpu.record.kind.lazy.text", new Object[0]) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                                }
                            }
                        } else {
                            if (0L == call.getStringId()) {
                                return;
                            }
                            this.append(fragment, attributes.getAttributes(false));
                        }
                    }
                } else {
                    this.append(fragment);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8StackTableModel$2", "customizeCellRenderer"));
            }
        };
    }

    public V8StackTableModel changeLastColumn(@NotNull ColoredTableCellRenderer renderer, @NotNull String header) {
        if (renderer == null) {
            V8StackTableModel.$$$reportNull$$$0(2);
        }
        if (header == null) {
            V8StackTableModel.$$$reportNull$$$0(3);
        }
        this.myLastColumnRenderer = renderer;
        this.HEADERS[this.HEADERS.length - 1] = header;
        return this;
    }

    private void fillData() throws IOException {
        for (V8CpuLogCall v8CpuLogCall : this.myLines) {
            this.myColors.add(FlameColors.getColor(v8CpuLogCall.getStringId(), this.myReader.getCodeScopeByStringId(v8CpuLogCall.getStringId())));
        }
    }

    @Override
    public int getRowCount() {
        return this.myLines.size();
    }

    @Override
    public int getColumnCount() {
        return this.HEADERS.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.HEADERS[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 3) {
            return Long.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public V8CpuLogCall getCall(int row) {
        return this.myLines.get(row);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        V8CpuLogCall call = this.myLines.get(rowIndex);
        if (columnIndex == 0) {
            return call.getCodeState().getPrefix() + call.getFunctionName();
        }
        if (columnIndex == 2) {
            return this.myDurations.size() <= rowIndex ? -1L : this.myDurations.get(rowIndex);
        }
        return call.getDescriptor() != null ? call.getDescriptor().getShortLink() : call.getNotParsedCallable();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        if (column == this.HEADERS.length - 1) {
            return this.myLastColumnRenderer;
        }
        return this.myRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "durations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8StackTableModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "changeLastColumn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

