/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.diff;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.CallTreeType;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.DiffNode;
import com.jetbrains.nodejs.run.profile.cpu.v8log.diff.DiffNodeTreeCellRenderer;
import com.jetbrains.nodejs.run.profile.cpu.view.FilteredByPercent;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8CpuDiffTableModel
implements FilteredByPercent,
TreeTableModelWithCustomRenderer {
    private final DiffNode myRoot;
    private final CallTreeType myCallType;
    private final int myBaseNumTicks;
    private final int myChangedNumTicks;
    private final DiffNodeTreeCellRenderer myRenderer;
    private final List<ColumnInfo> myColumns;
    private Integer myFilterLevel;

    public V8CpuDiffTableModel(DiffNode root, CallTreeType type, int baseNumTicks, int changedNumTicks) {
        this.myRoot = root;
        this.myCallType = type;
        this.myBaseNumTicks = baseNumTicks;
        this.myChangedNumTicks = changedNumTicks;
        this.myRenderer = new DiffNodeTreeCellRenderer();
        if (CallTreeType.topDown.equals((Object)type)) {
            this.myRenderer.setBaseTicks(baseNumTicks);
            this.myRenderer.setChangedTicks(changedNumTicks);
        }
        this.myColumns = CallTreeType.topDown.equals((Object)type) ? V8CpuDiffTableModel.createTopDownColumns((TreeCellRenderer)((Object)this.myRenderer), baseNumTicks, changedNumTicks) : V8CpuDiffTableModel.createBottomUpColumns((TreeCellRenderer)((Object)this.myRenderer));
    }

    public static List<ColumnInfo> createTopDownColumns(final TreeCellRenderer diffCellRenderer, int baseNumTicks, int changedNumTicks) {
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        list.add(new ColumnInfo<Object, Object>(NodeJSBundle.message("profile.cpu.diff_table.column.calls.name", new Object[0])){

            @Nullable
            public Object valueOf(Object node) {
                return node;
            }

            public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
                if (renderer instanceof TreeTableCellRenderer) {
                    ((TreeTableCellRenderer)renderer).setCellRenderer(diffCellRenderer);
                }
                return renderer;
            }
        });
        DiffRenderer alignedRenderer = new DiffRenderer();
        TopDownDiffPercentColumn totalPercentDiff = new TopDownDiffPercentColumn(NodeJSBundle.message("profile.cpu.diff_table.total_perc_diff.column.name", new Object[0]), (TableCellRenderer)((Object)alignedRenderer), baseNumTicks, changedNumTicks){

            @Override
            protected int getTicks(DiffNode.Ticks ticks) {
                return ticks.getTotal();
            }
        };
        TopDownDiffPercentColumn selfPercentDiff = new TopDownDiffPercentColumn(NodeJSBundle.message("profile.cpu.diff_table.self_perc_diff.column.name", new Object[0]), (TableCellRenderer)((Object)alignedRenderer), baseNumTicks, changedNumTicks){

            @Override
            protected int getTicks(DiffNode.Ticks ticks) {
                return ticks.getSelf();
            }
        };
        TicksColumn total = new TicksColumn(NodeJSBundle.message("profile.cpu.diff_table.total.column.name", new Object[0]), (TableCellRenderer)((Object)alignedRenderer)){

            @Override
            protected int getTicks(DiffNode.Ticks ticks) {
                return ticks.getTotal();
            }
        };
        TicksColumn self = new TicksColumn(NodeJSBundle.message("profile.cpu.diff_table.self.column.name", new Object[0]), (TableCellRenderer)((Object)alignedRenderer)){

            @Override
            protected int getTicks(DiffNode.Ticks ticks) {
                return ticks.getSelf();
            }
        };
        list.add(totalPercentDiff);
        list.add(selfPercentDiff);
        list.add(total);
        list.add(self);
        return list;
    }

    private static List<ColumnInfo> createBottomUpColumns(final TreeCellRenderer diffCellRenderer) {
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        list.add(new ColumnInfo<DiffNode, DiffNode>(NodeJSBundle.message("profile.cpu.diff_table.column.calls.name", new Object[0])){

            @Nullable
            public DiffNode valueOf(DiffNode node) {
                return node;
            }

            public TableCellRenderer getCustomizedRenderer(DiffNode o, TableCellRenderer renderer) {
                if (renderer instanceof TreeTableCellRenderer) {
                    ((TreeTableCellRenderer)renderer).setCellRenderer(diffCellRenderer);
                }
                return renderer;
            }
        });
        DiffRenderer alignedRenderer = new DiffRenderer();
        BottomUpPercentDiff percentDiff = new BottomUpPercentDiff(NodeJSBundle.message("profile.cpu.diff_table.parent_perc_diff.column.name", new Object[0]), (TableCellRenderer)((Object)alignedRenderer));
        TicksColumn total = new TicksColumn(NodeJSBundle.message("profile.cpu.diff_table.ticks.column.name", new Object[0]), (TableCellRenderer)((Object)alignedRenderer)){

            @Override
            protected int getTicks(DiffNode.Ticks ticks) {
                return ticks.getTotal();
            }
        };
        list.add(percentDiff);
        list.add(total);
        return list;
    }

    public TreeCellRenderer getRenderer() {
        return this.myRenderer;
    }

    private static String sign(int base, int changed) {
        return base == changed ? "" : (changed > base ? "+" : "");
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(int column, Object o, TableCellRenderer renderer) {
        return this.myColumns.get(column).getCustomizedRenderer(o, renderer);
    }

    public int getColumnCount() {
        return this.myColumns.size();
    }

    public String getColumnName(int column) {
        return this.myColumns.get(column).getName();
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns.get(column).valueOf(node);
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public void setTree(JTree tree) {
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof DiffNode) {
            return this.getFilteredChildren((DiffNode)parent).get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof DiffNode) {
            return this.getFilteredChildren((DiffNode)parent).size();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof DiffNode) {
            List<DiffNode> children = this.getFilteredChildren((DiffNode)parent);
            for (int i = 0; i < children.size(); ++i) {
                DiffNode node = children.get(i);
                if (node != child) continue;
                return i;
            }
            return 0;
        }
        return 0;
    }

    private List<DiffNode> getFilteredChildren(DiffNode parent) {
        if (this.myFilterLevel == null || this.myFilterLevel == 0) {
            return parent.getChildren();
        }
        ArrayList<DiffNode> result = new ArrayList<DiffNode>();
        for (DiffNode node : parent.getChildren()) {
            boolean include = false;
            if (node.getAfter() != null) {
                include = this.tensPercent(node.getAfter(), false) >= this.myFilterLevel;
            } else if (node.getBefore() != null) {
                include |= this.tensPercent(node.getBefore(), true) >= this.myFilterLevel;
            }
            if (!include) continue;
            result.add(node);
        }
        return result;
    }

    int tensPercent(DiffNode.Ticks ticks, boolean isBefore) {
        if (CallTreeType.bottomUp.equals((Object)this.myCallType)) {
            return V8Utils.tensPercent(ticks.getTotal(), ticks.getNumParentTicks());
        }
        return V8Utils.tensPercent(ticks.getTotal(), isBefore ? this.myBaseNumTicks : this.myChangedNumTicks);
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    @Override
    public boolean isFiltered() {
        return this.myFilterLevel != null;
    }

    @Override
    public int getTensPercentLevelInclusive() {
        return this.myFilterLevel == null ? 0 : this.myFilterLevel;
    }

    @Override
    public void clearFilter() {
        this.myFilterLevel = null;
    }

    @Override
    public void filterByLevel(int tensPercentLevelInclusive) {
        this.myFilterLevel = tensPercentLevelInclusive;
    }

    private static abstract class TicksColumn
    extends ColumnInfo<Object, Object> {
        private final TableCellRenderer myAlignedRenderer;

        TicksColumn(@NlsContexts.ColumnName String name, TableCellRenderer renderer) {
            super(name);
            this.myAlignedRenderer = renderer;
        }

        protected abstract int getTicks(DiffNode.Ticks var1);

        @Nullable
        public Object valueOf(Object o) {
            if (o instanceof DiffNode) {
                DiffNode node = (DiffNode)o;
                if (node.isAdded()) {
                    return this.getTicks(node.getAfter());
                }
                if (node.isDeleted()) {
                    return this.getTicks(node.getBefore());
                }
                return this.getTicks(node.getBefore()) + "/" + this.getTicks(node.getAfter());
            }
            return "";
        }

        public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
            return this.myAlignedRenderer;
        }
    }

    private static class BottomUpPercentDiff
    extends ColumnInfo<Object, Object> {
        private final TableCellRenderer myAlignedRenderer;

        BottomUpPercentDiff(@NlsContexts.ColumnName String name, TableCellRenderer renderer) {
            super(name);
            this.myAlignedRenderer = renderer;
        }

        @Nullable
        public Object valueOf(Object object) {
            if (object instanceof DiffNode) {
                DiffNode node = (DiffNode)object;
                if (node.isAdded()) {
                    String percent = "+" + V8Utils.formatPercent(V8Utils.tensPercent(node.getAfter().getTotal(), node.getAfter().getNumParentTicks()));
                    return Pair.create((Object)percent, null);
                }
                if (node.isDeleted()) {
                    String percent = "-" + V8Utils.formatPercent(V8Utils.tensPercent(node.getBefore().getTotal(), node.getBefore().getNumParentTicks()));
                    return Pair.create((Object)percent, null);
                }
                int base = V8Utils.tensPercent(node.getBefore().getTotal(), node.getBefore().getNumParentTicks());
                int changed = V8Utils.tensPercent(node.getAfter().getTotal(), node.getAfter().getNumParentTicks());
                if (base == 0 && changed == 0) {
                    return Pair.create((Object)"0%", null);
                }
                return Pair.create((Object)(V8CpuDiffTableModel.sign(base, changed) + V8Utils.formatPercent(changed - base)), (Object)(V8Utils.formatPercent(base) + "/" + V8Utils.formatPercent(changed)));
            }
            return "";
        }

        public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
            return this.myAlignedRenderer;
        }
    }

    private static abstract class TopDownDiffPercentColumn
    extends ColumnInfo<Object, Object> {
        private final TableCellRenderer myAlignedRenderer;
        private final int myChangedNumTicks;
        private final int myBaseNumTicks;

        TopDownDiffPercentColumn(@NlsContexts.ColumnName String name, TableCellRenderer renderer, int baseNumTicks, int changedNumTicks) {
            super(name);
            this.myAlignedRenderer = renderer;
            this.myChangedNumTicks = changedNumTicks;
            this.myBaseNumTicks = baseNumTicks;
        }

        protected abstract int getTicks(DiffNode.Ticks var1);

        @Nullable
        public Object valueOf(Object object) {
            if (object instanceof DiffNode) {
                DiffNode node = (DiffNode)object;
                if (node.isAdded()) {
                    String percent = "+" + V8Utils.formatPercent(V8Utils.tensPercent(this.getTicks(node.getAfter()), this.myChangedNumTicks));
                    return Pair.create((Object)percent, null);
                }
                if (node.isDeleted()) {
                    String percent = "-" + V8Utils.formatPercent(V8Utils.tensPercent(this.getTicks(node.getBefore()), this.myBaseNumTicks));
                    return Pair.create((Object)percent, null);
                }
                int base = V8Utils.tensPercent(this.getTicks(node.getBefore()), this.myBaseNumTicks);
                int changed = V8Utils.tensPercent(this.getTicks(node.getAfter()), this.myChangedNumTicks);
                if (base == 0 && changed == 0) {
                    return Pair.create((Object)"0%", null);
                }
                return Pair.create((Object)(V8CpuDiffTableModel.sign(base, changed) + V8Utils.formatPercent(changed - base)), (Object)(V8Utils.formatPercent(base) + "/" + V8Utils.formatPercent(changed)));
            }
            return "";
        }

        public TableCellRenderer getCustomizedRenderer(Object o, TableCellRenderer renderer) {
            return this.myAlignedRenderer;
        }
    }

    static class DiffRenderer
    extends ColoredTableCellRenderer {
        private final SimpleTextAttributes mySelectedBold = SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES.derive(1, null, null, null);
        private final SimpleTextAttributes mySelectedGreyBold = SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES.derive(1, SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor(), null, null);
        private final SimpleTextAttributes myGreyBold = SimpleTextAttributes.GRAY_ATTRIBUTES.derive(1, null, null, null);

        DiffRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (table == null) {
                DiffRenderer.$$$reportNull$$$0(0);
            }
            this.setTextAlign(4);
            if (value instanceof Pair) {
                @NlsSafe String fragment = ((Pair)value).getFirst().toString();
                this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                if (((Pair)value).getSecond() != null) {
                    this.append("  " + ((Pair)value).getSecond(), SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            } else if (value != null) {
                @NlsSafe String fragment = value.toString();
                this.append(fragment, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/nodejs/run/profile/cpu/v8log/diff/V8CpuDiffTableModel$DiffRenderer", "customizeCellRenderer"));
        }
    }
}

